/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.binding.Binding;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableBuilding;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import java.util.List;
import org.apache.log4j.Logger;

public class ParameterizerHelper {
    public static final String FIELD_PARAMETERIZER = "parameterizer";
    public static final String FIELD_PARAMETERIZED = "parameterized";
    public static final String FIELD_PARAMETERIZER_FORMAT_FORMAT = "format";
    public static final String FIELD_PARAMETERIZER_FORMAT_PARAMETERIZED_EXSPRESSION = "parameterizedExspression";
    public static final TableFormat PARAMETERIZER_FORMAT = new TableFormat(1, 1);

    public static final DataTable createDataTable(String format, String expression) {
        TableFormat tableFormat = new TableFormat(format, new ClassicEncodingSettings(true));
        return ParameterizerHelper.createDataTable(tableFormat, expression);
    }

    public static final DataTable createDataTable(TableFormat tableFormat, String expression) {
        DataRecord rec = new DataRecord(DataTableBuilding.TABLE_FORMAT);
        rec.addInt(0);
        rec.addInt(Integer.MAX_VALUE);
        rec.addDataTable(DataTableBuilding.formatToFieldsTable(tableFormat, false, new ClassicEncodingSettings(true)));
        rec.addBoolean(false);
        rec.addBoolean(false);
        List<Binding> bindingsLst = tableFormat.getBindings();
        if (bindingsLst != null) {
            SimpleDataTable bindings = new SimpleDataTable(DataTableBuilding.BINDINGS_FORMAT);
            for (Binding binding : bindingsLst) {
                DataRecord bindRec = new DataRecord(DataTableBuilding.BINDINGS_FORMAT);
                bindRec.addValue(binding.getTarget());
                bindRec.addValue(binding.getExpression());
                bindings.addRecord(bindRec);
            }
            rec.addDataTable(bindings);
        }
        SimpleDataTable parameterizer = new SimpleDataTable(PARAMETERIZER_FORMAT);
        parameterizer.addRecord(rec.wrap(), expression);
        return parameterizer;
    }

    public static TableFormat getParametersTableFormat(Context context, CallerController caller, Logger logger) {
        TableFormat tableFormat = null;
        try {
            DataTable childInfo = context.getVariable("childInfo", caller);
            DataTable parameterizer = childInfo.rec().getDataTable(FIELD_PARAMETERIZER);
            DataTable parametrizerFormatTable = parameterizer.rec().getDataTable(FIELD_PARAMETERIZER_FORMAT_FORMAT);
            tableFormat = DataTableBuilding.createTableFormat(parametrizerFormatTable, new ClassicEncodingSettings(true), true);
        }
        catch (ContextException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return tableFormat;
    }

    public static boolean isParameterizedContext(Context context, CallerController caller, Logger logger) {
        boolean isParameterized = false;
        try {
            DataTable childInfo = context.getVariable("childInfo", caller);
            isParameterized = childInfo.rec().getBoolean(FIELD_PARAMETERIZED);
        }
        catch (ContextException ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return isParameterized;
    }

    static {
        FieldFormat ff = FieldFormat.create(FIELD_PARAMETERIZER_FORMAT_FORMAT, 'T', Cres.get().getString(FIELD_PARAMETERIZER_FORMAT_FORMAT)).setHelp(Cres.get().getString("parameterizerFormatHelp"));
        PARAMETERIZER_FORMAT.addField(ff);
        ff = FieldFormat.create(FIELD_PARAMETERIZER_FORMAT_PARAMETERIZED_EXSPRESSION, 'S', Cres.get().getString("parameterizedExpression")).setEditor("text").setEditorOptions("xml").setHelp(Cres.get().getString("parameterizerExpressionHelp"));
        PARAMETERIZER_FORMAT.addField(ff);
    }
}

