/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;

public class NamedThreadFactory
implements ThreadFactory {
    private String name;
    private Integer priority;
    private final ThreadFactory threadFactory = Executors.defaultThreadFactory();

    public NamedThreadFactory() {
    }

    public NamedThreadFactory(String name) {
        this.name = name;
    }

    public NamedThreadFactory(String name, int priority) {
        this.name = name;
        this.priority = priority;
    }

    protected String getName() {
        if (this.name == null) {
            throw new IllegalStateException("No factory name defined");
        }
        return this.name;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = this.threadFactory.newThread(r);
        t.setName(this.getName() + "/" + t.getName());
        t.setDaemon(true);
        if (this.priority != null) {
            t.setPriority(this.priority);
        }
        return t;
    }
}

