/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.util.StringUtils;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogRecord;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;

public class LogRedirectingHandler
extends ConsoleHandler {
    public LogRedirectingHandler() {
        try {
            this.setEncoding(StringUtils.UTF8_CHARSET.name());
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create java.util.logging to log4j redirecting handler", e);
        }
    }

    @Override
    public void publish(LogRecord record) {
        Throwable thrown;
        Logger logger = LogRedirectingHandler.findCorrespondingLogger(record.getLoggerName(), record.getLoggerName());
        if (record.getMessage() == null) {
            record.setMessage(this.digRecordMessage(record));
        }
        String msg = this.getFormatter().format(record);
        Level level = LogRedirectingHandler.convertLogLevel(record.getLevel());
        Throwable throwable = thrown = record.getThrown() == null ? new Throwable() : record.getThrown();
        if (logger != null) {
            if (logger.isEnabled(level)) {
                if (record.getThrown() != null) {
                    logger.log(level, msg, record.getThrown());
                } else {
                    logger.log(level, msg);
                }
            }
        } else {
            logger = LogManager.getLogger((String)"ag.stderr");
            if (logger.isDebugEnabled()) {
                logger.debug("Unexpected logger name: '" + record.getLoggerName() + "'. Log record redirected to '" + Log.CORE + "'");
                logger.debug(record.getLoggerName() + " : " + msg, thrown);
            }
        }
    }

    private String digRecordMessage(LogRecord record) {
        for (Throwable cause = record.getThrown(); cause != null; cause = cause.getCause()) {
            if (cause.getMessage() == null) continue;
            return cause.getMessage();
        }
        return "";
    }

    public static Logger findCorrespondingLogger(String name, String fullName) {
        int psetPos;
        LoggerContext lc = (LoggerContext)LogManager.getContext();
        Logger found = null;
        if (LogManager.exists((String)name) || lc.getConfiguration().getLoggers().containsKey(name)) {
            found = LogManager.getLogger((String)name);
        }
        if (found != null && fullName.startsWith(found.getName())) {
            return found;
        }
        for (psetPos = name.length() - 1; psetPos > 0 && !name.substring(0, psetPos).endsWith("."); --psetPos) {
        }
        if (psetPos == 0) {
            return null;
        }
        String curName = name.substring(0, psetPos - 1);
        return LogRedirectingHandler.findCorrespondingLogger(curName, fullName);
    }

    public static Level convertLogLevel(java.util.logging.Level level) {
        if (level == java.util.logging.Level.CONFIG) {
            return Level.INFO;
        }
        if (level == java.util.logging.Level.SEVERE) {
            return Level.ERROR;
        }
        if (level == java.util.logging.Level.WARNING) {
            return Level.WARN;
        }
        Level converted = Level.toLevel((String)level.getName());
        return converted;
    }
}

