/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.Log;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;

public class JarVersion {
    public static final String BUILD_NUMBER = "Build-Number";
    public static final String REVISION_NUMBER = "Revision-Number";
    public static final JarVersion EMPTY = new JarVersion("", "", null, null, null);
    public final String jarFileName;
    public final String mainClass;
    public final String implementationVersion;
    public final String buildNumber;
    public final String revisionNumber;

    protected JarVersion(String jarFileName, String mainClass, String implementationVersion, String buildNumber, String revisionNumber) {
        this.jarFileName = Objects.requireNonNull(jarFileName);
        this.mainClass = mainClass;
        this.implementationVersion = implementationVersion;
        this.buildNumber = buildNumber;
        this.revisionNumber = revisionNumber;
    }

    protected JarVersion(String jarFileName) {
        this(jarFileName, "", null, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JarVersion create(String jarFileName) {
        JarVersion jarWithoutVersion = new JarVersion(jarFileName);
        if (!Files.isRegularFile(Paths.get(jarFileName, new String[0]), new LinkOption[0])) {
            return jarWithoutVersion;
        }
        try (JarFile jarFile = new JarFile(jarFileName);){
            Manifest manifest = jarFile.getManifest();
            if (null == manifest) {
                JarVersion jarVersion2 = jarWithoutVersion;
                return jarVersion2;
            }
            Attributes mainAttributes = manifest.getMainAttributes();
            String mainClass = mainAttributes.getOrDefault(Attributes.Name.MAIN_CLASS, "");
            String implementationVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            String buildNumber = mainAttributes.getValue(BUILD_NUMBER);
            String revisionNumber = mainAttributes.getValue(REVISION_NUMBER);
            JarVersion jarVersion = new JarVersion(jarFileName, mainClass, implementationVersion, buildNumber, revisionNumber);
            return jarVersion;
        }
        catch (IOException e) {
            Log.STDERR.error((Object)"Error reading jar file", (Throwable)e);
            return jarWithoutVersion;
        }
    }

    public static List<JarVersion> getClassPathJarVersions(List<String> classPath) {
        return classPath.stream().filter(Objects::nonNull).map(JarVersion::create).collect(Collectors.toList());
    }

    public static Optional<JarVersion> getClassPathJarVersionsByTarget(List<String> classPath, String targetClassName) {
        return classPath.stream().filter(Objects::nonNull).map(JarVersion::create).filter(input -> input.mainClass.equals(targetClassName)).findAny();
    }

    public String format() {
        Optional<String> optionalVersion = this.getMostSpecificVersion();
        if (!optionalVersion.isPresent()) {
            return this.jarFileName + " -Unknown";
        }
        String version = optionalVersion.get();
        if (this.jarFileName.toLowerCase().endsWith("-" + version + ".jar")) {
            return this.jarFileName;
        }
        return this.jarFileName + " " + version;
    }

    private Optional<String> getMostSpecificVersion() {
        if (null != this.implementationVersion) {
            return Optional.of(this.implementationVersion);
        }
        if (null != this.buildNumber) {
            return Optional.of(this.buildNumber);
        }
        return Optional.empty();
    }
}

