/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class ErrorCollector {
    public static TableFormat ERRORS = new TableFormat();
    private final List<Exception> errors = new LinkedList<Exception>();

    public void addError(Exception error) {
        this.errors.add(error);
    }

    public List<Exception> getErrors() {
        return this.errors;
    }

    public String toString() {
        return "ErrorCollector{errors=" + this.errors + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorCollector that = (ErrorCollector)o;
        return Objects.equals(this.errors, that.errors);
    }

    public DataTable toDataTable() {
        SimpleDataTable res = new SimpleDataTable(ERRORS);
        for (Exception error : this.errors) {
            res.addRecord(error.getMessage());
        }
        return res;
    }

    public int hashCode() {
        return Objects.hash(this.errors);
    }

    static {
        ERRORS.addField("<message><S>");
    }
}

