/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.encoding.TransferEncodingHelper;
import com.tibbo.aggregate.common.util.StringEncodable;

public class Element
implements StringEncodable {
    private String name;
    private String value;
    private StringEncodable encodable;
    private FieldFormat fieldFormat;
    private Object fieldValue;

    public Element(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public Element(String name, StringEncodable encodable) {
        this.name = name;
        this.encodable = encodable;
    }

    public Element(String name, FieldFormat ff, Object fieldValue) {
        this.name = name;
        this.fieldFormat = ff;
        this.fieldValue = fieldValue;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String encode(ClassicEncodingSettings settings) {
        return new String(this.encode(new StringBuilder(), settings, false, 0));
    }

    public StringBuilder encode(StringBuilder sb, ClassicEncodingSettings settings) {
        return this.encode(sb, settings, false, 0);
    }

    public StringBuilder encode(StringBuilder sb, ClassicEncodingSettings settings, Integer encodeLevel) {
        return this.encode(sb, settings, false, encodeLevel);
    }

    @Override
    public StringBuilder encode(StringBuilder sb, ClassicEncodingSettings settings, Boolean isTransferEncode, Integer encodeLevel) {
        char elNameValSep;
        Boolean useVisibleSeparators = false;
        if (settings != null) {
            useVisibleSeparators = settings.isUseVisibleSeparators();
        }
        char elStart = useVisibleSeparators != false ? (char)'<' : '\u001c';
        char elEnd = useVisibleSeparators != false ? (char)'>' : '\u001d';
        char c = elNameValSep = useVisibleSeparators != false ? (char)'=' : '\u001e';
        if (isTransferEncode.booleanValue()) {
            TransferEncodingHelper.encodeChar(elStart, sb);
            if (this.name != null) {
                TransferEncodingHelper.encode(this.name, sb, (Integer)0);
                TransferEncodingHelper.encodeChar(elNameValSep, sb);
            }
        } else {
            sb.append(elStart);
            if (this.name != null) {
                sb.append(this.name);
                sb.append(elNameValSep);
            }
        }
        if (this.encodable != null) {
            this.encodable.encode(sb, settings, isTransferEncode, encodeLevel);
        } else if (this.fieldFormat != null) {
            this.fieldFormat.valueToEncodedString(this.fieldValue, settings, sb, encodeLevel);
        } else if (isTransferEncode.booleanValue()) {
            TransferEncodingHelper.encode(this.value, sb, encodeLevel);
        } else {
            sb.append(this.value);
        }
        if (isTransferEncode.booleanValue()) {
            TransferEncodingHelper.encodeChar(elEnd, sb);
        } else {
            sb.append(elEnd);
        }
        return sb;
    }

    public String toString() {
        return this.name + "=" + this.value;
    }
}

