/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;

public class DesEncrypter {
    public static final String ENC_KEY = "AGG_ENC_KEY";
    private Cipher ecipher;
    private Cipher dcipher;
    private final byte[] salt = new byte[]{-87, -101, -56, 50, 86, 53, -29, 3};
    private final int iterationCount = 19;
    private final byte[] buf = new byte[1024];
    public static DesEncrypter GLOBAL_ENCRYPTER;

    public DesEncrypter(char[] passPhrase) throws InvalidKeySpecException {
        try {
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase, this.salt, 19);
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            this.ecipher = Cipher.getInstance(key.getAlgorithm());
            this.dcipher = Cipher.getInstance(key.getAlgorithm());
            PBEParameterSpec paramSpec = new PBEParameterSpec(this.salt, 19);
            this.ecipher.init(1, (Key)key, paramSpec);
            this.dcipher.init(2, (Key)key, paramSpec);
        }
        catch (InvalidKeySpecException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error creating DES encrypter: " + ex.getMessage(), ex);
        }
    }

    public OutputStream encryptedStream(OutputStream out) throws IOException {
        return new CipherOutputStream(out, this.ecipher);
    }

    public InputStream decryptedStream(InputStream in) {
        return new CipherInputStream(in, this.dcipher);
    }

    public void encrypt(InputStream in, OutputStream out) throws IOException {
        OutputStream os = this.encryptedStream(out);
        int numRead = 0;
        while ((numRead = in.read(this.buf)) >= 0) {
            os.write(this.buf, 0, numRead);
        }
        os.close();
    }

    public void decrypt(InputStream in, OutputStream out) throws IOException {
        InputStream is = this.decryptedStream(in);
        int numRead = 0;
        while ((numRead = is.read(this.buf)) >= 0) {
            out.write(this.buf, 0, numRead);
        }
        out.close();
    }

    public String encrypt(String str) throws IOException, BadPaddingException, IllegalBlockSizeException {
        byte[] utf8 = str.getBytes(StandardCharsets.UTF_8);
        byte[] enc = this.ecipher.doFinal(utf8);
        return Base64.getEncoder().encodeToString(enc);
    }

    public String decrypt(String str) throws IOException, BadPaddingException, IllegalBlockSizeException {
        byte[] dec = Base64.getDecoder().decode(str);
        byte[] utf8 = this.dcipher.doFinal(dec);
        return new String(utf8, StandardCharsets.UTF_8);
    }

    public byte[] encrypt(byte[] data) throws IOException, BadPaddingException, IllegalBlockSizeException {
        return this.ecipher.doFinal(data);
    }

    public byte[] decrypt(byte[] data) throws IOException, BadPaddingException, IllegalBlockSizeException {
        return this.dcipher.doFinal(data);
    }

    static {
        try {
            String p = System.getenv(ENC_KEY);
            GLOBAL_ENCRYPTER = p == null ? null : new DesEncrypter(p.toCharArray());
        }
        catch (Throwable e) {
            GLOBAL_ENCRYPTER = null;
        }
    }
}

