/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.DataRecord;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class DateUtils {
    public static final String DEFAULT_DATE_PATTERN = "dd.MM.yyyy";
    public static final String DEFAULT_TIME_PATTERN = "HH:mm:ss";
    public static final String DATATABLE_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    public static final HashMap<Object, String> DATE_TIME_FORMATS = new LinkedHashMap<Object, String>();
    public static final HashMap<Object, String> TIME_FORMATS;
    private static final Map<String, String> DATE_FORMAT_REGEXPS;

    public static SimpleDateFormat createDateFormatter() {
        SimpleDateFormat sdf = new SimpleDateFormat(DATATABLE_DATE_PATTERN, Locale.ENGLISH);
        sdf.setTimeZone(UTC_TIME_ZONE);
        return sdf;
    }

    public static String getDateTimePattern(String datePattern, String timePattern) {
        return (datePattern != null ? datePattern : DEFAULT_DATE_PATTERN) + " " + (timePattern != null ? timePattern : DEFAULT_TIME_PATTERN);
    }

    public static Date getStartOfHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndOfHour(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getStartOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getStartOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 2);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(7, 1);
        if (calendar.getTime().before(date)) {
            calendar.add(5, 7);
        }
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getStartOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        calendar.set(5, 1);
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Date getStartOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(6, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public static Date getEndOfYear(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, 1);
        calendar.set(6, 1);
        calendar.add(5, -1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.set(14, 999);
        return calendar.getTime();
    }

    public static Map<Object, String> dateTimeFormats() {
        return DATE_TIME_FORMATS;
    }

    public static Map<Object, String> timeFormats() {
        return TIME_FORMATS;
    }

    public static Date parseSmart(String dateString) throws ParseException {
        String dateFormat = DateUtils.determineDateFormat(dateString);
        if (dateFormat == null) {
            throw new ParseException(Cres.get().getString("utUnknownDateFormat") + dateString, 0);
        }
        return DateUtils.parse(dateString, dateFormat);
    }

    private static Date parse(String dateString, String dateFormat) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        simpleDateFormat.setLenient(false);
        return simpleDateFormat.parse(dateString);
    }

    public static String determineDateFormat(String dateString) {
        for (String regexp : DATE_FORMAT_REGEXPS.keySet()) {
            if (!dateString.toLowerCase().matches(regexp)) continue;
            return DATE_FORMAT_REGEXPS.get(regexp);
        }
        return null;
    }

    public static SimpleDateFormat getPattern(DataRecord field) {
        String editor = field.getString("editor");
        String pattern = DateUtils.getPattern(editor);
        return new SimpleDateFormat(pattern);
    }

    public static String getPattern(String editor) {
        String pattern = "date".equals(editor) ? DEFAULT_DATE_PATTERN : ("time".equals(editor) ? DEFAULT_TIME_PATTERN : DateUtils.getDateTimePattern(DEFAULT_DATE_PATTERN, DEFAULT_TIME_PATTERN));
        return pattern;
    }

    static {
        DATE_TIME_FORMATS.put(null, Cres.get().getString("notSelected"));
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 0)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 1)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 2)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 3)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 0)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 1)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 2)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 3)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 0)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 1)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 2)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 3)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 0)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 1)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 2)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 3)).toPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 1, Locale.UK)).toLocalizedPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 2, Locale.UK)).toLocalizedPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(0, 3, Locale.UK)).toLocalizedPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 1, Locale.UK)).toLocalizedPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 2, Locale.UK)).toLocalizedPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(1, 3, Locale.UK)).toLocalizedPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 1, Locale.UK)).toLocalizedPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 2, Locale.UK)).toLocalizedPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(2, 3, Locale.UK)).toLocalizedPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 1, Locale.UK)).toLocalizedPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 2, Locale.UK)).toLocalizedPattern(), null);
        DATE_TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getDateTimeInstance(3, 3, Locale.UK)).toLocalizedPattern(), null);
        TIME_FORMATS = new LinkedHashMap<Object, String>();
        TIME_FORMATS.put(null, Cres.get().getString("notSelected"));
        TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getTimeInstance(0)).toPattern(), null);
        TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getTimeInstance(1)).toPattern(), null);
        TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getTimeInstance(2)).toPattern(), null);
        TIME_FORMATS.put(((SimpleDateFormat)SimpleDateFormat.getTimeInstance(3)).toPattern(), null);
        DATE_FORMAT_REGEXPS = new HashMap<String, String>(){
            {
                this.put("^\\d{8}$", "yyyyMMdd");
                this.put("^\\d{1,2}-\\d{1,2}-\\d{4}$", "dd-MM-yyyy");
                this.put("^\\d{1,2}\\.\\d{1,2}\\.\\d{4}$", DateUtils.DEFAULT_DATE_PATTERN);
                this.put("^\\d{4}-\\d{1,2}-\\d{1,2}$", "yyyy-MM-dd");
                this.put("^\\d{1,2}/\\d{1,2}/\\d{4}$", "MM/dd/yyyy");
                this.put("^\\d{4}/\\d{1,2}/\\d{1,2}$", "yyyy/MM/dd");
                this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}$", "dd MMM yyyy");
                this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}$", "dd MMMM yyyy");
                this.put("^\\d{12}$", "yyyyMMddHHmm");
                this.put("^\\d{8}\\s\\d{4}$", "yyyyMMdd HHmm");
                this.put("^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}$", "dd-MM-yyyy HH:mm");
                this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}$", "yyyy-MM-dd HH:mm");
                this.put("^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}$", "MM/dd/yyyy HH:mm");
                this.put("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}$", "yyyy/MM/dd HH:mm");
                this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}$", "dd MMM yyyy HH:mm");
                this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}\\s?([ap]m)$", "dd MMM yyyy hh:mm a");
                this.put("^\\d{1,2}-[a-z]{3}-\\d{4}\\s\\d{1,2}:\\d{2}$", "dd-MMM-yyyy HH:mm");
                this.put("^\\d{1,2}-[a-z]{3}-\\d{4}\\s\\d{1,2}:\\d{2}\\s?([ap]m)$", "dd-MMM-yyyy hh:mm a");
                this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}$", "dd MMMM yyyy HH:mm");
                this.put("^\\d{14}$", "yyyyMMddHHmmss");
                this.put("^\\d{8}\\s\\d{6}$", "yyyyMMdd HHmmss");
                this.put("^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd-MM-yyyy HH:mm:ss");
                this.put("^\\d{1,2}\\.\\d{1,2}\\.\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd.MM.yyyy HH:mm:ss");
                this.put("^\\d{1,2}-\\d{1,2}-\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}\\s?([ap]m)$", "dd-MM-yyyy hh:mm:ss a");
                this.put("^\\d{1,2}-[a-z]{3}-\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}\\s?([ap]m)$", "dd-MMM-yyyy hh:mm:ss a");
                this.put("^\\d{1,2}\\.\\d{1,2}\\.\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}\\s?([ap]m)$", "dd.MM.yyyy hh:mm:ss a");
                this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$", "yyyy-MM-dd HH:mm:ss");
                this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}\\s?([ap]m)$", "yyyy-MM-dd hh:mm:ss a");
                this.put("^\\d{1,2}/\\d{1,2}/\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "MM/dd/yyyy HH:mm:ss");
                this.put("^\\d{4}/\\d{1,2}/\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}$", "yyyy/MM/dd HH:mm:ss");
                this.put("^\\d{1,2}\\s[a-z]{3}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd MMM yyyy HH:mm:ss");
                this.put("^\\d{1,2}\\s[a-z]{4,}\\s\\d{4}\\s\\d{1,2}:\\d{2}:\\d{2}$", "dd MMMM yyyy HH:mm:ss");
                this.put("^\\d{4}-\\d{1,2}-\\d{1,2}\\s\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$", DateUtils.DATATABLE_DATE_PATTERN);
                this.put("^\\d{4}-\\d{1,2}-\\d{1,2}-\\d{1,2}:\\d{2}:\\d{2}\\.\\d{3}$", "yyyy-MM-dd-HH:mm:ss.SSS");
                this.put("^(\\d{1,2}:\\d\\d:\\d\\d)$", "H:mm:ss");
                this.put("^(\\d{1,2}:\\d\\d:\\d\\d\\s?([ap]m))$", "h:mm:ss a");
                this.put("^(\\d{1,2}:\\d\\d)$", "H:mm");
                this.put("^(\\d{1,2}:\\d\\d\\s?([ap]m))$", "h:mm a");
                this.put("^(\\d{1,2}.\\d\\d)$", "H.mm");
                this.put("^(\\d{1,2} \\d\\d)$", "H mm");
            }
        };
    }
}

