/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.datatable.AggreGateBean;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.validator.ValidatorHelper;

public class DashboardProperties
extends AggreGateBean {
    public static final String FIELD_NAME = "name";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_LAYOUT = "layout";
    public static final String FIELD_COLUMNS = "columns";
    public static final String FIELD_CLOSABLE = "closable";
    public static final String FIELD_CLEANUP = "cleanup";
    public static final String FIELD_STORAGE_CONTEXT = "storageContext";
    public static final String FIELD_STORAGE_CLASS = "storageClass";
    public static final String FIELD_STORAGE_SESSION_ID = "storageSessionId";
    public static final String FIELD_DEFAULT_EVENT = "defaultEvent";
    public static final String FIELD_STORAGE_INSTANCE_ID = "storageInstanceId";
    public static final String FIELD_DASHBOARD_CONTEXT = "dashboardContext";
    public static final String FIELD_ELEMENT_ID = "elementId";
    public static final String FIELD_PARENT_ELEMENT_ID = "parentElementId";
    public static final String FIELD_CLOSE_DASHBOARD_ON_REOPEN = "closeDashboardOnReopen";
    public static final int LAYOUT_DOCKABLE = 0;
    public static final int LAYOUT_SCROLLABLE = 1;
    public static final int LAYOUT_GRID = 2;
    public static final int LAYOUT_ABSOLUTE = 3;
    public static final int LAYOUT_DOCKABLE_WEB = 4;
    public static final int DESTINATION_WEB = 0;
    public static final int DESTINATION_DESKTOP = 1;
    public static TableFormat FORMAT = new TableFormat(1, 1);
    private String name;
    private String description;
    private int destination;
    private int layout;
    private int columns;
    private boolean closable;
    private boolean cleanup;
    private String storageContext;
    private String storageClass;
    private Long storageSessionId;
    private String defaultEvent;
    private String dashboardContext;
    private String elementId;
    private String parentElementId;
    private boolean closeDashboardOnReopen;

    public boolean isCloseDashboardOnReopen() {
        return this.closeDashboardOnReopen;
    }

    public void setCloseDashboardOnReopen(boolean closeDashboardOnReopen) {
        this.closeDashboardOnReopen = closeDashboardOnReopen;
    }

    public DashboardProperties() {
        super(FORMAT);
    }

    public DashboardProperties(DataRecord data) {
        super(FORMAT, data);
    }

    public DashboardProperties(String name, String description) {
        this();
        this.name = name;
        this.description = description;
    }

    public DashboardProperties(String name, String description, int layout) {
        this(name, description);
        this.layout = layout;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getDestination() {
        return this.destination;
    }

    public void setDestination(int destination) {
        this.destination = destination;
    }

    public int getLayout() {
        return this.layout;
    }

    public void setLayout(int layout) {
        this.layout = layout;
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        this.columns = columns;
    }

    public void setClosable(boolean closable) {
        this.closable = closable;
    }

    public boolean isCleanup() {
        return this.cleanup;
    }

    public void setCleanup(boolean cleanup) {
        this.cleanup = cleanup;
    }

    public boolean isClosable() {
        return this.closable;
    }

    public String toString() {
        return "Dashboard [name=" + this.name + ", description=" + this.description + ", id=" + this.elementId + ", parentId=" + this.parentElementId + ", layout=" + this.layout + "]";
    }

    public String getStorageContext() {
        return this.storageContext;
    }

    public void setStorageContext(String storageContext) {
        this.storageContext = storageContext;
    }

    public String getStorageClass() {
        return this.storageClass;
    }

    public void setStorageClass(String className) {
        this.storageClass = className;
    }

    public Long getStorageSessionId() {
        return this.storageSessionId;
    }

    public void setStorageSessionId(Long storageSessionId) {
        this.storageSessionId = storageSessionId;
    }

    public static String getFieldStorageSessionId() {
        return FIELD_STORAGE_SESSION_ID;
    }

    public String getDefaultEvent() {
        return this.defaultEvent;
    }

    public void setDefaultEvent(String defaultEvent) {
        this.defaultEvent = defaultEvent;
    }

    public String getDashboardContext() {
        return this.dashboardContext;
    }

    public void setDashboardContext(String dashboardContextString) {
        this.dashboardContext = dashboardContextString;
    }

    public String getElementId() {
        return this.elementId;
    }

    public void setElementId(String elementIdString) {
        this.elementId = elementIdString;
    }

    public String getParentElementId() {
        return this.parentElementId;
    }

    public void setParentElementId(String parentElementId) {
        this.parentElementId = parentElementId;
    }

    public DashboardProperties copy() {
        return new DashboardProperties(this.toDataRecord());
    }

    public DashboardProperties copyWithNameAndDescription(String nameString, String descriptionString) {
        DashboardProperties dp = this.copy();
        dp.setName(nameString);
        dp.setDescription(descriptionString);
        return dp;
    }

    static {
        FieldFormat ff = FieldFormat.create("<name><S><F=N><D=" + Cres.get().getString(FIELD_NAME) + ">");
        FORMAT.addField(ff);
        ff = FieldFormat.create("<description><S><F=N><D=" + Cres.get().getString(FIELD_DESCRIPTION) + ">");
        ff.addValidator(ValidatorHelper.DESCRIPTION_LENGTH_VALIDATOR);
        ff.addValidator(ValidatorHelper.DESCRIPTION_SYNTAX_VALIDATOR);
        FORMAT.addField(ff);
        ff = FieldFormat.create("<layout><I><A=0><D=" + Cres.get().getString(FIELD_LAYOUT) + ">");
        FORMAT.addField(ff);
        ff = FieldFormat.create("<columns><I><A=3><D=" + Cres.get().getString(FIELD_COLUMNS) + ">");
        FORMAT.addField(ff);
        FORMAT.addField(FieldFormat.create("<closable><B><A=1><D=" + Cres.get().getString("clDashboardClosable") + ">"));
        FORMAT.addField(FieldFormat.create("<closeDashboardOnReopen><B><D=" + Cres.get().getString("clCloseDashboardOnReopen") + ">").setDefault(false));
        FORMAT.addField(FieldFormat.create("<cleanup><B><F=H>"));
        FORMAT.addField(FieldFormat.create(FIELD_STORAGE_CONTEXT, 'S', Cres.get().getString(FIELD_STORAGE_CONTEXT)).setNullable(true));
        FORMAT.addField(FieldFormat.create(FIELD_STORAGE_CLASS, 'S').setNullable(true).setHidden(true));
        FORMAT.addField(FieldFormat.create(FIELD_STORAGE_SESSION_ID, 'L').setNullable(true).setHidden(true));
        FORMAT.addField(FieldFormat.create(FIELD_DEFAULT_EVENT, 'S').setNullable(true).setHidden(true));
        FORMAT.addField(FieldFormat.create(FIELD_DASHBOARD_CONTEXT, 'S').setNullable(true).setHidden(false));
        FORMAT.addField(FieldFormat.create(FIELD_ELEMENT_ID, 'S').setNullable(true).setHidden(false));
        FORMAT.addField(FieldFormat.create(FIELD_PARENT_ELEMENT_ID, 'S').setNullable(true).setHidden(false));
        FORMAT.setNamingExpression("{description} != null ? {description} : ({name} != null ? {name} : '')");
    }
}

