/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.csvreader.CsvReader;
import com.tibbo.aggregate.common.AggreGateException;
import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.Util;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.commons.io.input.BOMInputStream;

public class CsvImportExportUtils {
    private static final String NULL = "NULL";
    public static final String CSV_IMPORT_FIELD_DELIMITER = "delimiter";
    public static final String CSV_IMPORT_FIELD_USE_QUALIFIER = "useQualifier";
    public static final String CSV_IMPORT_FIELD_QUALIFIER = "qualifier";
    public static final String CSV_IMPORT_FIELD_COMMENT = "comment";
    public static final String CSV_IMPORT_FIELD_ESCAPE_MODE = "escapeMode";
    public static final String CSV_IMPORT_FIELD_HEADER = "header";
    public static final String CSV_EXPORT_FIELD_DELIMITER = "delimiter";
    public static final String CSV_EXPORT_FIELD_USE_QUALIFIER = "useQualifier";
    public static final String CSV_EXPORT_FIELD_QUALIFIER = "qualifier";
    public static final String CSV_EXPORT_FIELD_ESCAPE_MODE = "escapeMode";
    public static final String CSV_EXPORT_FIELD_HEADER = "header";
    public static final String CSV_EXPORT_FIELD_USE_DESCRIPTIONS = "useDescriptions";
    public static final int QUALIFIER_NONE = 0;
    public static final int QUALIFIER_NORMAL = 1;
    public static final int QUALIFIER_FORCE = 2;
    public static final int HEADER_NONE = 0;
    public static final int HEADER_NAMES = 1;
    public static final int HEADER_DESCRIPTIONS = 2;
    public static final int HEADER_SKIP = 3;
    public static TableFormat CSV_EXPORT_FORMAT = new TableFormat(1, 1);
    public static TableFormat CSV_IMPORT_FORMAT;

    private CsvImportExportUtils() {
    }

    public static void readCsvRecords(DataTable table, CsvReader reader, int header, boolean hasMoreRecords) throws AggreGateException, IOException {
        while (hasMoreRecords) {
            DataRecord record = table.addRecord();
            for (int i = 0; i < reader.getColumnCount(); ++i) {
                FieldFormat ff = null;
                if ((header == 0 || header == 3) && record.getFormat().getFieldCount() > i) {
                    ff = record.getFormat().getField(i);
                }
                String headerString = reader.getHeader(i);
                if (header == 1) {
                    ff = record.getFormat().getField(headerString);
                } else if (header == 2) {
                    if (headerString != null) {
                        for (int j = 0; j < table.getFieldCount(); ++j) {
                            FieldFormat cur = record.getFormat().getField(j);
                            if (!headerString.equals(cur.getDescription())) continue;
                            ff = cur;
                            break;
                        }
                    }
                } else {
                    ff = record.getFormat().getField(i);
                }
                if (ff == null) {
                    Log.DATATABLEEDITOR.warn((Object)("Data table field not found for column " + i + " (" + reader.getHeader(i) + ")"));
                    continue;
                }
                String stringValue = reader.get(i);
                try {
                    Object value = stringValue != null && NULL.equals(stringValue.toUpperCase()) ? null : ff.valueFromString(stringValue);
                    record.setValue(ff.getName(), value);
                    continue;
                }
                catch (Exception ex) {
                    if (stringValue == null || !ff.hasSelectionValues()) {
                        throw new AggreGateException(ex.getMessage(), ex);
                    }
                    boolean found = false;
                    Map sv = ff.getSelectionValues();
                    for (Map.Entry entry : sv.entrySet()) {
                        if (!Util.equals(stringValue, entry.getValue())) continue;
                        record.setValue(ff.getName(), entry.getKey());
                        found = true;
                        break;
                    }
                    if (found) continue;
                    throw new AggreGateException(ex.getMessage(), ex);
                }
            }
            hasMoreRecords = reader.readRecord();
        }
    }

    public static CsvReader createCsvReader(byte[] data, char delimiter, boolean useQualifier, char qualifier, int escapeMode, boolean useComments, char comment) {
        CsvReader reader = new CsvReader((InputStream)new BOMInputStream((InputStream)new ByteArrayInputStream(data)), delimiter, StringUtils.UTF8_CHARSET);
        reader.setSkipEmptyRecords(true);
        reader.setUseTextQualifier(useQualifier);
        reader.setTextQualifier(qualifier);
        reader.setUseComments(useComments);
        reader.setComment(comment);
        reader.setEscapeMode(escapeMode);
        return reader;
    }

    public static CsvReader createCsvReader(byte[] data, DataTable options) {
        return CsvImportExportUtils.createCsvReader(data, options.rec().getString("delimiter").charAt(0), options.rec().getBoolean("useQualifier"), options.rec().getString("qualifier").charAt(0), options.rec().getInt("escapeMode"), false, options.rec().getString(CSV_IMPORT_FIELD_COMMENT).charAt(0));
    }

    public static TableFormat readFormat(DataTable original, CsvReader reader, int header) throws IOException {
        TableFormat format;
        TableFormat tableFormat = format = original != null ? original.getFormat().clone() : null;
        if (format == null) {
            format = new TableFormat();
            int numberOfColumns = reader.getHeaders() != null ? reader.getHeaderCount() : reader.getColumnCount();
            for (int i = 0; i < numberOfColumns; ++i) {
                if (header == 1) {
                    CsvImportExportUtils.fillEmptyHeaders(reader);
                    format.addField(FieldFormat.create(reader.getHeader(i), 'S'));
                    continue;
                }
                if (header == 2) {
                    format.addField(FieldFormat.create(String.valueOf(i), 'S', reader.getHeader(i)));
                    continue;
                }
                format.addField(FieldFormat.create(String.valueOf(i), 'S'));
            }
        }
        return format;
    }

    public static boolean fillEmptyHeaders(CsvReader reader) throws IOException {
        if (reader.getHeaders() == null) {
            return false;
        }
        boolean isModified = false;
        for (int i = 0; i < reader.getHeaders().length; ++i) {
            if (reader.getHeader(i) != null && !reader.getHeader(i).isEmpty()) continue;
            String[] headers = reader.getHeaders();
            headers[i] = String.valueOf(i);
            reader.setHeaders(headers);
            isModified = true;
        }
        return isModified;
    }

    static {
        CSV_EXPORT_FORMAT.addField("<delimiter><S><A=;><D=" + Cres.get().getString("ieFieldDelimiter") + "><V=<L=1 1>>");
        CSV_EXPORT_FORMAT.addField("<useQualifier><I><A=1><D=" + Cres.get().getString("ieUseTextQualifier") + "><S=<" + Cres.get().getString("ieDoNotUse") + "=" + 0 + "><" + Cres.get().getString("ieUseWhenNecessary") + "=" + 1 + "><" + Cres.get().getString("ieUseAlways") + "=" + 2 + ">>");
        CSV_EXPORT_FORMAT.addField("<qualifier><S><A=\"><D=" + Cres.get().getString("ieTextQualifier") + "><V=<L=1 1>>");
        CSV_EXPORT_FORMAT.addField("<escapeMode><I><A=1><D=" + Cres.get().getString("ieEscapeMode") + "><S=<" + Cres.get().getString("ieEscBackslash") + "=" + 2 + "><" + Cres.get().getString("ieEscDouble") + "=" + 1 + ">>");
        CSV_EXPORT_FORMAT.addField("<header><I><D=" + Cres.get().getString("ieHeaderRecord") + "><S=<" + Cres.get().getString("none") + "=" + 2 + "><" + Cres.get().getString("ieFieldNames") + "=" + 1 + "><" + Cres.get().getString("ieFieldDescriptions") + "=" + 2 + ">>");
        CSV_EXPORT_FORMAT.addField("<useDescriptions><B><A=0><D=" + Cres.get().getString("ieUseDescriptions") + ">");
        String ref = "qualifier#enabled";
        String exp = "{useQualifier} == 1 || {useQualifier} == 2";
        CSV_EXPORT_FORMAT.addBinding(ref, exp);
        CSV_IMPORT_FORMAT = new TableFormat(1, 1);
        CSV_IMPORT_FORMAT.addField("<delimiter><S><A=;><D=" + Cres.get().getString("ieFieldDelimiter") + "><V=<L=1 1>>");
        CSV_IMPORT_FORMAT.addField("<useQualifier><B><D=" + Cres.get().getString("ieUseTextQualifier") + ">");
        CSV_IMPORT_FORMAT.addField("<qualifier><S><A=\"><D=" + Cres.get().getString("ieTextQualifier") + "><V=<L=1 1>>");
        CSV_IMPORT_FORMAT.addField("<comment><S><A=#><D=" + Cres.get().getString("ieCommentChar") + "><V=<L=1 1>>");
        CSV_IMPORT_FORMAT.addField("<escapeMode><I><A=1><D=" + Cres.get().getString("ieEscapeMode") + "><S=<" + Cres.get().getString("ieEscBackslash") + "=" + 2 + "><" + Cres.get().getString("ieEscDouble") + "=" + 1 + ">>");
        CSV_IMPORT_FORMAT.addField("<header><I><D=" + Cres.get().getString("ieHeaderRecord") + "><S=<" + Cres.get().getString("none") + "=" + 0 + "><" + Cres.get().getString("ieFieldNames") + "=" + 1 + "><" + Cres.get().getString("ieFieldDescriptions") + "=" + 2 + "><" + Cres.get().getString("ieSkip") + "=" + 3 + ">>");
        ref = "qualifier#enabled";
        exp = "{useQualifier}";
        CSV_IMPORT_FORMAT.addBinding(ref, exp);
    }
}

