/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.datatable.DataTableConversion;
import com.tibbo.aggregate.common.datatable.converter.FormatConverter;
import com.tibbo.aggregate.common.util.PublicCloneable;
import java.awt.Color;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class CloneUtils {
    public static Object genericClone(Object object) {
        if (object == null) {
            return null;
        }
        if (Object.class == object.getClass() || object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Character || object instanceof Throwable) {
            return object;
        }
        if (object instanceof PublicCloneable) {
            return ((PublicCloneable)object).clone();
        }
        if (object instanceof Date) {
            return ((Date)object).clone();
        }
        if (object instanceof Color) {
            Color c = (Color)object;
            return new Color(c.getRed(), c.getGreen(), c.getBlue(), c.getAlpha());
        }
        if (object instanceof ArrayList) {
            return ((ArrayList)object).clone();
        }
        if (object instanceof LinkedList) {
            return ((LinkedList)object).clone();
        }
        if (object instanceof HashMap) {
            return ((HashMap)object).clone();
        }
        if (object instanceof Hashtable) {
            return ((Hashtable)object).clone();
        }
        FormatConverter<?> converter = DataTableConversion.getFormatConverter(object.getClass());
        if (converter != null) {
            return converter.clone(object, true);
        }
        if (!(object instanceof Cloneable)) {
            throw new IllegalStateException("Object is not cloneable: " + object + " (" + object.getClass().getName() + ")");
        }
        try {
            if (Log.CORE.isDebugEnabled()) {
                Log.CORE.debug((Object)("Using slow reflection cloning for: " + object.getClass().getName()), (Throwable)new Exception());
            }
            Method method = object.getClass().getMethod("clone", null);
            method.setAccessible(true);
            return method.invoke(object, (Object[])null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static Object deepClone(Object object) {
        if (null == object) {
            return null;
        }
        String classname = object.getClass().getName();
        if ('[' == classname.charAt(0)) {
            if (classname.charAt(1) != '[' && classname.charAt(1) != 'L') {
                switch (classname.charAt(1)) {
                    case 'B': {
                        return ((byte[])object).clone();
                    }
                    case 'Z': {
                        return ((boolean[])object).clone();
                    }
                    case 'C': {
                        return ((char[])object).clone();
                    }
                    case 'S': {
                        return ((short[])object).clone();
                    }
                    case 'I': {
                        return ((int[])object).clone();
                    }
                    case 'J': {
                        return ((long[])object).clone();
                    }
                    case 'F': {
                        return ((float[])object).clone();
                    }
                    case 'D': {
                        return ((double[])object).clone();
                    }
                }
                throw new IllegalStateException("Unknown primitive array class: " + classname);
            }
            int dimension_count = 1;
            while (classname.charAt(dimension_count) == '[') {
                ++dimension_count;
            }
            Class<?> baseClass = null;
            if (classname.charAt(dimension_count) != 'L') {
                baseClass = CloneUtils.getBaseClass(object);
            } else {
                try {
                    baseClass = Class.forName(classname.substring(dimension_count + 1, classname.length() - 1));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException(e.getMessage(), e);
                }
            }
            int[] dimensions = new int[dimension_count];
            dimensions[0] = Array.getLength(object);
            for (int i = 1; i < dimension_count; ++i) {
                dimensions[i] = 0;
            }
            Object copy = Array.newInstance(baseClass, dimensions);
            for (int i = 0; i < dimensions[0]; ++i) {
                Array.set(copy, i, CloneUtils.deepClone(Array.get(object, i)));
            }
            return copy;
        }
        if (object instanceof Collection && object instanceof Cloneable) {
            Collection collection = (Collection)object;
            Collection copy = (Collection)CloneUtils.genericClone(object);
            copy.clear();
            Iterator collection_it = collection.iterator();
            while (collection_it.hasNext()) {
                copy.add(CloneUtils.deepClone(collection_it.next()));
            }
            return copy;
        }
        if (object instanceof Map && object instanceof Cloneable) {
            Map map = (Map)object;
            Map copy = (Map)CloneUtils.genericClone(object);
            copy.clear();
            Iterator collection_it = map.entrySet().iterator();
            Map.Entry entry = null;
            while (collection_it.hasNext()) {
                entry = collection_it.next();
                copy.put(CloneUtils.deepClone(entry.getKey()), CloneUtils.deepClone(entry.getValue()));
            }
            return copy;
        }
        Object copy = CloneUtils.genericClone(object);
        if (null == copy) {
            throw new IllegalStateException("Clone not supported: " + object.getClass().getName());
        }
        return copy;
    }

    private static Class getBaseClass(Object object) {
        if (object == null) {
            return Void.TYPE;
        }
        String className = object.getClass().getName();
        int dims = 0;
        while (className.charAt(dims) == '[') {
            ++dims;
        }
        if (dims == 0) {
            return object.getClass();
        }
        switch (className.charAt(dims)) {
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'L': {
                try {
                    return Class.forName(className.substring(dims + 1, className.length() - 1));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        }
        return null;
    }
}

