/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.Log;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ClassPathHelper {
    private static final String JAVA_LIBRARY_PATH_PROPERTY = "java.library.path";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String PROTOCOL_FILE = "file";

    public static void loadJars(File directory) throws IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        for (String path : ClassPathHelper.listJars(directory)) {
            ClassPathHelper.addToClassPath(path);
        }
    }

    public static List<String> listJars(File directory) {
        if (!directory.isDirectory()) {
            Log.CORE.error((Object)("Error loading JARs from a directory: Not a directory: " + directory));
            return Collections.emptyList();
        }
        LinkedList<String> res = new LinkedList<String>();
        for (File file : directory.listFiles()) {
            if (file.getName().endsWith(JAR_FILE_EXTENSION)) {
                res.add(file.getAbsolutePath());
                continue;
            }
            if (!file.isDirectory()) continue;
            res.addAll(ClassPathHelper.listJars(file));
        }
        return res;
    }

    public static void addToClassPath(URLClassLoader urlClassLoader, String path) throws InvocationTargetException, IllegalAccessException, MalformedURLException, NoSuchMethodException {
        URL u = new URL(PROTOCOL_FILE, null, path);
        Class<URLClassLoader> urlClass = URLClassLoader.class;
        Method method = urlClass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)urlClassLoader, u);
    }

    public static void addToClassPath(String path) throws MalformedURLException, IllegalArgumentException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        Log.CORE.info((Object)("Loading external JAR file: " + path));
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        ClassPathHelper.addToClassPath(urlClassLoader, path);
    }

    public static void addToLibraryPath(String path) throws IllegalArgumentException, IllegalAccessException {
        String newLibPath = path + File.pathSeparator + System.getProperty(JAVA_LIBRARY_PATH_PROPERTY);
        System.setProperty(JAVA_LIBRARY_PATH_PROPERTY, newLibPath);
        try {
            Field fieldSysPath = ClassLoader.class.getDeclaredField("sys_paths");
            fieldSysPath.setAccessible(true);
            if (fieldSysPath != null) {
                fieldSysPath.set(System.class.getClassLoader(), null);
            }
        }
        catch (NoSuchFieldException ex) {
            throw new IllegalStateException("Failed to extend java.library.path:" + ex.getMessage(), ex);
        }
    }
}

