/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.util.ExtendedNumber;
import java.util.LinkedHashMap;
import java.util.Map;

public class ChangeProcessor {
    public static final int GAUGE = 0;
    public static final int COUNTER = 1;
    public static final int DERIVE = 2;
    public static final int ABSOLUTE = 3;
    public static final int OUT_OF_RANGE_IGNORE = 0;
    public static final int OUT_OF_RANGE_DISCARD = 1;
    public static final int OUT_OF_RANGE_NORMALIZE = 2;
    private static Map<Object, String> SELECTION_VALUES = new LinkedHashMap<Object, String>();
    public static final double MAX_32_BIT;
    public static final double MAX_64_BIT;
    private final int type;
    private final int outOfRangeValuesHandling;
    private final Double minValue;
    private final Double maxValue;
    private long lastUpdateTime = 0L;
    private Double lastValue;

    public static final Map<Object, String> getSelectionValues() {
        return SELECTION_VALUES;
    }

    public ChangeProcessor(int type) {
        this(type, 0, null, null);
    }

    public ChangeProcessor(int type, int outOfRangeValuesHandling, Double minValue, Double maxValue) {
        this.type = type;
        this.outOfRangeValuesHandling = outOfRangeValuesHandling;
        this.minValue = outOfRangeValuesHandling == 0 ? null : minValue;
        this.maxValue = outOfRangeValuesHandling == 0 ? null : maxValue;
    }

    public Double process(long newTime, Double newValue) {
        if (newValue == null) {
            return null;
        }
        if (this.lastUpdateTime >= newTime && this.type != 0) {
            return null;
        }
        long oldTime = this.lastUpdateTime;
        Double oldValue = this.lastValue;
        Double updateValue = this.calculateUpdateValue(oldTime, oldValue, newTime, newValue);
        this.lastUpdateTime = newTime;
        return updateValue;
    }

    public ExtendedNumber processExtendedNumber(long newTime, ExtendedNumber newValue) {
        if (newValue == null) {
            return null;
        }
        Double newDoubleValue = newValue.getNumber() != null ? Double.valueOf(newValue.doubleValue()) : null;
        return new ExtendedNumber(this.process(newTime, newDoubleValue), newValue.getQuality(), newValue.getTimestamp());
    }

    private Double calculateUpdateValue(long oldTime, Double oldValue, long newTime, Double newValue) {
        Double updateValue = null;
        if (this.type == 0) {
            updateValue = newValue;
        } else if (this.type == 1) {
            if (newValue != null && oldValue != null) {
                Double diff = newValue - oldValue;
                if (diff < 0.0) {
                    diff = diff + MAX_32_BIT;
                }
                if (diff < 0.0) {
                    diff = diff + (MAX_64_BIT - MAX_32_BIT);
                }
                if (diff >= 0.0) {
                    updateValue = 1000.0 * diff / (double)(newTime - oldTime);
                }
            }
        } else if (this.type == 3) {
            if (newValue != null) {
                updateValue = 1000.0 * newValue / (double)(newTime - oldTime);
            }
        } else if (this.type == 2 && newValue != null && oldValue != null) {
            updateValue = 1000.0 * (newValue - oldValue) / (double)(newTime - oldTime);
        }
        if (updateValue != null) {
            if (this.minValue != null && updateValue < this.minValue) {
                updateValue = this.outOfRangeValuesHandling == 2 ? this.minValue : null;
            } else if (this.maxValue != null && updateValue > this.maxValue) {
                updateValue = this.outOfRangeValuesHandling == 2 ? this.maxValue : null;
            }
        }
        this.lastValue = newValue;
        return updateValue;
    }

    static {
        SELECTION_VALUES.put(0, Cres.get().getString("changeTypeGauge"));
        SELECTION_VALUES.put(1, Cres.get().getString("changeTypeCounter"));
        SELECTION_VALUES.put(2, Cres.get().getString("changeTypeDerive"));
        SELECTION_VALUES.put(3, Cres.get().getString("changeTypeAbsolute"));
        MAX_32_BIT = Math.pow(2.0, 32.0);
        MAX_64_BIT = Math.pow(2.0, 64.0);
    }
}

