/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.context.FunctionDefinition;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AutorunUtils {
    public static List<Context> getAutorunContexts(Context rootContext, CallerController callerController, ContextManager contextManager, String username) {
        FunctionDefinition fd = rootContext.getFunctionDefinition("updateAutorun", callerController);
        if (fd != null) {
            try {
                DataTable contexts = rootContext.callFunction("updateAutorun", callerController);
                ArrayList<Context> result = new ArrayList<Context>();
                for (DataRecord record : contexts) {
                    result.add((Context)rootContext.get(record.getString("path"), callerController));
                }
                if (!result.isEmpty()) {
                    return result;
                }
            }
            catch (ContextException e) {
                Log.SYSTEMTREE.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
        return Collections.singletonList(contextManager.get(ContextUtils.autorunActionsContextPath(username)));
    }
}

