/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.util;

import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public abstract class AggreGateSwingWorker<T>
implements Runnable {
    private T value;

    public T start() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeLater(this);
        }
        return this.value;
    }

    public T execute() {
        try {
            return this.executeWithExceptions();
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException(ex.getCause().getMessage(), ex.getCause());
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public T executeWithExceptions() throws InterruptedException, InvocationTargetException {
        if (SwingUtilities.isEventDispatchThread()) {
            this.run();
        } else {
            SwingUtilities.invokeAndWait(this);
        }
        return this.value;
    }

    @Override
    public abstract void run();

    protected void set(T value) {
        this.value = value;
    }
}

