/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.structure.collector;

import com.google.common.annotations.VisibleForTesting;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.plugin.PluginDirector;
import com.tibbo.aggregate.common.structure.collector.ApplicationStructureCollector;
import com.tibbo.aggregate.common.structure.collector.NoopStructureCollector;
import java.util.Iterator;
import java.util.ServiceLoader;

public class ApplicationStructureLocator {
    @VisibleForTesting
    static final String APPLICATION_STRUCTURE_PLUGIN_ID = "com.tibbo.linkserver.plugin.context.structure";
    private static ApplicationStructureCollector structureCollector = null;

    public static ApplicationStructureCollector obtainStructureCollector(PluginDirector pluginDirector) {
        if (structureCollector != null) {
            return structureCollector;
        }
        ClassLoader pluginClassLoader = null;
        try {
            pluginClassLoader = pluginDirector.getPluginClassLoader(APPLICATION_STRUCTURE_PLUGIN_ID);
        }
        catch (IllegalArgumentException e) {
            Log.STRUCTURE.debug((Object)"Plugin 'context-structure' is not available. No structure info will be collected.");
            structureCollector = NoopStructureCollector.INSTANCE;
        }
        catch (Exception e) {
            Log.STRUCTURE.error((Object)String.format("Unable to find plugin with id '%s'. No info will be collected.", APPLICATION_STRUCTURE_PLUGIN_ID), (Throwable)e);
            structureCollector = NoopStructureCollector.INSTANCE;
        }
        return structureCollector != null ? structureCollector : ApplicationStructureLocator.obtainStructureCollector(pluginClassLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ApplicationStructureCollector obtainStructureCollector(ClassLoader pluginClassLoader) {
        if (structureCollector != null) {
            return structureCollector;
        }
        Class<ApplicationStructureLocator> clazz = ApplicationStructureLocator.class;
        synchronized (ApplicationStructureLocator.class) {
            if (structureCollector == null) {
                try {
                    Iterator<ApplicationStructureCollector> collectorsIterator = ServiceLoader.load(ApplicationStructureCollector.class, pluginClassLoader).iterator();
                    if (collectorsIterator.hasNext()) {
                        structureCollector = collectorsIterator.next();
                        Log.STRUCTURE.info((Object)String.format("Class '%s' is chosen as application structure collector", structureCollector.getClass().getName()));
                        if (collectorsIterator.hasNext()) {
                            Log.STRUCTURE.warn((Object)String.format("Plugin '%s' provides more than one implementation of '%s'. Only the first one will be used: '%s'", APPLICATION_STRUCTURE_PLUGIN_ID, ApplicationStructureCollector.class.getSimpleName(), structureCollector.getClass().getName()));
                        }
                    }
                    if (structureCollector == null) {
                        structureCollector = NoopStructureCollector.INSTANCE;
                        Log.STRUCTURE.info((Object)"No application structure collectors found so no info will be collected");
                    }
                }
                catch (Exception e) {
                    Log.STRUCTURE.error((Object)"Unable to locate structure collector. No info will be collected.", (Throwable)e);
                    structureCollector = NoopStructureCollector.INSTANCE;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return structureCollector;
        }
    }
}

