/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.structure;

import com.google.common.annotations.VisibleForTesting;
import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.expression.Reference;
import com.tibbo.aggregate.common.structure.CallLocation;
import com.tibbo.aggregate.common.structure.OriginKind;
import java.util.Deque;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentLinkedDeque;
import javax.annotation.Nullable;

public class Pinpoint {
    private final Reference origin;
    @Nullable
    private String scope = null;
    @Nullable
    private OriginKind originKind = null;
    private final Deque<CallLocation> callLocations = new ConcurrentLinkedDeque<CallLocation>();

    Pinpoint(Reference origin) {
        this.origin = origin;
    }

    Pinpoint(Reference origin, @Nullable String scope) {
        this.origin = origin;
        this.scope = scope;
    }

    private Pinpoint(Pinpoint toCopy) {
        this.origin = toCopy.origin.clone();
        this.callLocations.addAll(toCopy.callLocations);
        this.originKind = toCopy.originKind;
        this.scope = toCopy.scope;
    }

    public Pinpoint copy() {
        return new Pinpoint(this);
    }

    public Pinpoint withOriginRow(Integer row) {
        Pinpoint newPinpoint = new Pinpoint(this);
        if (row != null) {
            newPinpoint.origin.setRow(row);
        }
        return newPinpoint;
    }

    public Pinpoint withOriginField(String field) {
        return this.withOriginField(field, null);
    }

    public Pinpoint withOriginField(String field, @Nullable OriginKind kind) {
        Pinpoint newPinpoint = new Pinpoint(this);
        newPinpoint.origin.setField(field);
        newPinpoint.originKind = kind;
        return newPinpoint;
    }

    public Pinpoint withScope(String scope) {
        Pinpoint newPinpoint = new Pinpoint(this);
        newPinpoint.scope = scope;
        return newPinpoint;
    }

    public Pinpoint withNestedCell(String nestedField, int nestedRow, OriginKind kind) {
        Pinpoint newPinpoint = new Pinpoint(this);
        newPinpoint.origin.addField(nestedField, nestedRow);
        newPinpoint.originKind = kind;
        return newPinpoint;
    }

    public void pushLocation(CallLocation location) {
        this.callLocations.push(location);
    }

    public void popLocation() {
        this.callLocations.pop();
    }

    public Reference getOrigin() {
        return this.origin;
    }

    @Nullable
    public String getScope() {
        return this.scope;
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        if (this.originKind == OriginKind.REFERENCE) {
            sb.append(Cres.get().getString("reference").toLowerCase());
        } else {
            int i = 0;
            for (CallLocation call : this.callLocations) {
                sb.append(Cres.get().getString("expression").toLowerCase()).append(" '").append(call.getCallText()).append("' ").append(Cres.get().getString("structAtLine")).append(' ').append(call.getLine()).append(", ").append(Cres.get().getString("column")).append(' ').append(call.getColumn()).append(' ').append(Cres.get().getString("structOfExpression"));
                if (++i >= this.callLocations.size()) continue;
                sb.append(' ').append(Cres.get().getString("structResidingIn"));
            }
        }
        if (sb.length() > 0) {
            sb.append(' ').append(Cres.get().getString("structOriginatedFrom")).append(' ');
        }
        sb.append('\'').append(this.origin.getImage()).append('\'');
        if (this.scope != null && !this.scope.isEmpty()) {
            sb.append(" (").append(Cres.get().getString("structScope")).append(": '").append(this.scope).append("')");
        }
        return sb.toString();
    }

    public String toString() {
        return this.asString();
    }

    @Nullable
    @VisibleForTesting
    OriginKind getOriginKind() {
        return this.originKind;
    }

    @VisibleForTesting
    Deque<CallLocation> getCallLocations() {
        return this.callLocations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pinpoint pinpoint = (Pinpoint)o;
        if (!this.origin.equals(pinpoint.origin)) {
            return false;
        }
        if (!Objects.equals(this.scope, pinpoint.scope)) {
            return false;
        }
        if (this.originKind != pinpoint.originKind) {
            return false;
        }
        Iterator<CallLocation> thisIterator = this.callLocations.iterator();
        for (CallLocation otherCallLocation : pinpoint.callLocations) {
            if (otherCallLocation.equals(thisIterator.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = this.origin.hashCode();
        result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
        result = 31 * result + (this.originKind != null ? this.originKind.hashCode() : 0);
        result = 31 * result + this.callLocations.hashCode();
        return result;
    }
}

