/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.sql;

import com.google.common.collect.ImmutableMap;
import com.tibbo.aggregate.common.sql.NotExistSqlTable;
import com.tibbo.aggregate.common.sql.SimpleSqlTable;
import com.tibbo.aggregate.common.sql.SqlTable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SqlTablesMetadata {
    public static final SqlTablesMetadata EMPTY = new SqlTablesMetadata();
    private static final SqlTable EMPTY_SQL_TABLE = new NotExistSqlTable(){};
    private final ImmutableMap<String, SqlTable> tableMap;
    private final String databaseName;

    public SqlTablesMetadata() {
        this.databaseName = null;
        this.tableMap = ImmutableMap.of();
    }

    public SqlTablesMetadata(Connection connection) throws SQLException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        this.initTablesMetadata(connection, (ImmutableMap.Builder<String, SqlTable>)builder);
        this.tableMap = builder.build();
        this.databaseName = connection.getMetaData().getDatabaseProductName();
    }

    private void initTablesMetadata(Connection connection, ImmutableMap.Builder<String, SqlTable> builder) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        try (ResultSet rs = metaData.getTables(connection.getCatalog(), connection.getSchema(), null, null);){
            while (rs.next()) {
                String dbTableName = rs.getString("TABLE_NAME");
                SimpleSqlTable value = new SimpleSqlTable(metaData, dbTableName, connection.getCatalog(), connection.getSchema());
                builder.put((Object)dbTableName.toLowerCase(), (Object)value);
            }
        }
    }

    @Nonnull
    public SqlTable getSqlTable(String name) {
        return (SqlTable)Objects.requireNonNull(this.tableMap.getOrDefault((Object)name.toLowerCase(), (Object)EMPTY_SQL_TABLE));
    }

    public String getDatabaseName() {
        return this.databaseName;
    }
}

