/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.sql;

import java.util.ArrayList;
import java.util.List;

public class SqlTableHierarchyLink {
    private final String childTable;
    private final String parentTable;
    private final List<String> parentPrimaryColumns;
    private final List<String> childForeignColumns;

    public SqlTableHierarchyLink(String childTable, String parentTable) {
        this(childTable, parentTable, new ArrayList<String>(), new ArrayList<String>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SqlTableHierarchyLink(String childTable, String parentTable, List<String> childForeignColumns, List<String> parentPrimaryColumns) {
        this.childTable = childTable;
        this.parentTable = parentTable;
        if (childForeignColumns.size() != parentPrimaryColumns.size()) {
            throw new IllegalArgumentException("Number of foreign columns does not match number of primary columns in the referenced table");
        }
        SqlTableHierarchyLink sqlTableHierarchyLink = this;
        synchronized (sqlTableHierarchyLink) {
            this.childForeignColumns = new ArrayList<String>(childForeignColumns);
            this.parentPrimaryColumns = new ArrayList<String>(parentPrimaryColumns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getParentPrimaryColumns() {
        SqlTableHierarchyLink sqlTableHierarchyLink = this;
        synchronized (sqlTableHierarchyLink) {
            return new ArrayList<String>(this.parentPrimaryColumns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getChildForeignColumns() {
        SqlTableHierarchyLink sqlTableHierarchyLink = this;
        synchronized (sqlTableHierarchyLink) {
            return new ArrayList<String>(this.childForeignColumns);
        }
    }

    public String getChildTable() {
        return this.childTable;
    }

    public String getParentTable() {
        return this.parentTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLink(String childForeignColumn, String parentPrimaryColumn) {
        SqlTableHierarchyLink sqlTableHierarchyLink = this;
        synchronized (sqlTableHierarchyLink) {
            this.parentPrimaryColumns.add(parentPrimaryColumn);
            this.childForeignColumns.add(childForeignColumn);
        }
    }

    public String getPrimaryColumnByForeignColumn(String childForeignColumn) {
        SqlTableHierarchyLink sqlTableHierarchyLink = this;
        synchronized (sqlTableHierarchyLink) {
            assert (this.childForeignColumns.size() == this.parentPrimaryColumns.size());
            for (int i = 0; i < this.childForeignColumns.size(); ++i) {
                if (!this.childForeignColumns.get(i).equals(childForeignColumn)) continue;
                return this.parentPrimaryColumns.get(i);
            }
            throw new IllegalStateException("Column: " + childForeignColumn + " is not found");
        }
    }

    public String getForeignColumnByPrimaryColumn(String parentPrimaryColumn) {
        SqlTableHierarchyLink sqlTableHierarchyLink = this;
        synchronized (sqlTableHierarchyLink) {
            assert (this.childForeignColumns.size() == this.parentPrimaryColumns.size());
            for (int i = 0; i < this.parentPrimaryColumns.size(); ++i) {
                if (!this.parentPrimaryColumns.get(i).equals(parentPrimaryColumn)) continue;
                return this.childForeignColumns.get(i);
            }
            throw new IllegalStateException("Column: " + parentPrimaryColumn + " is not found");
        }
    }
}

