/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.sql;

import com.tibbo.aggregate.common.sql.SqlColumn;
import com.tibbo.aggregate.common.sql.SqlTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class SqlColumnValues {
    private final SqlTable table;
    private final List<SqlColumn> columns = new ArrayList<SqlColumn>();
    private final Map<String, Object> columnValues = new HashMap<String, Object>();

    public SqlColumnValues(SqlTable table) {
        this.table = table;
    }

    public void addColumn(SqlColumn column) {
        this.columns.add(column);
    }

    public void addValue(SqlColumn column, Object value) {
        this.columns.add(column);
        this.columnValues.put(column.getRealName(), value);
    }

    public void fetch(ResultSet rs) throws SQLException {
        for (SqlColumn column : this.columns) {
            Object value = rs.getObject(column.getRealName());
            this.columnValues.put(column.getRealName(), value);
        }
    }

    public List<String> getFullColumnNames() {
        return this.columns.stream().map(c -> this.table.getRealName() + "." + c.getRealName()).collect(Collectors.toList());
    }

    public String getFullColumnNamesList() {
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        boolean first = true;
        for (String s : this.getFullColumnNames()) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(s);
        }
        sb.append(" ");
        return sb.toString();
    }

    public List<String> getColumnNames() {
        return this.columns.stream().map(c -> c.getRealName()).collect(Collectors.toList());
    }

    public List<Object> getColumnValues() {
        return this.columns.stream().map(c -> this.columnValues.get(c.getRealName())).collect(Collectors.toList());
    }

    public SqlTable getTable() {
        return this.table;
    }

    public Map<String, Object> getColumnValuesMap() {
        return this.columnValues;
    }
}

