/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.sql;

import com.tibbo.aggregate.common.sql.SimpleSqlColumn;
import com.tibbo.aggregate.common.sql.SqlColumn;
import com.tibbo.aggregate.common.sql.SqlTable;
import com.tibbo.aggregate.common.sql.SqlTableHierarchyLink;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class SimpleSqlTable
implements SqlTable {
    private final List<SqlColumn> columns = new ArrayList<SqlColumn>();
    private final List<SqlColumn> primaryKeyColumns = new ArrayList<SqlColumn>();
    private final Map<String, SqlTableHierarchyLink> hLinks = new ConcurrentHashMap<String, SqlTableHierarchyLink>();
    private final DatabaseMetaData metaData;
    private final String realName;
    private final String realCatalogName;
    private final String realSchemaName;
    private boolean initialized = false;

    public SimpleSqlTable(DatabaseMetaData metaData, String dbTableName, String realCatalogName, String realSchemaName) throws SQLException {
        this.metaData = metaData;
        this.realName = dbTableName;
        this.realCatalogName = realCatalogName;
        this.realSchemaName = realSchemaName;
    }

    @Override
    public String getRealName() {
        return this.realName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SqlColumn> getColumns() throws SQLException {
        this.initIfRequired();
        SimpleSqlTable simpleSqlTable = this;
        synchronized (simpleSqlTable) {
            return new ArrayList<SqlColumn>(this.columns);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SqlColumn getColumnByName(String name) throws SQLException {
        this.initIfRequired();
        SimpleSqlTable simpleSqlTable = this;
        synchronized (simpleSqlTable) {
            return this.columns.stream().filter(c -> c.getRealName().equalsIgnoreCase(name)).findAny().orElse(null);
        }
    }

    @Override
    public Map<String, SqlTableHierarchyLink> getLinks() throws SQLException {
        this.initIfRequired();
        return Collections.unmodifiableMap(this.hLinks);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.initIfRequired();
        return this.metaData;
    }

    @Override
    public SqlTableHierarchyLink getLinkByTableName(String tableName) throws SQLException {
        this.initIfRequired();
        return this.hLinks.get(tableName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<SqlColumn> getPrimaryKeyColumns() throws SQLException {
        this.initIfRequired();
        SimpleSqlTable simpleSqlTable = this;
        synchronized (simpleSqlTable) {
            return new ArrayList<SqlColumn>(this.primaryKeyColumns);
        }
    }

    private synchronized void initIfRequired() throws SQLException {
        if (this.initialized) {
            return;
        }
        this.processColumns();
        this.processPrimaryKeys();
        this.processReferencedTables();
        this.processHierarchyLinks();
        this.initialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processColumns() throws SQLException {
        try (ResultSet rs = this.metaData.getColumns(this.realCatalogName, this.realSchemaName, this.realName, null);){
            SimpleSqlTable simpleSqlTable = this;
            synchronized (simpleSqlTable) {
                while (rs.next()) {
                    this.columns.add(new SimpleSqlColumn(this, rs.getString("COLUMN_NAME"), rs.getInt("DATA_TYPE"), rs.getString("TYPE_NAME"), rs.getString("IS_NULLABLE").equals("YES"), rs.getString("IS_AUTOINCREMENT").equals("YES"), rs.getString("IS_GENERATEDCOLUMN").equals("YES")));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processReferencedTables() throws SQLException {
        try (ResultSet rs = this.metaData.getImportedKeys(this.realCatalogName, this.realSchemaName, this.realName);){
            SimpleSqlTable simpleSqlTable = this;
            synchronized (simpleSqlTable) {
                while (rs.next()) {
                    String parentTableName = rs.getString("PKTABLE_NAME");
                    String parentPrimaryColumnName = rs.getString("PKCOLUMN_NAME");
                    String childForeignKeyColumnName = rs.getString("FKCOLUMN_NAME");
                    for (SqlColumn c : this.columns) {
                        if (!c.getRealName().equals(childForeignKeyColumnName)) continue;
                        c.setReferencedTableName(parentTableName);
                        c.setParentPrimaryColumnName(parentPrimaryColumnName);
                    }
                }
            }
        }
    }

    private void processHierarchyLinks() {
        for (SqlColumn c : this.columns) {
            if (!c.isForeignKey()) continue;
            if (!this.hLinks.containsKey(c.getReferencedTableName())) {
                this.hLinks.put(c.getReferencedTableName(), new SqlTableHierarchyLink(this.realName, c.getReferencedTableName()));
            }
            this.hLinks.get(c.getReferencedTableName()).addLink(c.getRealName(), c.getParentPrimaryColumnName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPrimaryKeys() throws SQLException {
        try (ResultSet rs = this.metaData.getPrimaryKeys(this.realCatalogName, this.realSchemaName, this.realName);){
            Function<String, String> getCol = name -> {
                try {
                    return rs.getString((String)name);
                }
                catch (SQLException e) {
                    return "";
                }
            };
            SimpleSqlTable simpleSqlTable = this;
            synchronized (simpleSqlTable) {
                while (rs.next()) {
                    SqlColumn column = this.columns.stream().filter(c -> c.getRealName().equals(getCol.apply("COLUMN_NAME"))).findAny().orElse(null);
                    if (column == null) continue;
                    column.setPrimaryKey(true);
                    this.primaryKeyColumns.add(column);
                }
            }
        }
    }

    @Override
    public boolean exists() {
        return true;
    }
}

