/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.sql;

import com.tibbo.aggregate.common.sql.SqlColumn;
import com.tibbo.aggregate.common.sql.SqlTable;
import java.util.Objects;

public final class SimpleSqlColumn
implements SqlColumn {
    private final SqlTable table;
    private final String realName;
    private final String name;
    private final int dataType;
    private final String typeName;
    private volatile String referencedTableName;
    private volatile String parentPrimaryColumnName;
    private volatile boolean isPrimaryKey;
    private volatile boolean isNullable;
    private volatile boolean isAutoIncrement;
    private volatile boolean isGenerated;

    SimpleSqlColumn(SqlTable table, String realName, int dataType, String typeName, boolean isNullable, boolean isAutoIncrement, boolean isGenerated) {
        this.table = table;
        this.realName = realName;
        this.name = realName.toLowerCase();
        this.dataType = dataType;
        this.typeName = typeName;
        this.isNullable = isNullable;
        this.isAutoIncrement = isAutoIncrement;
        this.setGenerated(isGenerated);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public SqlTable getTable() {
        return this.table;
    }

    @Override
    public String getRealName() {
        return this.realName;
    }

    @Override
    public int getDataType() {
        return this.dataType;
    }

    @Override
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    public String getReferencedTableName() {
        return this.referencedTableName;
    }

    @Override
    public void setReferencedTableName(String referencedTableName) {
        this.referencedTableName = referencedTableName;
    }

    @Override
    public boolean isForeignKey() {
        return this.referencedTableName != null;
    }

    @Override
    public String getParentPrimaryColumnName() {
        return this.parentPrimaryColumnName;
    }

    @Override
    public void setParentPrimaryColumnName(String parentPrimaryColumnName) {
        this.parentPrimaryColumnName = parentPrimaryColumnName;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    @Override
    public void setPrimaryKey(boolean primaryKey) {
        this.isPrimaryKey = primaryKey;
    }

    @Override
    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean nullable) {
        this.isNullable = nullable;
    }

    @Override
    public boolean isAutoIncrement() {
        return this.isAutoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.isAutoIncrement = autoIncrement;
    }

    public boolean equals(Object other) {
        return other instanceof SqlColumn && ((SqlColumn)other).getRealName().equals(this.realName) && ((SqlColumn)other).getDataType() == this.dataType && ((SqlColumn)other).getTypeName().equals(this.typeName) && ((SqlColumn)other).getTable().equals(this.getTable());
    }

    public int hashCode() {
        return Objects.hash(this.table, this.dataType, this.realName);
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public void setGenerated(boolean generated) {
        this.isGenerated = generated;
    }

    @Override
    public boolean isString() {
        switch (this.dataType) {
            case -16: 
            case 1: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isNumber() {
        switch (this.dataType) {
            case -6: 
            case -5: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isDataBlock() {
        switch (this.dataType) {
            case -4: 
            case -3: 
            case -2: 
            case 2004: 
            case 2005: {
                return true;
            }
        }
        return false;
    }
}

