/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.sql;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.data.Data;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableBuilding;
import com.tibbo.aggregate.common.datatable.DataTableReplication;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.query.DataTableWrappingUtils;
import com.tibbo.aggregate.common.query.FieldDescriptor;
import com.tibbo.aggregate.common.query.TypeMapper;
import com.tibbo.aggregate.common.sql.SqlSingleFieldHelper;
import com.tibbo.aggregate.common.sql.SqlTablesMetadata;
import com.tibbo.aggregate.common.sql.WrapResult;
import com.tibbo.aggregate.common.util.WatchdogHolder;
import com.tibbo.aggregate.common.view.StorageException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DataTableSqlHelper {
    public static WrapResult wrap(ResultSet rs, CallerController callerController) throws SQLException, StorageException {
        return DataTableSqlHelper.wrap(rs, callerController, null, null, true, false);
    }

    public static WrapResult wrap(ResultSet rs, CallerController callerController, Integer first, Integer count, boolean fixRecords, boolean lazyDataBlockFetching) throws SQLException, StorageException {
        return DataTableSqlHelper.wrap(rs, SqlTablesMetadata.EMPTY, callerController, first, count, fixRecords, lazyDataBlockFetching);
    }

    public static WrapResult wrap(ResultSet rs, SqlTablesMetadata sqlTablesMetadata, CallerController callerController, Integer first, Integer count, boolean fixRecords, boolean lazyDataBlockFetching) throws SQLException, StorageException {
        Map<String, FieldDescriptor> fields = DataTableWrappingUtils.extractResultSetFields(rs, sqlTablesMetadata, false);
        TableFormat rf = DataTableSqlHelper.createTableFormat(fields.values(), callerController);
        SimpleDataTable dataTable = new SimpleDataTable(rf);
        ConcurrentHashMap<Long, SqlSingleFieldHelper> dataBlocks = new ConcurrentHashMap<Long, SqlSingleFieldHelper>();
        Integer fullSize = null;
        if (first != null && !DataTableSqlHelper.scroll(rs, first) || first == null && !rs.next()) {
            return new WrapResult(null, dataTable, dataBlocks);
        }
        int remaining = count != null ? count : Integer.MAX_VALUE;
        int found = 0;
        fullSize = count;
        while (remaining > 0) {
            --remaining;
            ++found;
            if (!WatchdogHolder.getInstance().isEnoughMemory()) {
                throw new StorageException(Cres.get().getString("storageMemoryOverflow") + String.valueOf(found));
            }
            DataRecord record = DataTableSqlHelper.populateRecord(rs, fields.values(), rf);
            if (lazyDataBlockFetching) {
                dataBlocks.putAll(DataTableSqlHelper.extractDataBlocks(record, fields));
            }
            if (!rf.equals(record.getFormat())) {
                rf = record.getFormat().clone();
                dataTable.setFormat(rf);
                for (FieldFormat ff : rf.getFields()) {
                    FieldDescriptor fd = fields.get(ff.getName());
                    TypeMapper.Type curType = TypeMapper.getSqlTypeForFieldFormat(ff.getType());
                    if (fd.getType() == curType) continue;
                    fields.put(fd.getFieldName(), new FieldDescriptor(fd.getColumnName(), fd.getTableName(), fd.getFieldName(), fd.getFieldDescription(), curType, fd.isPrimaryKey()));
                }
            }
            dataTable.addRecord(record);
            if (rs.next()) continue;
            fullSize = (first != null ? first : 1) + found - 1;
            break;
        }
        if (fixRecords) {
            dataTable.fixRecords();
        }
        return new WrapResult(fullSize, dataTable, dataBlocks);
    }

    private static Map<Long, SqlSingleFieldHelper> extractDataBlocks(DataRecord record, Map<String, FieldDescriptor> fieldDescriptorMap) {
        HashMap<Long, SqlSingleFieldHelper> dataBlocks = new HashMap<Long, SqlSingleFieldHelper>();
        record.getFormat().getFields().stream().filter(ff -> ff.getType() == 'A').forEach(fieldFormat -> {
            Data data = record.getData(fieldFormat.getName());
            if (data != null) {
                if (data.getId() == null) {
                    return;
                }
                Map<String, Object> primaryKeys = fieldDescriptorMap.entrySet().stream().filter(e -> ((FieldDescriptor)e.getValue()).isPrimaryKey()).map(Map.Entry::getKey).collect(Collectors.toMap(Function.identity(), record::getValue));
                FieldDescriptor fieldDescriptor = (FieldDescriptor)fieldDescriptorMap.get(fieldFormat.getName());
                SqlSingleFieldHelper sqlDataBlockQuery = new SqlSingleFieldHelper(fieldDescriptor.getTableName(), fieldDescriptor.getColumnName(), primaryKeys);
                dataBlocks.put(data.getId(), sqlDataBlockQuery);
                data.setData(null);
            }
        });
        return dataBlocks;
    }

    private static boolean scroll(ResultSet rs, int first) throws SQLException {
        if (rs.getType() != 1003) {
            return rs.absolute(first);
        }
        int count = 0;
        while (rs.next()) {
            if (++count != first) continue;
            return true;
        }
        return false;
    }

    public static DataRecord populateRecord(ResultSet rs, Collection<FieldDescriptor> fields, TableFormat rf) throws SQLException {
        DataRecord record = new DataRecord(rf);
        int columnIndex = 1;
        for (FieldDescriptor fd : fields) {
            Object value = null;
            String columnName = fd.getColumnName();
            List<FieldFormat> ffs = rf.getFields();
            for (FieldFormat ff : ffs) {
                if (!DataTableWrappingUtils.escapeColumnName(columnName).equals(ff.getName())) continue;
                value = DataTableWrappingUtils.getFieldValue(rs, columnIndex, ff);
                if (value == null && !ff.isNullable()) {
                    throw new SQLException("SQL query returned NULL value for non-nullable field: " + ff);
                }
                if (fd.getType() == TypeMapper.Type.CLOB && value instanceof String) {
                    TableFormat adjustedRF = new TableFormat(rf.getMinRecords(), rf.getMaxRecords());
                    for (FieldFormat fieldFormat : rf.getFields()) {
                        adjustedRF.addField(fieldFormat != ff ? fieldFormat : FieldFormat.create(fieldFormat.getName(), 'S', fieldFormat.getDescription(), fieldFormat.getDefaultValue(), fieldFormat.isNullable()));
                    }
                    DataRecord adjustedRecord = new DataRecord(adjustedRF);
                    DataTableReplication.copyRecord(record, adjustedRecord, true, true);
                    record = adjustedRecord;
                    rf = adjustedRF;
                }
                record.setValue(ff.getName(), value);
                break;
            }
            ++columnIndex;
        }
        return record;
    }

    public static TableFormat createTableFormat(ResultSet rs, CallerController callerController) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        Map<String, FieldDescriptor> fields = DataTableWrappingUtils.extractResultSetFields(rs, false);
        return DataTableSqlHelper.createTableFormat(fields.values(), callerController);
    }

    public static TableFormat createTableFormat(Collection<FieldDescriptor> fields, CallerController callerController) {
        TableFormat rf = new TableFormat();
        for (FieldDescriptor fd : fields) {
            FieldFormat ff = FieldFormat.create(fd.getFieldName(), TypeMapper.getFieldFormatByType(fd.getType()));
            ff.setNullable(true);
            ff.setDescription(fd.getFieldDescription());
            rf.addField(ff);
        }
        return rf;
    }

    public static DataTable convertToOutputFormat(DataTable source, TableFormat outputFormat, boolean addMissingFields, boolean sortBySourceFieldOrder, DataTable viewFields, DataRecord viewRec) {
        SimpleDataTable converted;
        TableFormat newFormat = outputFormat.clone();
        LinkedList<String> removeList = new LinkedList<String>();
        for (FieldFormat newFf : newFormat) {
            FieldFormat origFf = source.getFormat(newFf.getName());
            if (origFf != null) {
                if (!newFf.hasDescription()) {
                    newFf.setDescription(origFf.getDescription());
                }
                if (!origFf.hasSelectionValues() || newFf.hasSelectionValues()) continue;
                for (Object value : origFf.getSelectionValues().keySet()) {
                    newFf.addSelectionValue(newFf.valueFromString(origFf.valueToString(value)), origFf.getSelectionValues().get(value).toString());
                }
                continue;
            }
            if (addMissingFields) continue;
            removeList.add(newFf.getName());
        }
        for (String removeName : removeList) {
            newFormat.removeField(removeName);
        }
        for (FieldFormat<Object> origFf : source.getFormat().clone()) {
            if (newFormat.hasField(origFf.getName())) continue;
            newFormat.addField(origFf);
        }
        if (viewFields != null) {
            for (DataRecord viewField : viewFields) {
                Boolean nullable;
                String columnName = viewField.getString("name").toLowerCase();
                if (!newFormat.hasField(columnName) && viewField.hasField("isCalculatedField") && viewField.getBoolean("isCalculatedField").booleanValue()) {
                    try {
                        newFormat = DataTableSqlHelper.addCalculatedFields(newFormat, viewField);
                    }
                    catch (ContextException e) {
                        Log.DATATABLE.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
                if (!newFormat.hasField(columnName)) continue;
                if (viewField.hasField("readonly")) {
                    Boolean readonly = viewField.getBoolean("readonly");
                    if (readonly != null) {
                        newFormat.getField(columnName).setReadonly(readonly);
                    }
                    newFormat.getField(columnName).setReadonly(viewField.getBoolean("readonly"));
                }
                if (viewField.hasField("nullable") && (nullable = viewField.getBoolean("nullable")) != null) {
                    newFormat.getField(columnName).setNullable(nullable);
                }
                if (!viewField.hasField("visible")) continue;
                newFormat.getField(columnName).setHidden(!viewField.getValueAsString("visible").equals(String.valueOf(1)));
            }
        }
        if (viewRec != null && viewRec.getDataTable("fields") != null && viewRec.getDataTable("fields").getRecordCount() > 0) {
            DataTable orderTable = viewRec.getDataTable("fields");
            TableFormat newReorderFormat = newFormat.clone();
            for (DataRecord orderRec : orderTable) {
                if (!newReorderFormat.hasField(orderRec.getString("name"))) continue;
                newReorderFormat.removeField(orderRec.getString("name"));
            }
            for (int i = 0; i < orderTable.getRecordCount(); ++i) {
                DataRecord orderRec;
                orderRec = orderTable.getRecord(i);
                if (!newFormat.hasField(orderRec.getString("name"))) continue;
                newReorderFormat.addField(newFormat.getField(orderRec.getString("name")));
            }
            newReorderFormat.setBindings(newFormat.getBindings());
            newFormat = newReorderFormat;
        }
        if (sortBySourceFieldOrder) {
            TableFormat sortedFormat = outputFormat.clone();
            for (FieldFormat ff : sortedFormat.getFields()) {
                removeList.add(ff.getName());
            }
            for (String removeName : removeList) {
                sortedFormat.removeField(removeName);
            }
            for (FieldFormat<Object> origFf : source.getFormat().clone()) {
                if (!newFormat.hasField(origFf.getName())) continue;
                sortedFormat.addField(newFormat.getField(origFf.getName()));
            }
            converted = new SimpleDataTable(sortedFormat);
        } else {
            converted = new SimpleDataTable(newFormat);
        }
        DataTableReplication.copy(source, converted, true, true, true);
        return converted;
    }

    public static TableFormat addCalculatedFields(TableFormat fieldFormats, DataRecord colRecord) throws ContextException {
        TableFormat fieldFormatsClone = fieldFormats.clone();
        String formatName = colRecord.getString("name");
        if (!colRecord.hasField("dataTableField") || colRecord.getDataTable("dataTableField") == null || colRecord.getDataTable("dataTableField").getRecordCount() == 0) {
            return fieldFormats;
        }
        TableFormat addFormat = DataTableBuilding.createTableFormat(0, Integer.MAX_VALUE, false, colRecord.getDataTable("dataTableField"), new ClassicEncodingSettings(true));
        if (addFormat != null && addFormat.getFieldCount() > 0) {
            for (FieldFormat ff : addFormat) {
                ff.setName(formatName);
                if (fieldFormatsClone.hasField(formatName)) continue;
                fieldFormatsClone.addField(ff);
            }
        }
        return fieldFormatsClone;
    }
}

