/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.security;

import com.tibbo.aggregate.common.security.Permission;
import com.tibbo.aggregate.common.security.PermissionChecker;
import com.tibbo.aggregate.common.security.RoleRule;
import com.tibbo.aggregate.common.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Permissions
implements Iterable<Permission> {
    public static final char PERMISSIONS_SEPARATOR = ',';
    private final List<Permission> permissions = new LinkedList<Permission>();
    private final ReentrantReadWriteLock permissionsLock = new ReentrantReadWriteLock();
    private Map<String, LinkedList<RoleRule>> roleBasedRXPermissions = new HashMap<String, LinkedList<RoleRule>>();
    private Map<String, LinkedList<RoleRule>> roleBasedRWXPermissions = new HashMap<String, LinkedList<RoleRule>>();
    private Map<String, LinkedList<RoleRule>> roleBasedProhibitions = new HashMap<String, LinkedList<RoleRule>>();
    private boolean useRoleBasedPermissions;
    private boolean isWritePermissions;

    public Permissions() {
    }

    public Permissions(String data, PermissionChecker checker) {
        if (data == null) {
            data = "";
        }
        List<String> pd = StringUtils.split(data, ',');
        for (String pde : pd) {
            String permSrc = pde.trim();
            if (permSrc.length() <= 0) continue;
            this.permissions.add(new Permission(permSrc, checker));
        }
    }

    public Permissions(String context, String type) {
        this.permissions.add(new Permission(context, type));
    }

    public Permissions(List<Permission> permissions, boolean isWritePermissions) {
        for (Permission permission : permissions) {
            this.permissions.add(permission);
        }
        this.isWritePermissions = isWritePermissions;
    }

    public Permissions(String data, boolean isWritePermissions) {
        this(data, (PermissionChecker)null);
        this.isWritePermissions = isWritePermissions;
    }

    public Permissions(String data) {
        this(data, (PermissionChecker)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String encode() {
        StringBuffer enc = new StringBuffer();
        int i = 0;
        this.permissionsLock.readLock().lock();
        try {
            for (Permission perm : this.permissions) {
                if (i > 0) {
                    enc.append(',');
                }
                enc.append(perm.encode());
                ++i;
            }
        }
        finally {
            this.permissionsLock.readLock().unlock();
        }
        return enc.toString();
    }

    public String toString() {
        return this.encode();
    }

    public int size() {
        return this.permissions.size();
    }

    public Permission get(int index) {
        return this.permissions.get(index);
    }

    public Permissions add(Permission permission) {
        this.permissionsLock.writeLock().lock();
        try {
            this.permissions.add(permission);
        }
        finally {
            this.permissionsLock.writeLock().unlock();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Permissions addAll(Permissions permissions) {
        this.permissionsLock.writeLock().lock();
        try {
            for (Permission permission : permissions) {
                this.permissions.add(permission);
            }
        }
        finally {
            this.permissionsLock.writeLock().unlock();
        }
        return this;
    }

    public boolean isWritePermissions() {
        return this.isWritePermissions;
    }

    public void setWritePermissions(boolean isWritePermissions) {
        this.isWritePermissions = isWritePermissions;
    }

    public Map<String, LinkedList<RoleRule>> getRoleBasedRXPermissions() {
        return this.roleBasedRXPermissions;
    }

    public Map<String, LinkedList<RoleRule>> getRoleBasedRWXPermissions() {
        return this.roleBasedRWXPermissions;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }

    public void setRoleBasedRXPermissions(Map<String, LinkedList<RoleRule>> roleBasedPermissions) {
        this.roleBasedRXPermissions = roleBasedPermissions;
    }

    public void setRoleBasedRWXPermissions(Map<String, LinkedList<RoleRule>> roleBasedPermissions) {
        this.roleBasedRWXPermissions = roleBasedPermissions;
    }

    public Map<String, LinkedList<RoleRule>> getRoleBasedProhibitions() {
        return this.roleBasedProhibitions;
    }

    public void setRoleBasedProhibitions(Map<String, LinkedList<RoleRule>> roleBasedProhibitions) {
        this.roleBasedProhibitions = roleBasedProhibitions;
    }

    public boolean isUseRoleBasedPermissions() {
        return this.useRoleBasedPermissions;
    }

    public void setUseRoleBasedPermissions(boolean useRoleBasedPermissions) {
        this.useRoleBasedPermissions = useRoleBasedPermissions;
    }

    @Override
    public Iterator<Permission> iterator() {
        return this.permissions.iterator();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.permissions == null ? 0 : this.permissions.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Permissions other = (Permissions)obj;
        return !(this.permissions == null ? other.permissions != null : !this.permissions.equals(other.permissions));
    }
}

