/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.security;

import com.tibbo.aggregate.common.context.EntityDefinition;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PermissionCache {
    private final Map<String, String> levelByContext = new ConcurrentHashMap<String, String>(16, 0.75f, 16);
    private final Map<String, String> levelByEntity = new ConcurrentHashMap<String, String>(16, 0.75f, 16);
    private final Map<String, Integer> roleBasedLevelByContext = new ConcurrentHashMap<String, Integer>(16, 0.75f, 16);
    private final Map<String, Integer> roleBasedLevelByEntity = new ConcurrentHashMap<String, Integer>(16, 0.75f, 16);

    public String getLevel(String accessedPath, Integer accessedEntityType, String accessedEntity) {
        String level = this.levelByContext.get(accessedPath);
        if (level != null) {
            return level;
        }
        return this.levelByEntity.get(this.createCacheId(accessedPath, accessedEntityType, accessedEntity));
    }

    public void cacheLevel(String accessedPath, Integer accessedEntityType, String accessedEntity, String level, boolean hasPermissionsForEntities) {
        if (hasPermissionsForEntities) {
            this.levelByEntity.put(this.createCacheId(accessedPath, accessedEntityType, accessedEntity), level);
        } else {
            this.levelByContext.put(accessedPath, level);
        }
    }

    public Integer getRoleBasedLevel(String accessedPath, EntityDefinition accessedEntityDefinition) {
        Integer level;
        Integer accessedEntityType = null;
        String accessedEntity = null;
        if (accessedEntityDefinition != null) {
            accessedEntityType = accessedEntityDefinition.getEntityType();
            accessedEntity = accessedEntityDefinition.getName();
        }
        if ((level = this.roleBasedLevelByContext.get(accessedPath)) != null) {
            return level;
        }
        return this.roleBasedLevelByEntity.get(this.createCacheId(accessedPath, accessedEntityType, accessedEntity));
    }

    public void cacheRoleBasedLevel(String accessedPath, Integer accessedEntityType, String accessedEntity, Integer level, boolean hasPermissionsForEntities) {
        if (hasPermissionsForEntities) {
            this.roleBasedLevelByEntity.put(this.createCacheId(accessedPath, accessedEntityType, accessedEntity), level);
        } else {
            this.roleBasedLevelByContext.put(accessedPath, level);
        }
    }

    private String createCacheId(String accessedPath, Integer accessedEntityType, String accessedEntity) {
        String cacheId = accessedPath;
        if (accessedEntityType != null && !accessedEntityType.equals(0)) {
            cacheId = cacheId + ':' + accessedEntityType;
            if (accessedEntity != null && !accessedEntity.equals("")) {
                cacheId = cacheId + ':' + accessedEntity;
            }
        }
        return cacheId;
    }

    public void removeContext(String path) {
        String cacheId;
        this.levelByContext.remove(path);
        Iterator<String> iter = this.levelByEntity.keySet().iterator();
        while (iter.hasNext()) {
            cacheId = iter.next();
            if (!cacheId.startsWith(path + ':')) continue;
            iter.remove();
        }
        this.roleBasedLevelByContext.remove(path);
        iter = this.roleBasedLevelByEntity.keySet().iterator();
        while (iter.hasNext()) {
            cacheId = iter.next();
            if (!cacheId.startsWith(path + ':')) continue;
            iter.remove();
        }
    }

    public Map<String, String> getLevelByContext() {
        return this.levelByContext;
    }

    public Map<String, String> getLevelByEntity() {
        return this.levelByEntity;
    }

    public Map<String, Integer> getRoleBasedlevelByContext() {
        return this.roleBasedLevelByContext;
    }

    public Map<String, Integer> getRoleBasedlevelByEntity() {
        return this.roleBasedLevelByEntity;
    }
}

