/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.security;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.security.PermissionChecker;
import com.tibbo.aggregate.common.util.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class Permission
implements Cloneable {
    public static final char PERMISSION_FIELDS_SEPARATOR = ':';
    private String context;
    private String level;
    private int entityType = 0;
    private String entity = "";
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    public static Map<Integer, String> getUserEntitiesSelectionValues() {
        TreeMap<Integer, String> map = new TreeMap<Integer, String>();
        map.put(0, Cres.get().getString("all"));
        map.put(1, Cres.get().getString("variable"));
        map.put(2, Cres.get().getString("function"));
        map.put(8, Cres.get().getString("action"));
        map.put(4, Cres.get().getString("event"));
        map.put(201, Cres.get().getString("variableGroup"));
        map.put(202, Cres.get().getString("functionGroup"));
        map.put(208, Cres.get().getString("actionGroup"));
        map.put(204, Cres.get().getString("eventGroup"));
        return map;
    }

    public Permission(String data, PermissionChecker checker) {
        List<String> spd = StringUtils.split(data, ':');
        switch (spd.size()) {
            case 1: {
                this.setLevel(spd.get(0));
                break;
            }
            case 2: {
                this.setContext(spd.get(0));
                this.setLevel(spd.get(1));
                break;
            }
            case 3: {
                this.setContext(spd.get(0));
                this.setEntityType(Integer.parseInt(spd.get(1)));
                this.setLevel(spd.get(2));
                break;
            }
            case 4: {
                this.setContext(spd.get(0));
                this.setEntityType(Integer.parseInt(spd.get(1)));
                this.setEntity(spd.get(2));
                this.setLevel(spd.get(3));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid permission: '" + data + "'");
            }
        }
        if (checker != null && !checker.isValid(this.getLevel())) {
            throw new IllegalArgumentException("Invalid permission type: '" + this.level + "'");
        }
    }

    public Permission(String context, String level) {
        this.setContext(context);
        this.setLevel(level);
    }

    public Permission(String context, int entityType, String entity, String level) {
        this.setContext(context);
        this.setEntityType(entityType);
        this.setEntity(entity);
        this.setLevel(level);
    }

    public String encode() {
        String result = "";
        this.lock.readLock().lock();
        try {
            result = this.level;
            if (this.entityType > 0) {
                if (this.entity != null && !this.entity.equals("")) {
                    result = this.entity + ':' + result;
                }
                result = String.valueOf(this.entityType) + ':' + result;
            }
            if (this.context != null) {
                result = this.context + ':' + result;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return result;
    }

    public Permission clone() {
        try {
            return (Permission)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.entity == null ? 0 : this.entity.hashCode());
        result = 31 * result + this.entityType;
        result = 31 * result + (this.level == null ? 0 : this.level.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Permission other = (Permission)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        if (this.entity == null ? other.entity != null : !this.entity.equals(other.entity)) {
            return false;
        }
        if (this.entityType != other.entityType) {
            return false;
        }
        return !(this.level == null ? other.level != null : !this.level.equals(other.level));
    }

    public String toString() {
        return this.encode();
    }

    public String getContext() {
        return this.context;
    }

    public String getLevel() {
        return this.level;
    }

    public void setContext(String entity) {
        this.lock.writeLock().lock();
        try {
            this.context = entity;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void setLevel(String level) {
        this.lock.writeLock().lock();
        try {
            this.level = level;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public int getEntityType() {
        return this.entityType;
    }

    public void setEntityType(int entityType) {
        this.entityType = entityType;
    }

    public String getEntity() {
        return this.entity;
    }

    public void setEntity(String entity) {
        this.entity = entity;
    }
}

