/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.security;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.context.EntityDefinition;
import com.tibbo.aggregate.common.context.UncheckedCallerController;
import com.tibbo.aggregate.common.security.LevelInfo;
import com.tibbo.aggregate.common.security.Permission;
import com.tibbo.aggregate.common.security.PermissionCache;
import com.tibbo.aggregate.common.security.PermissionChecker;
import com.tibbo.aggregate.common.security.PermissionType;
import com.tibbo.aggregate.common.security.Permissions;
import com.tibbo.aggregate.common.security.RoleEntity;
import com.tibbo.aggregate.common.security.RoleRule;
import com.tibbo.aggregate.common.security.RoleRuleInfo;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.Util;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;

public abstract class DefaultPermissionChecker
implements PermissionChecker {
    public static final String NULL_PERMISSIONS = "";
    private PermissionType[] permissionTypes;
    private PermissionType[] rolePermissionTypes;
    private final Logger logger = Log.SECURITY;
    private final CallerController unchecked = new UncheckedCallerController();

    public DefaultPermissionChecker() {
        PermissionType nullType = new PermissionType(Integer.parseInt("00000000", 2), NULL_PERMISSIONS, Cres.get().getString("secNoPerms"));
        this.permissionTypes = new PermissionType[]{nullType};
        this.rolePermissionTypes = new PermissionType[]{nullType};
    }

    protected void setPermissionTypes(PermissionType[] perms) {
        this.permissionTypes = perms;
    }

    protected void setRolePermissionTypes(PermissionType[] perms) {
        this.rolePermissionTypes = perms;
    }

    public static Permissions getNullPermissions() {
        return new Permissions();
    }

    @Override
    public boolean has(CallerController caller, Permissions requiredPermissions, Context accessedContext, EntityDefinition accessedEntityDefinition) {
        try {
            if (caller == null) {
                return requiredPermissions.size() == 0;
            }
            if (!caller.isPermissionCheckingEnabled()) {
                return true;
            }
            Permissions existingPermissions = caller.getPermissions();
            if (existingPermissions == null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Permission level of '" + caller + "' is 'null' and allow nothing, need " + requiredPermissions));
                }
                return false;
            }
            if (existingPermissions.isUseRoleBasedPermissions()) {
                return this.hasWithRoles(requiredPermissions, accessedContext, accessedEntityDefinition, caller);
            }
            if (requiredPermissions == null || requiredPermissions.size() == 0) {
                return true;
            }
            for (Permission required : requiredPermissions) {
                String accessedEntity;
                String accessedPath = this.getAccessedPath(accessedContext, required);
                Integer accessedEntityType = accessedEntityDefinition != null ? accessedEntityDefinition.getEntityType() : null;
                String accessedEntityGroup = accessedEntityDefinition != null ? ContextUtils.getBaseGroup(accessedEntityDefinition.getGroup()) : null;
                String string = accessedEntity = accessedEntityDefinition != null ? accessedEntityDefinition.getName() : null;
                if (accessedPath != null) {
                    String effectiveLevel;
                    String cachedLevel;
                    PermissionCache cache = caller.getPermissionCache();
                    String string2 = cachedLevel = cache != null ? cache.getLevel(accessedPath, accessedEntityType, accessedEntity) : null;
                    if (cachedLevel != null) {
                        effectiveLevel = cachedLevel;
                    } else {
                        ContextManager cm = accessedContext != null ? accessedContext.getContextManager() : null;
                        LevelInfo levelInfo = this.getLevelInfo(existingPermissions, accessedPath, accessedEntityType, accessedEntity, accessedEntityGroup, cm);
                        Boolean hasPermissionsForEntities = levelInfo.hasPermissionsForEntities();
                        effectiveLevel = levelInfo.getLevel();
                        if (cache != null && accessedContext != null && this.equalsPaths(accessedPath, accessedContext)) {
                            cache.cacheLevel(accessedPath, accessedEntityType, accessedEntity, effectiveLevel, hasPermissionsForEntities);
                        }
                    }
                    if (this.hasNecessaryLevel(effectiveLevel, required.getLevel())) continue;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Permissions '" + existingPermissions + "' doesn't allow '" + requiredPermissions + "' (because effective level '" + effectiveLevel + "' in '" + accessedPath + "' doesn't allow '" + required + "')"));
                    }
                    return false;
                }
                if (existingPermissions.size() != 1) {
                    throw new IllegalStateException("Required permissions doesn't include context specification, so existing permissions should include exactly one element");
                }
                Permission existing = existingPermissions.iterator().next();
                if (this.hasNecessaryLevel(existing.getLevel(), required.getLevel())) continue;
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Permissions '" + existingPermissions + "' doesn't allow '" + requiredPermissions + "' (because '" + existing + "' doesn't allow '" + required + "')"));
                }
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            Log.SECURITY.error((Object)"Error checking permissions: ", (Throwable)ex);
            return false;
        }
    }

    private boolean hasWithRoles(Permissions requiredPermissions, Context accessedContext, EntityDefinition accessedEntityDefinition, CallerController caller) {
        PermissionCache cache = caller.getPermissionCache();
        Integer cachedLevel = cache != null ? cache.getRoleBasedLevel(accessedContext.getPath(), accessedEntityDefinition) : null;
        Integer effectiveLevel = cachedLevel != null ? cachedLevel : Integer.valueOf(this.findAndCacheRule(requiredPermissions, accessedContext, accessedEntityDefinition, caller).getPermission());
        if (effectiveLevel == 3) {
            return true;
        }
        boolean isVariableWriteAttempt = requiredPermissions.isWritePermissions();
        return effectiveLevel == 1 && !isVariableWriteAttempt;
    }

    private RoleRule findAndCacheRule(Permissions requiredPermissions, Context accessedContext, EntityDefinition accessedEntityDefinition, CallerController caller) {
        Permissions existingPermissions = caller.getPermissions();
        PermissionCache cache = caller.getPermissionCache();
        Map<String, LinkedList<RoleRule>> roleBasedRXPermissions = existingPermissions.getRoleBasedRXPermissions();
        Map<String, LinkedList<RoleRule>> roleBasedRWXPermissions = existingPermissions.getRoleBasedRWXPermissions();
        Map<String, LinkedList<RoleRule>> roleBasedProhibitions = existingPermissions.getRoleBasedProhibitions();
        String accessedPath = accessedContext.getPath();
        Integer accessedEntityType = null;
        String accessedEntity = null;
        if (accessedEntityDefinition != null) {
            accessedEntityType = accessedEntityDefinition.getEntityType();
            accessedEntity = accessedEntityDefinition.getName();
        }
        RoleRuleInfo ruleForProhibitionMap = this.findRuleForAccessedObject(roleBasedProhibitions, accessedContext, accessedEntityDefinition);
        boolean hasRulesForEntities = ruleForProhibitionMap.hasRulesForEntities();
        if (ruleForProhibitionMap.ruleFound()) {
            int level = ruleForProhibitionMap.getRoleRule().getPermission();
            cache.cacheRoleBasedLevel(accessedPath, accessedEntityType, accessedEntity, level, hasRulesForEntities);
            return ruleForProhibitionMap.getRoleRule();
        }
        RoleRuleInfo ruleForRWXPermissionMap = this.findRuleForAccessedObject(roleBasedRWXPermissions, accessedContext, accessedEntityDefinition);
        hasRulesForEntities |= ruleForRWXPermissionMap.hasRulesForEntities();
        if (ruleForRWXPermissionMap.ruleFound()) {
            int level = ruleForRWXPermissionMap.getRoleRule().getPermission();
            cache.cacheRoleBasedLevel(accessedPath, accessedEntityType, accessedEntity, level, hasRulesForEntities);
            return ruleForRWXPermissionMap.getRoleRule();
        }
        RoleRuleInfo ruleForRXPermissionMap = this.findRuleForAccessedObject(roleBasedRXPermissions, accessedContext, accessedEntityDefinition);
        hasRulesForEntities |= ruleForRXPermissionMap.hasRulesForEntities();
        if (ruleForRXPermissionMap.ruleFound()) {
            int level = ruleForRXPermissionMap.getRoleRule().getPermission();
            cache.cacheRoleBasedLevel(accessedPath, accessedEntityType, accessedEntity, level, hasRulesForEntities);
            return ruleForRXPermissionMap.getRoleRule();
        }
        return new RoleRule();
    }

    private RoleRuleInfo findRuleForAccessedObject(Map<String, LinkedList<RoleRule>> roleBasedMap, Context accessedContext, EntityDefinition accessedEntityDefinition) {
        String accessedPath = accessedContext.getPath();
        String accessed\u0421ontextType = accessedContext.getType();
        Integer accessedEntityType = null;
        String accessedEntityGroup = null;
        String accessedEntity = null;
        RoleRuleInfo roleRuleInfo = new RoleRuleInfo();
        if (accessedEntityDefinition != null) {
            accessedEntityType = accessedEntityDefinition.getEntityType();
            accessedEntityGroup = accessedEntityDefinition.getGroup();
            accessedEntity = accessedEntityDefinition.getName();
        }
        for (String mask : roleBasedMap.keySet()) {
            for (String allowedPath : this.getAllowedPaths(mask, accessedContext.getContextManager())) {
                if (!ContextUtils.matchesToMask(allowedPath, accessedPath, false, false)) continue;
                LinkedList<RoleRule> rules = roleBasedMap.get(mask);
                RoleRuleInfo foundRule = this.findRuleForAccessedObject(rules, accessed\u0421ontextType, accessedEntityType, accessedEntity, accessedEntityGroup);
                if (foundRule.hasRulesForEntities()) {
                    roleRuleInfo.setHasRulesForEntities(true);
                }
                if (!foundRule.ruleFound()) continue;
                roleRuleInfo.setRoleRule(foundRule.getRoleRule());
                roleRuleInfo.setCorrespondingMask(mask);
                return roleRuleInfo;
            }
        }
        return roleRuleInfo;
    }

    private RoleRuleInfo findRuleForAccessedObject(LinkedList<RoleRule> rules, String accessed\u0421ontextType, Integer accessedEntityType, String accessedEntity, String accessedEntityGroup) {
        RoleRuleInfo foundRuleInfo = new RoleRuleInfo();
        for (RoleRule rule : rules) {
            if (!rule.getContextType().equals(accessed\u0421ontextType) && !"*".equals(rule.getContextType())) continue;
            if (rule.getEntityType() != 0) {
                foundRuleInfo.setHasRulesForEntities(true);
            }
            if (!this.checkEntity(rule.getEntityType(), rule.getEntity(), accessedEntityType, accessedEntity, accessedEntityGroup) || !this.checkExceptions(rule.getRuleExceptions(), accessedEntityType, accessedEntity, accessedEntityGroup)) continue;
            foundRuleInfo.setRoleRule(rule);
            return foundRuleInfo;
        }
        return foundRuleInfo;
    }

    private boolean checkExceptions(HashSet<RoleEntity> exceptions, Integer accessedEntityType, String accessedEntity, String accessedEntityGroup) {
        for (RoleEntity exception : exceptions) {
            if (!this.checkEntity(exception.getEntityType(), exception.getEntity(), accessedEntityType, accessedEntity, accessedEntityGroup)) continue;
            return false;
        }
        return true;
    }

    private boolean checkLevel(int level, boolean isVariableWriteAttempt) {
        if (isVariableWriteAttempt) {
            return level == 3;
        }
        return true;
    }

    private boolean checkEntity(int entityType, String entity, Integer accessedEntityType, String accessedEntity, String accessedEntityGroup) {
        if (entityType == 0) {
            return true;
        }
        if (!Objects.equals(entityType, accessedEntityType)) {
            boolean isContextAccess;
            boolean bl = isContextAccess = accessedEntityType == null;
            if (isContextAccess) {
                boolean hasVariableAccess = entityType == 1 || entityType == 201;
                boolean hasAccessToAllVariables = hasVariableAccess && NULL_PERMISSIONS.equals(entity);
                return hasAccessToAllVariables;
            }
        } else if (NULL_PERMISSIONS.equals(entity) || Objects.deepEquals(accessedEntity, entity)) {
            return true;
        }
        boolean entityTypeMatchByGroup = accessedEntityType != null && accessedEntityType + 200 == entityType;
        boolean groupMatch = NULL_PERMISSIONS.equals(entity) || Objects.equals(accessedEntityGroup, entity) || Objects.equals(ContextUtils.getBaseGroup(accessedEntityGroup), entity);
        return entityTypeMatchByGroup && groupMatch;
    }

    private boolean equalsPaths(String accessedPath, Context accessedContext) {
        return Util.equals(accessedPath, accessedContext.getPath());
    }

    private String getAccessedPath(Context accessedContext, Permission permission) {
        if (permission.getContext() != null) {
            return permission.getContext();
        }
        return accessedContext != null ? accessedContext.getPath() : null;
    }

    @Override
    public String getLevel(Permissions permissions, String accessedContext, Integer accessedEntityType, String accessedEntity, String accessedEntityGroup, ContextManager cm) throws SecurityException {
        return this.getLevelInfo(permissions, accessedContext, accessedEntityType, accessedEntity, accessedEntityGroup, cm).getLevel();
    }

    public LevelInfo getLevelInfo(Permissions existingPermissions, String accessedContext, Integer accessedEntityType, String accessedEntity, String accessedEntityGroup, ContextManager cm) throws SecurityException {
        boolean hasPermissionsForEntities = false;
        Integer permissionIndex = 0;
        try {
            if (existingPermissions == null) {
                return new LevelInfo(NULL_PERMISSIONS, hasPermissionsForEntities, (int)permissionIndex);
            }
            for (Permission permission : existingPermissions) {
                if (permission.getContext() == null) {
                    return new LevelInfo(permission, hasPermissionsForEntities, (int)permissionIndex);
                }
                for (String allowedPath : this.getAllowedPaths(permission.getContext(), cm)) {
                    boolean groupMatch;
                    boolean entityMatch;
                    if (!this.permissionMatchesToMask(allowedPath, accessedContext)) continue;
                    int allowedEntityType = permission.getEntityType();
                    if (allowedEntityType == 0) {
                        return new LevelInfo(permission, hasPermissionsForEntities, (int)permissionIndex);
                    }
                    hasPermissionsForEntities = true;
                    String allowedEntity = permission.getEntity();
                    boolean entityTypeMatch = accessedEntityType != null && accessedEntityType == allowedEntityType;
                    boolean bl = entityMatch = NULL_PERMISSIONS.equals(allowedEntity) || Objects.equals(accessedEntity, allowedEntity);
                    if (entityTypeMatch && entityMatch) {
                        return new LevelInfo(permission, hasPermissionsForEntities, (int)permissionIndex);
                    }
                    boolean entityTypeMatchByGroup = accessedEntityType != null && accessedEntityType + 200 == allowedEntityType;
                    boolean bl2 = groupMatch = NULL_PERMISSIONS.equals(allowedEntity) || Objects.equals(accessedEntityGroup, allowedEntity);
                    if (!entityTypeMatchByGroup || !groupMatch) continue;
                    return new LevelInfo(permission, hasPermissionsForEntities, (int)permissionIndex);
                }
                Integer n = permissionIndex;
                Integer n2 = permissionIndex = Integer.valueOf(permissionIndex + 1);
            }
            return new LevelInfo(NULL_PERMISSIONS, hasPermissionsForEntities, (int)permissionIndex);
        }
        catch (Exception ex) {
            throw new SecurityException("Error getting permission type of '" + existingPermissions + "' in '" + accessedContext + "': ", ex);
        }
    }

    private boolean permissionMatchesToMask(String allowedPath, String accessedContext) {
        return ContextUtils.matchesToMask(allowedPath, accessedContext, true, false);
    }

    @Override
    public boolean canSee(Permissions permissions, String context, ContextManager cm) {
        try {
            if (permissions == null) {
                return false;
            }
            for (Permission permission : permissions) {
                if (permission.getLevel().equals(NULL_PERMISSIONS)) continue;
                if (permission.getContext() == null) {
                    return true;
                }
                List<String> allowedPaths = this.getAllowedPaths(permission.getContext(), cm);
                for (String allowedPath : allowedPaths) {
                    if (ContextUtils.matchesToMask(allowedPath, context, false, false)) {
                        return false;
                    }
                    if (!ContextUtils.matchesToMask(allowedPath, context, false, true)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception ex) {
            Log.SECURITY.error((Object)"Error checking permissions: ", (Throwable)ex);
            return false;
        }
    }

    public boolean hasNecessaryLevel(String existingLevel, String requiredLevel) {
        int existingLevelPattern = this.findPattern(existingLevel);
        int requiredLevelPattern = this.findPattern(requiredLevel);
        return (requiredLevelPattern & existingLevelPattern) == requiredLevelPattern;
    }

    private int findPattern(String level) throws SecurityException {
        for (int i = 0; i < this.permissionTypes.length; ++i) {
            if (!this.permissionTypes[i].getName().equals(level)) continue;
            return this.permissionTypes[i].getPattern();
        }
        throw new SecurityException("Permission level '" + level + "' not found");
    }

    @Override
    public boolean isValid(String level) {
        try {
            for (int i = 0; i < this.permissionTypes.length; ++i) {
                if (!this.permissionTypes[i].getName().equals(level)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public Map<Object, String> getPermissionLevels() {
        LinkedHashMap<Object, String> pm = new LinkedHashMap<Object, String>();
        for (int i = 0; i < this.permissionTypes.length; ++i) {
            pm.put(this.permissionTypes[i].getName(), this.permissionTypes[i].getDescription());
        }
        return pm;
    }

    @Override
    public Map<String, String> getRolePermissionLevels(int entityType) {
        LinkedHashMap<String, String> pm = new LinkedHashMap<String, String>();
        pm.put(this.rolePermissionTypes[0].getName(), Cres.get().getString("secNoPerms"));
        if (entityType == 208 || entityType == 8 || entityType == 202 || entityType == 2) {
            pm.put(this.rolePermissionTypes[1].getName(), Cres.get().getString("secExecute"));
        } else if (entityType == 201 || entityType == 1) {
            pm.put(this.rolePermissionTypes[1].getName(), Cres.get().getString("secRead"));
            pm.put(this.rolePermissionTypes[2].getName(), Cres.get().getString("secWrite"));
        } else if (entityType == 204 || entityType == 4) {
            pm.put(this.rolePermissionTypes[1].getName(), Cres.get().getString("secRead"));
        } else if (entityType == 0) {
            pm.put(this.rolePermissionTypes[1].getName(), Cres.get().getString("secRead") + "/" + Cres.get().getString("secExecute"));
            pm.put(this.rolePermissionTypes[2].getName(), Cres.get().getString("secAll"));
        }
        return pm;
    }

    @Override
    public String canActivate(Permissions existingPermissions, Permissions requiredPermissions, ContextManager cm) {
        String entity;
        int entityType;
        String context;
        String canNotSetPermissionsMessage = "Cannot set permissions for '%s' to '%s' because your own permission level for '%s' is '%s'";
        for (Permission requiredPermission : requiredPermissions) {
            String requiredPermissionLevel;
            context = requiredPermission.getContext();
            entityType = requiredPermission.getEntityType();
            entity = requiredPermission.getEntity();
            String existingPermissionLevel = this.getLevel(existingPermissions, context, entityType, entity, null, cm);
            if (this.hasNecessaryLevel(existingPermissionLevel, requiredPermissionLevel = this.getLevel(requiredPermissions, context, entityType, entity, null, cm))) continue;
            String requiredEntityInfo = StringUtils.removeSuffix(requiredPermission.encode(), ':' + requiredPermissionLevel);
            return String.format(canNotSetPermissionsMessage, requiredEntityInfo, requiredPermissionLevel, requiredEntityInfo, existingPermissionLevel);
        }
        for (Permission existingPermission : existingPermissions) {
            context = existingPermission.getContext();
            entityType = existingPermission.getEntityType();
            entity = existingPermission.getEntity();
            String requiredPermissionLevel = this.getLevel(requiredPermissions, context, entityType, entity, null, cm);
            String existingPermissionLevel = this.getLevel(existingPermissions, context, entityType, entity, null, cm);
            if (this.hasNecessaryLevel(existingPermissionLevel, requiredPermissionLevel)) continue;
            String requiredEntityInfo = StringUtils.removeSuffix(existingPermission.encode(), ':' + existingPermissionLevel);
            return String.format(canNotSetPermissionsMessage, requiredEntityInfo, requiredPermissionLevel, requiredEntityInfo, existingPermissionLevel);
        }
        return null;
    }

    protected List<String> getAllowedPaths(String context, ContextManager cm) {
        String truncated;
        Object groupContext;
        if (cm != null && context.endsWith(".*") && (groupContext = cm.get(truncated = context.substring(0, context.length() - 2), this.unchecked)) != null && groupContext.isMapped()) {
            LinkedList<String> allowedPaths = new LinkedList<String>();
            for (Context mappedChild : groupContext.getMappedChildren(this.unchecked)) {
                allowedPaths.add(mappedChild.getPath());
            }
            return allowedPaths;
        }
        return Collections.singletonList(context);
    }
}

