/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.security;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.FunctionDefinition;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;

public class AuthUtils {
    public static String getCorrectUsername(String username, ContextManager contextManager, CallerController callerController) {
        if (contextManager == null || callerController == null) {
            return username;
        }
        Object rootContext = contextManager.getRoot();
        FunctionDefinition fd = rootContext.getFunctionDefinition("sessionGet");
        if (fd == null) {
            return username;
        }
        DataRecord parameters = new DataRecord(fd.getInputFormat()).addString("username");
        try {
            DataTable result = rootContext.callFunction(fd.getName(), callerController, parameters.wrap());
            if (result != null && result.getRecordCount() > 0) {
                username = result.rec().getString("value");
            }
        }
        catch (ContextException e) {
            Log.SECURITY.warn((Object)e.getMessage(), (Throwable)e);
        }
        return username;
    }
}

