/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.resource;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.resource.ResourceManager;
import com.tibbo.aggregate.common.util.ReflectUtils;
import com.tibbo.aggregate.common.util.Util;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public class WrappingResourceBundle
extends ResourceBundle {
    private String baseName;
    private final PropertyResourceBundle wrapped;
    private final Map<String, String> replacements = new ConcurrentHashMap<String, String>();

    public WrappingResourceBundle(PropertyResourceBundle wrapped) {
        this.wrapped = wrapped;
        ResourceManager.process(this);
        ResourceManager.add(this);
    }

    public void addReplacement(String key, String value) {
        this.replacements.put(key, value);
    }

    @Override
    protected Object handleGetObject(String key) {
        if (this.replacements.containsKey(key)) {
            return this.replacements.get(key);
        }
        try {
            Object value = this.wrapped.handleGetObject(key);
            if (value != null) {
                return value;
            }
            return this.getEnglishValue(key);
        }
        catch (Exception ex) {
            Log.RESOURCE.warn((Object)("Missing resource: " + key + " in " + this.wrapped.getClass().getName()));
            return this.getEnglishValue(key);
        }
    }

    private Object getEnglishValue(String key) {
        try {
            PropertyResourceBundle englishBundle;
            Object value;
            if (this.baseName == null) {
                this.baseName = ReflectUtils.getPrivateField(this.wrapped, "name").toString();
            }
            return (value = (englishBundle = (PropertyResourceBundle)WrappingResourceBundle.getBundle(this.baseName, Locale.ENGLISH)).handleGetObject(key)) != null ? value : key;
        }
        catch (Exception ex) {
            Log.RESOURCE.warn((Object)("Error getting resource: " + key), (Throwable)new Exception());
            return key;
        }
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.wrapped.getKeys();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WrappingResourceBundle other = (WrappingResourceBundle)obj;
        return Util.equals(this.getClass().getName(), other.getClass().getName());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }
}

