/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.resource;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.resource.JarVerifier;
import com.tibbo.aggregate.common.resource.WrappingResourceBundle;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.LocaleUtils;

public class ResourceManager {
    private static final String CERTIFICATE_FILE_NAME = "customization.cer";
    public static final String ICON_FILE_EXTENSION = "png";
    public static final String CUSTOMIZATION_RESOURCES_FILENAME = "custom.jar";
    public static final String CLIENT_CUSTOMIZATION_RESOURCES_FILENAME = "custom-client.jar";
    private static final String REPLACEMENTS_RESOURCE_NAME = "replacements.txt";
    private static Class RESOURCE_CLASS;
    private static Map<String, byte[]> RESOURCES;
    private static Map<String, String> REPLACEMENTS;
    private static Map<String, ImageIcon> ICON_CACHE;
    private static List<WrappingResourceBundle> BUNDLES;
    private static Locale LOCALE;

    public static void initialize(Class resClass) {
        RESOURCE_CLASS = resClass;
        RESOURCES = new Hashtable<String, byte[]>();
    }

    public static void initialize(URI customizationUrl, Class resClass) {
        ResourceManager.initialize(resClass);
        Log.CORE.debug((Object)("Starting resource manager, customization file " + customizationUrl));
        try {
            ResourceManager.processCustomizationFile(customizationUrl);
        }
        catch (Exception ex) {
            throw new IllegalStateException("Error processing customization file '" + customizationUrl + "': ", ex);
        }
        for (WrappingResourceBundle bundle : BUNDLES) {
            ResourceManager.process(bundle);
        }
    }

    private static void processCustomizationFile(URI customizationUrl) throws IOException, CertificateException {
        try {
            if (customizationUrl == null) {
                return;
            }
            InputStream is = customizationUrl.toURL().openStream();
            BufferedInputStream bis = new BufferedInputStream(is);
            JarInputStream jis = new JarInputStream((InputStream)bis, true);
            JarEntry je = null;
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            X509Certificate certificate = (X509Certificate)certificateFactory.generateCertificate(ResourceManager.class.getResourceAsStream(CERTIFICATE_FILE_NAME));
            Manifest man = jis.getManifest();
            if (man == null) {
                jis.close();
                throw new SecurityException("The customization file is not signed");
            }
            while ((je = jis.getNextJarEntry()) != null) {
                if (je.isDirectory()) continue;
                byte[] bytes = new byte[1024];
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                int read = -1;
                while ((read = jis.read(bytes)) != -1) {
                    baos.write(bytes, 0, read);
                }
                Log.RESOURCE.debug((Object)("Found customization package entry: " + je.getName() + ""));
                JarVerifier.verify(je, new X509Certificate[]{certificate});
                if (je.getName().equals(REPLACEMENTS_RESOURCE_NAME)) {
                    String sub;
                    Log.RESOURCE.debug((Object)"Found string resource replacements");
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(baos.toByteArray()), StandardCharsets.UTF_8));
                    while ((sub = br.readLine()) != null) {
                        try {
                            String[] parts = sub.split("=", 2);
                            REPLACEMENTS.put(parts[0].trim(), parts[1].trim());
                            Log.RESOURCE.debug((Object)("Found string replacement: '" + parts[0] + "' => '" + parts[1] + "'"));
                        }
                        catch (Exception ex1) {
                            Log.RESOURCE.error((Object)("Error processing replacement: " + sub), (Throwable)ex1);
                        }
                    }
                    continue;
                }
                RESOURCES.put(je.getName(), baos.toByteArray());
            }
            jis.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static ImageIcon getImageIcon(String id) {
        if (id == null) {
            return null;
        }
        return ResourceManager.getImageIcon(id, ICON_FILE_EXTENSION);
    }

    private static synchronized ImageIcon getImageIcon(String id, String extension) {
        String name = id + "." + extension;
        try {
            URL url;
            ImageIcon cached = ICON_CACHE.get(name);
            if (cached != null) {
                return cached;
            }
            byte[] res = ResourceManager.getResource(name);
            if (res != null) {
                ImageIcon icon = new ImageIcon(Toolkit.getDefaultToolkit().createImage(res));
                ICON_CACHE.put(name, icon);
                return icon;
            }
            URL uRL = url = RESOURCE_CLASS != null ? RESOURCE_CLASS.getResource(name) : null;
            if (url == null) {
                return null;
            }
            ImageIcon icon = new ImageIcon(url);
            ICON_CACHE.put(name, icon);
            return icon;
        }
        catch (Exception ex) {
            Log.RESOURCE.error((Object)("Error getting icon: " + name), (Throwable)ex);
            return null;
        }
    }

    public static byte[] getResource(String name) {
        return RESOURCES != null ? RESOURCES.get(name) : null;
    }

    public static void process(WrappingResourceBundle bundle) {
        for (Map.Entry<String, String> entry : REPLACEMENTS.entrySet()) {
            bundle.addReplacement(entry.getKey(), entry.getValue());
        }
    }

    public static void add(WrappingResourceBundle bundle) {
        BUNDLES.add(bundle);
    }

    public static Locale getLocale() {
        return LOCALE;
    }

    public static void putIconToCache(String name, ImageIcon icon) {
        ICON_CACHE.put(name, icon);
    }

    static {
        REPLACEMENTS = new LinkedHashMap<String, String>();
        ICON_CACHE = new HashMap<String, ImageIcon>();
        BUNDLES = new LinkedList<WrappingResourceBundle>();
        LOCALE = Locale.ENGLISH;
        try {
            String language = System.getProperty("user.language");
            if (language != null) {
                LOCALE = LocaleUtils.toLocale((String)language);
            }
        }
        catch (Exception ex) {
            Log.CORE.error((Object)"Error setting up locale", (Throwable)ex);
        }
    }
}

