/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.resource;

import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import java.util.jar.JarEntry;

public class JarVerifier {
    public static void verify(JarEntry je, X509Certificate[] trustedCaCerts) throws IOException, CertificateException {
        if (je.isDirectory()) {
            return;
        }
        Certificate[] certs = je.getCertificates();
        if (certs == null || certs.length == 0) {
            if (!je.getName().startsWith("META-INF")) {
                throw new SecurityException("Unsigned entry: " + je.getName());
            }
        } else {
            X509Certificate[] chainRoots = JarVerifier.getChainRoots(certs);
            boolean signedAsExpected = false;
            for (int i = 0; i < chainRoots.length; ++i) {
                if (!JarVerifier.isTrusted(chainRoots[i], trustedCaCerts)) continue;
                signedAsExpected = true;
                break;
            }
            if (!signedAsExpected) {
                throw new SecurityException("The JAR is not signed by a trusted signer");
            }
        }
    }

    public static boolean isTrusted(X509Certificate cert, X509Certificate[] trustedCaCerts) {
        int i;
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!cert.getSubjectDN().equals(trustedCaCerts[i].getSubjectDN()) || !cert.equals(trustedCaCerts[i])) continue;
            return true;
        }
        for (i = 0; i < trustedCaCerts.length; ++i) {
            if (!cert.getIssuerDN().equals(trustedCaCerts[i].getSubjectDN())) continue;
            try {
                cert.verify(trustedCaCerts[i].getPublicKey());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static X509Certificate[] getChainRoots(Certificate[] certs) {
        Vector<X509Certificate> result = new Vector<X509Certificate>(3);
        for (int i = 0; i < certs.length - 1; ++i) {
            if (((X509Certificate)certs[i + 1]).getSubjectDN().equals(((X509Certificate)certs[i]).getIssuerDN())) continue;
            result.addElement((X509Certificate)certs[i]);
        }
        result.addElement((X509Certificate)certs[certs.length - 1]);
        Object[] ret = new X509Certificate[result.size()];
        result.copyInto(ret);
        return ret;
    }
}

