/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.query;

import java.util.LinkedHashMap;
import org.apache.log4j.Logger;

public abstract class TypeMapper {
    private static Logger logger = Logger.getLogger(TypeMapper.class);
    private static LinkedHashMap<Character, Type> fieldFormatToSQL = new LinkedHashMap();
    private static LinkedHashMap<Type, Character> sqlToFieldFormat = new LinkedHashMap();
    private static LinkedHashMap<Type, String> fieldFormatToSQLString = new LinkedHashMap();
    private static LinkedHashMap<Integer, Type> sqlTypeToType = new LinkedHashMap();

    public static char getFieldFormatByType(Type t) {
        Character type = sqlToFieldFormat.get((Object)t);
        if (type != null) {
            return type.charValue();
        }
        throw new IllegalArgumentException("Unsupported type: " + (Object)((Object)t));
    }

    public static Type getSqlTypeForFieldFormat(char fieldFormat) {
        if (!fieldFormatToSQL.containsKey(Character.valueOf(fieldFormat))) {
            return null;
        }
        return fieldFormatToSQL.get(Character.valueOf(fieldFormat));
    }

    public static String getSqlStringForFieldFormat(char fieldFormat) {
        if (!fieldFormatToSQL.containsKey(Character.valueOf(fieldFormat))) {
            throw new IllegalArgumentException("Unsupported fieldFormat: " + fieldFormat);
        }
        Type type = fieldFormatToSQL.get(Character.valueOf(fieldFormat));
        return fieldFormatToSQLString.get((Object)type);
    }

    public static Type getTypeForSqlType(int sqlType) {
        if (!sqlTypeToType.containsKey(sqlType)) {
            logger.debug((Object)("Unsupported SQL type: " + sqlType));
            return Type.VARCHAR;
        }
        return sqlTypeToType.get(sqlType);
    }

    public static String getSqlStringForType(Type t) {
        if (!fieldFormatToSQLString.containsKey((Object)t)) {
            return null;
        }
        return fieldFormatToSQLString.get((Object)t);
    }

    static {
        fieldFormatToSQL.put(Character.valueOf('I'), Type.INTEGER);
        fieldFormatToSQL.put(Character.valueOf('S'), Type.VARCHAR);
        fieldFormatToSQL.put(Character.valueOf('B'), Type.BOOLEAN);
        fieldFormatToSQL.put(Character.valueOf('L'), Type.LONG);
        fieldFormatToSQL.put(Character.valueOf('F'), Type.REAL);
        fieldFormatToSQL.put(Character.valueOf('E'), Type.DOUBLE);
        fieldFormatToSQL.put(Character.valueOf('D'), Type.TIMESTAMP);
        fieldFormatToSQL.put(Character.valueOf('T'), Type.CLOB);
        sqlToFieldFormat.put(Type.INTEGER, Character.valueOf('I'));
        sqlToFieldFormat.put(Type.VARCHAR, Character.valueOf('S'));
        sqlToFieldFormat.put(Type.BOOLEAN, Character.valueOf('B'));
        sqlToFieldFormat.put(Type.LONG, Character.valueOf('L'));
        sqlToFieldFormat.put(Type.REAL, Character.valueOf('F'));
        sqlToFieldFormat.put(Type.DOUBLE, Character.valueOf('E'));
        sqlToFieldFormat.put(Type.TIMESTAMP, Character.valueOf('D'));
        sqlToFieldFormat.put(Type.CLOB, Character.valueOf('T'));
        sqlToFieldFormat.put(Type.BIGINT, Character.valueOf('L'));
        sqlToFieldFormat.put(Type.BLOB, Character.valueOf('A'));
        fieldFormatToSQLString.put(Type.INTEGER, "INTEGER");
        fieldFormatToSQLString.put(Type.LONG, "NUMERIC(20)");
        fieldFormatToSQLString.put(Type.VARCHAR, "VARCHAR(16777216)");
        fieldFormatToSQLString.put(Type.BOOLEAN, "BOOLEAN");
        fieldFormatToSQLString.put(Type.BIGINT, "NUMERIC(20)");
        fieldFormatToSQLString.put(Type.REAL, "REAL");
        fieldFormatToSQLString.put(Type.DOUBLE, "DOUBLE");
        fieldFormatToSQLString.put(Type.TIMESTAMP, "TIMESTAMP");
        fieldFormatToSQLString.put(Type.CLOB, "LONGVARCHAR");
        sqlTypeToType.put(-6, Type.INTEGER);
        sqlTypeToType.put(5, Type.INTEGER);
        sqlTypeToType.put(4, Type.INTEGER);
        sqlTypeToType.put(-5, Type.LONG);
        sqlTypeToType.put(12, Type.VARCHAR);
        sqlTypeToType.put(16, Type.BOOLEAN);
        sqlTypeToType.put(-7, Type.BOOLEAN);
        sqlTypeToType.put(2, Type.DOUBLE);
        sqlTypeToType.put(7, Type.REAL);
        sqlTypeToType.put(8, Type.DOUBLE);
        sqlTypeToType.put(3, Type.REAL);
        sqlTypeToType.put(93, Type.TIMESTAMP);
        sqlTypeToType.put(-1, Type.CLOB);
        sqlTypeToType.put(-16, Type.CLOB);
        sqlTypeToType.put(2004, Type.BLOB);
        sqlTypeToType.put(-2, Type.BLOB);
        sqlTypeToType.put(-3, Type.BLOB);
        sqlTypeToType.put(-4, Type.BLOB);
    }

    public static enum Type {
        INTEGER,
        VARCHAR,
        BOOLEAN,
        BIGINT,
        REAL,
        TIMESTAMP,
        CLOB,
        BLOB,
        LONG,
        DOUBLE;

    }
}

