/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.query;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.data.Data;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.query.FieldDescriptor;
import com.tibbo.aggregate.common.query.TypeMapper;
import com.tibbo.aggregate.common.sql.SqlTable;
import com.tibbo.aggregate.common.sql.SqlTablesMetadata;
import com.tibbo.aggregate.common.util.Util;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class DataTableWrappingUtils {
    private static final Cache<String, String> ESCAPED_COLUMNS_CACHE = CacheBuilder.newBuilder().weakKeys().build();

    public static Map<String, FieldDescriptor> extractResultSetFields(ResultSet rs, boolean uppercase) throws SQLException {
        return DataTableWrappingUtils.extractResultSetFields(rs, SqlTablesMetadata.EMPTY, uppercase);
    }

    public static Map<String, FieldDescriptor> extractResultSetFields(ResultSet rs, SqlTablesMetadata metadata, boolean uppercase) throws SQLException {
        LinkedHashMap<String, FieldDescriptor> result = new LinkedHashMap<String, FieldDescriptor>();
        ResultSetMetaData rsmd = rs.getMetaData();
        HashSet<String> duplicatedFields = new HashSet<String>();
        int columnCount = rsmd.getColumnCount();
        for (int i = 1; i <= columnCount; ++i) {
            String colName = rsmd.getColumnLabel(i);
            String tableName = Optional.ofNullable(rsmd.getTableName(i)).orElse("");
            if (colName == null || colName.isEmpty()) {
                colName = DataTableWrappingUtils.generateUniqueName(result.values(), i, colName);
            }
            int sqlType = rsmd.getColumnType(i);
            TypeMapper.Type type = TypeMapper.getTypeForSqlType(sqlType);
            String columnName = uppercase ? colName.toUpperCase(Locale.ENGLISH) : colName.toLowerCase(Locale.ENGLISH);
            String fieldName = DataTableWrappingUtils.escapeColumnName(colName);
            SqlTable sqlTable = metadata.getSqlTable(tableName);
            boolean isPk = false;
            if (sqlTable.exists()) {
                isPk = sqlTable.getPrimaryKeyColumns().stream().anyMatch(sqlColumn -> sqlColumn.getName().equals(columnName));
            }
            FieldDescriptor fd = new FieldDescriptor(columnName, tableName, fieldName, rsmd.getColumnLabel(i), type, isPk);
            if (result.containsKey(fieldName)) {
                duplicatedFields.add(fieldName);
                continue;
            }
            result.put(fieldName, fd);
        }
        if (!duplicatedFields.isEmpty()) {
            throw new SQLException(MessageFormat.format(Cres.get().getString("errorDuplicatedFields"), ((Object)duplicatedFields).toString()));
        }
        return result;
    }

    public static String escapeColumnName(String columnName) {
        if (columnName == null) {
            return null;
        }
        String result = (String)ESCAPED_COLUMNS_CACHE.getIfPresent((Object)columnName);
        if (result != null) {
            return result;
        }
        StringBuffer r = new StringBuffer(columnName);
        for (int i = 0; i < r.length(); ++i) {
            char c = r.charAt(i);
            if (c == "$".charAt(0)) {
                r.deleteCharAt(i);
                r.setCharAt(i, Character.toUpperCase(r.charAt(i)));
                continue;
            }
            if (!Character.isLetter(c) && !Character.isDigit(c)) {
                c = '_';
            }
            r.setCharAt(i, Character.toLowerCase(c));
        }
        result = r.toString();
        ESCAPED_COLUMNS_CACHE.put((Object)columnName, (Object)result);
        return result;
    }

    public static String generateUniqueName(Collection<FieldDescriptor> result, int i, String colName) throws IllegalStateException {
        String COLUMN_PREFIX = "COLUMN_";
        String resultName = colName;
        resultName = "COLUMN_" + i;
        for (FieldDescriptor fd : result) {
            if (!Util.equals(fd.getColumnName(), resultName)) continue;
            throw new IllegalStateException("Can't generate unique column name");
        }
        return resultName;
    }

    public static Object getFieldValue(ResultSet rs, int columnIndex, FieldFormat ff) throws SQLException {
        char ffType = ff.getType();
        Object value = null;
        switch (ffType) {
            case 'I': {
                Number n = Util.convertToNumber(rs.getObject(columnIndex), false, true);
                value = n != null ? Integer.valueOf(n.intValue()) : null;
                break;
            }
            case 'S': {
                Object obj = rs.getObject(columnIndex);
                if (obj == null) {
                    value = null;
                    break;
                }
                if (obj instanceof Blob) {
                    Blob blob = (Blob)obj;
                    value = new String(blob.getBytes(1L, (int)blob.length()));
                    break;
                }
                if (obj instanceof Clob) {
                    Clob clob = (Clob)obj;
                    value = clob.getSubString(1L, (int)clob.length());
                    break;
                }
                if (obj instanceof byte[]) {
                    value = new String((byte[])obj);
                    break;
                }
                value = obj.toString();
                break;
            }
            case 'B': {
                value = Util.convertToBoolean(rs.getObject(columnIndex), false, true);
                break;
            }
            case 'L': {
                Number n = Util.convertToNumber(rs.getObject(columnIndex), false, true);
                value = n != null ? Long.valueOf(n.longValue()) : null;
                break;
            }
            case 'F': {
                Number n = Util.convertToNumber(rs.getObject(columnIndex), false, true);
                value = n != null ? Float.valueOf(n.floatValue()) : null;
                break;
            }
            case 'E': {
                Number n = Util.convertToNumber(rs.getObject(columnIndex), false, true);
                value = n != null ? Double.valueOf(n.doubleValue()) : null;
                break;
            }
            case 'D': {
                value = rs.getTimestamp(columnIndex);
                break;
            }
            case 'T': {
                String s = rs.getString(columnIndex);
                try {
                    value = s != null ? (s.startsWith(String.valueOf('\u001c')) ? new SimpleDataTable(s) : s) : null;
                    break;
                }
                catch (DataTableException ex) {
                    throw new IllegalStateException(ex);
                }
            }
            case 'A': {
                value = DataTableWrappingUtils.getDataValue(rs, columnIndex, ff);
                break;
            }
            default: {
                value = rs.getString(columnIndex);
                if (value == null) break;
                value = ff.valueFromString((String)value);
            }
        }
        if (rs.wasNull()) {
            value = null;
        }
        return value;
    }

    public static Data getDataValue(ResultSet rs, int columnIndex, FieldFormat<Data> ff) throws SQLException {
        String raw = null;
        Object dataObj = rs.getObject(columnIndex);
        if (dataObj != null) {
            byte[] bytes = null;
            if (dataObj instanceof byte[]) {
                bytes = (byte[])dataObj;
                raw = new String(bytes);
            } else if (dataObj instanceof Blob) {
                Blob blob = (Blob)dataObj;
                bytes = blob.getBytes(1L, (int)blob.length());
                raw = new String(bytes);
            } else {
                Log.DATATABLE.error((Object)"The data object is neither an array of bytes nor a Blob; the data field of the Data object will be set to null");
            }
            try {
                return ff.valueFromEncodedString(raw, new ClassicEncodingSettings(false), true);
            }
            catch (Exception ex) {
                return new Data(bytes);
            }
        }
        return null;
    }
}

