/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import com.tibbo.aggregate.common.Log;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertificateException;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public class SslHelper {
    private static SSLContext SSL_CONTEXT;

    public static void initTwoWaySSLContext(SSLContext context, Set<PKIXRevocationChecker.Option> revocationCheckerOptions) throws NoSuchAlgorithmException, KeyStoreException, FileNotFoundException, IOException, CertificateException, UnrecoverableKeyException, KeyManagementException, InvalidAlgorithmParameterException {
        char[] passphrase = System.getProperty("javax.net.ssl.keyStorePassword").toCharArray();
        String keystoreFilename = System.getProperty("javax.net.ssl.keyStore");
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(new FileInputStream(keystoreFilename), passphrase);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("PKIX");
        kmf.init(keyStore, passphrase);
        SslHelper.configureRevocationChecker(keyStore, tmf, revocationCheckerOptions);
        context.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
    }

    public static void configureRevocationChecker(KeyStore trustStore, TrustManagerFactory trustManagerFactory, Set<PKIXRevocationChecker.Option> options) throws NoSuchAlgorithmException, KeyStoreException, InvalidAlgorithmParameterException {
        CertPathBuilder cpb = CertPathBuilder.getInstance("PKIX");
        PKIXRevocationChecker revocationChecker = (PKIXRevocationChecker)cpb.getRevocationChecker();
        revocationChecker.setOptions(options);
        PKIXBuilderParameters pkixParameters = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
        pkixParameters.addCertPathChecker(revocationChecker);
        CertPathTrustManagerParameters certPathTrustManagerParameters = new CertPathTrustManagerParameters(pkixParameters);
        trustManagerFactory.init(certPathTrustManagerParameters);
    }

    public static Set<PKIXRevocationChecker.Option> getRevocationCheckerOptions(boolean preferCrls, boolean onlyEndEntity, boolean noFallback, boolean softFail) {
        HashSet<PKIXRevocationChecker.Option> options = new HashSet<PKIXRevocationChecker.Option>();
        if (preferCrls) {
            options.add(PKIXRevocationChecker.Option.PREFER_CRLS);
        }
        if (onlyEndEntity) {
            options.add(PKIXRevocationChecker.Option.ONLY_END_ENTITY);
        }
        if (noFallback) {
            options.add(PKIXRevocationChecker.Option.NO_FALLBACK);
        }
        if (softFail) {
            options.add(PKIXRevocationChecker.Option.SOFT_FAIL);
        }
        return options;
    }

    public static SSLSocketFactory getTrustedSocketFactory() {
        return SSL_CONTEXT.getSocketFactory();
    }

    public static SSLSocketFactory getTrustedSocketFactory(boolean trustAll, boolean preferCrls, boolean onlyEndEntity, boolean noFallback, boolean softFail) {
        if (trustAll) {
            return SslHelper.getTrustedSocketFactory();
        }
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            Set<PKIXRevocationChecker.Option> options = SslHelper.getRevocationCheckerOptions(preferCrls, onlyEndEntity, noFallback, softFail);
            SslHelper.initTwoWaySSLContext(sslContext, options);
            return sslContext.getSocketFactory();
        }
        catch (Exception ex) {
            Log.CORE.fatal((Object)"Error initializing Two-Way SSL context", (Throwable)ex);
            return null;
        }
    }

    static {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSL_CONTEXT = SSLContext.getInstance("SSL");
            SSL_CONTEXT.init(null, trustAllCerts, new SecureRandom());
        }
        catch (Exception ex) {
            Log.CORE.fatal((Object)"Error initializing SSL context", (Throwable)ex);
        }
    }
}

