/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import com.tibbo.aggregate.common.AggreGateException;
import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.DefaultContextManager;
import com.tibbo.aggregate.common.data.Data;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.device.RemoteDeviceErrorException;
import com.tibbo.aggregate.common.protocol.AbstractAggreGateDeviceController;
import com.tibbo.aggregate.common.protocol.AggreGateCommandParser;
import com.tibbo.aggregate.common.protocol.OutgoingAggreGateCommand;
import com.tibbo.aggregate.common.protocol.ProxyContext;
import com.tibbo.aggregate.common.protocol.RemoteContextManager;
import com.tibbo.aggregate.common.protocol.RemoteServer;
import com.tibbo.aggregate.common.protocol.SslHelper;
import com.tibbo.aggregate.common.security.TokenProvider;
import com.tibbo.aggregate.common.server.CommonServerFormats;
import com.tibbo.aggregate.common.util.BlockingChannel;
import com.tibbo.aggregate.common.util.SocketBlockingChannel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.Timer;
import java.util.TimerTask;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.log4j.Logger;

public class RemoteServerController
extends AbstractAggreGateDeviceController<RemoteServer, RemoteContextManager> {
    private static final String CHECK_CONNECTION_TIMER_PREFIX = "checkConnectionTimer/";
    private Timer connectionTimer;
    private BlockingChannel dataChannel;

    public RemoteServerController(RemoteServer device, boolean async) {
        this(device, async, false);
    }

    public RemoteServerController(RemoteServer device, boolean async, boolean json) {
        this(device, async, true, Log.COMMANDS_CLIENT, Integer.MAX_VALUE, json);
    }

    public RemoteServerController(RemoteServer device, boolean async, boolean useContextManager, Logger logger, int maxEventQueueLength) {
        this(device, async, useContextManager, logger, maxEventQueueLength, false);
    }

    public RemoteServerController(RemoteServer device, boolean async, boolean useContextManager, Logger logger, int maxEventQueueLength, boolean json) {
        super(device, logger, maxEventQueueLength, json);
        if (useContextManager) {
            this.setContextManager(new RemoteContextManager(this, async, maxEventQueueLength));
        }
    }

    @Override
    protected boolean connectImpl() throws InterruptedException, DisconnectionException, IOException, RemoteDeviceErrorException, ContextException {
        this.prepareDataChannel();
        super.connectImpl();
        if (this.getContextManager() != null) {
            ((DefaultContextManager)this.getContextManager()).setRoot(new ProxyContext("", this));
            ((DefaultContextManager)this.getContextManager()).restart();
        }
        return true;
    }

    protected void prepareDataChannel() throws RemoteDeviceErrorException {
        try {
            if (this.dataChannel == null && ((RemoteServer)this.getDevice()).getAddress() != null) {
                SSLSocket sslSocket;
                Log.PROTOCOL.debug((Object)("Connecting to remote server (" + this.getDevice() + ")"));
                SSLSocketFactory sslFactory = this.getTrustedSocketFactory((RemoteServer)this.getDevice());
                try {
                    sslSocket = (SSLSocket)sslFactory.createSocket();
                    int timeout = new Long(((RemoteServer)this.getDevice()).getConnectionTimeout()).intValue();
                    sslSocket.setSoTimeout(timeout);
                    sslSocket.connect(new InetSocketAddress(((RemoteServer)this.getDevice()).getAddress(), ((RemoteServer)this.getDevice()).getPort()), timeout);
                }
                catch (IOException ex) {
                    String msg = this.getConnectionErrorMessage();
                    if (msg == null) {
                        throw ex;
                    }
                    throw new RemoteDeviceErrorException(msg, ex);
                }
                sslSocket.setEnabledCipherSuites(sslSocket.getSupportedCipherSuites());
                sslSocket.startHandshake();
                this.dataChannel = new SocketBlockingChannel(sslSocket);
            }
            if (this.dataChannel != null) {
                this.setCommandParser(new AggreGateCommandParser(this.dataChannel));
            }
            Log.PROTOCOL.debug((Object)"Connection with remote server established");
        }
        catch (IOException ex) {
            throw new RemoteDeviceErrorException(MessageFormat.format(Cres.get().getString("devErrConnecting"), ((RemoteServer)this.getDevice()).getDescription() + " (" + ((RemoteServer)this.getDevice()).getInfo() + ")") + ex.getMessage(), ex);
        }
    }

    private SSLSocketFactory getTrustedSocketFactory(RemoteServer device) {
        return SslHelper.getTrustedSocketFactory(device.isTrustAll(), device.isPreferCrls(), device.isOnlyEndEntity(), device.isNoFallback(), device.isSoftFail());
    }

    protected String getConnectionErrorMessage() {
        return null;
    }

    @Override
    protected boolean loginImpl() throws ContextException {
        byte[] token;
        if (this.getContextManager() != null) {
            ((DefaultContextManager)this.getContextManager()).restart();
        }
        try {
            TokenProvider tokenProvider = ((RemoteServer)this.getDevice()).getAuthTokenProvider();
            token = tokenProvider != null ? tokenProvider.getEncodedToken() : null;
        }
        catch (AggreGateException e) {
            throw new ContextException(e);
        }
        DataRecord loginInput = new DataRecord(CommonServerFormats.FIFT_LOGIN);
        loginInput.setValue("username", (Object)((RemoteServer)this.getDevice()).getUsername());
        if (token == null) {
            loginInput.setValue("password", (Object)((RemoteServer)this.getDevice()).getPassword());
        } else {
            loginInput.setValue("token", (Object)new Data(token));
        }
        loginInput.setValue("code", (Object)((RemoteServer)this.getDevice()).getCode());
        loginInput.setValue("state", null);
        loginInput.setValue("provider", (Object)((RemoteServer)this.getDevice()).getProvider());
        loginInput.setValue("countAttempts", (Object)((RemoteServer)this.getDevice()).isCountAttempts());
        DataTable loginResult = this.callRemoteFunction("", "login", null, loginInput.wrap(), null);
        ((RemoteServer)this.getDevice()).setEffectiveUsername(loginResult.rec().getString("username"));
        String login = loginResult.hasField("login") ? loginResult.rec().getString("login") : null;
        ((RemoteServer)this.getDevice()).setLogin(login != null ? login : ((RemoteServer)this.getDevice()).getUsername());
        if (this.getContextManager() != null) {
            ((ProxyContext)((DefaultContextManager)this.getContextManager()).getRoot()).reinitialize();
        }
        return true;
    }

    @Override
    public void start() throws IOException, InterruptedException, ContextException, RemoteDeviceErrorException {
    }

    @Override
    protected void disconnectImpl() {
        if (this.dataChannel != null && this.dataChannel.isOpen()) {
            try {
                this.dataChannel.close();
            }
            catch (IOException ex) {
                Log.PROTOCOL.error((Object)"Error closing socket", (Throwable)ex);
            }
        }
        this.dataChannel = null;
        super.disconnectImpl();
    }

    @Override
    protected void send(OutgoingAggreGateCommand cmd) throws DisconnectionException, IOException {
        this.commandWriter.write(cmd, this.dataChannel);
    }

    protected void setDataChannel(BlockingChannel socketChannel) {
        this.dataChannel = socketChannel;
    }

    protected BlockingChannel getDataChannel() {
        return this.dataChannel;
    }

    @Override
    public boolean isConnected() {
        return super.isConnected() && this.dataChannel != null && this.dataChannel.isOpen();
    }

    public String getAddress() {
        return this.dataChannel != null ? this.dataChannel.getChannelAddress() : null;
    }

    public void startConnectionTimerTask(String name) {
        this.startConnectionTimerTask(name, 10000L, 10000L);
    }

    public void startConnectionTimerTask(String name, long delay, long period) {
        this.connectionTimer = new Timer(CHECK_CONNECTION_TIMER_PREFIX + name);
        TimerTask timerTask = this.createConnectionTimer();
        this.connectionTimer.schedule(timerTask, delay, period);
    }

    public void removeConnectionTimerTask() {
        if (this.connectionTimer != null) {
            this.connectionTimer.cancel();
            this.connectionTimer.purge();
        }
    }

    public TimerTask createConnectionTimer() {
        return new SimpleConnectionTimer(this);
    }

    private class SimpleConnectionTimer
    extends TimerTask {
        private final RemoteServerController remoteServerController;

        SimpleConnectionTimer(RemoteServerController remoteServerController2) {
            this.remoteServerController = remoteServerController2;
        }

        @Override
        public void run() {
            try {
                OutgoingAggreGateCommand ping = RemoteServerController.this.getCommandBuilder().startMessage();
                this.remoteServerController.sendCommand(ping);
            }
            catch (Exception ex) {
                try {
                    this.remoteServerController.disconnect();
                }
                catch (RemoteDeviceErrorException | IOException | InterruptedException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    this.cancel();
                    Log.PROTOCOL.warn((Object)"Connection lost", (Throwable)ex);
                }
            }
        }
    }
}

