/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import com.tibbo.aggregate.common.AggreGateException;
import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.protocol.AggreGateNetworkDevice;
import com.tibbo.aggregate.common.security.TokenProvider;

public class RemoteServer
extends AggreGateNetworkDevice {
    public static final int DEFAULT_PORT = 6460;
    public static final int DEFAULT_NON_SECURE_PORT = 6461;
    public static final String DEFAULT_USERNAME = "admin";
    public static final String DEFAULT_PASSWORD = "admin";
    private String username;
    private String password;
    private String provider;
    private String code;
    private String effectiveUsername;
    private String login;
    private TokenProvider authTokenProvider;
    private boolean trustAll = true;
    private boolean preferCrls = true;
    private boolean noFallback = true;
    private boolean softFail = true;
    private boolean onlyEndEntity = false;
    private Boolean countAttempts;

    public RemoteServer() {
        this("localhost", 6460, "admin", "admin");
    }

    public RemoteServer(String address, int port, String username, String password) {
        super("server", Cres.get().getString("server"), address, port);
        this.username = username;
        this.password = password;
    }

    public RemoteServer(String address, int port, TokenProvider authTokenProvider) throws AggreGateException {
        super("server", Cres.get().getString("server"), address, port);
        this.username = authTokenProvider.getUsername();
        this.authTokenProvider = authTokenProvider;
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getEffectiveUsername() {
        return this.effectiveUsername;
    }

    public void setEffectiveUsername(String effectiveUsername) {
        this.effectiveUsername = effectiveUsername;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public TokenProvider getAuthTokenProvider() {
        return this.authTokenProvider;
    }

    @Override
    public String getInfo() {
        return super.getInfo() + (this.username != null ? ", " + this.username : "");
    }

    public Boolean isCountAttempts() {
        return this.countAttempts;
    }

    public void setCountAttempts(Boolean countAttempts) {
        this.countAttempts = countAttempts;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public void setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
    }

    public boolean isPreferCrls() {
        return this.preferCrls;
    }

    public void setPreferCrls(boolean preferCrls) {
        this.preferCrls = preferCrls;
    }

    public boolean isNoFallback() {
        return this.noFallback;
    }

    public void setNoFallback(boolean noFallback) {
        this.noFallback = noFallback;
    }

    public boolean isSoftFail() {
        return this.softFail;
    }

    public void setSoftFail(boolean softFail) {
        this.softFail = softFail;
    }

    public boolean isOnlyEndEntity() {
        return this.onlyEndEntity;
    }

    public void setOnlyEndEntity(boolean onlyEndEntity) {
        this.onlyEndEntity = onlyEndEntity;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteServer other = (RemoteServer)obj;
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }
}

