/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.DefaultContextManager;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.device.RemoteDeviceErrorException;
import com.tibbo.aggregate.common.event.ContextEventListener;
import com.tibbo.aggregate.common.protocol.AbstractAggreGateDeviceController;
import com.tibbo.aggregate.common.protocol.ProtocolVersion;
import com.tibbo.aggregate.common.protocol.ProxyContext;
import com.tibbo.aggregate.common.util.StringUtils;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RemoteContextManager
extends DefaultContextManager<ProxyContext> {
    private boolean initialized = false;
    private boolean initializing = false;
    private final AbstractAggreGateDeviceController controller;
    private final Map<String, List<Runnable>> deferredTasks = Collections.synchronizedMap(new HashMap());

    public RemoteContextManager(AbstractAggreGateDeviceController controller, boolean async, int eventQueueLength) {
        super(async, eventQueueLength, null);
        this.controller = controller;
    }

    protected void initialize() throws ContextException, DisconnectionException, IOException, InterruptedException, RemoteDeviceErrorException {
        if (this.initialized || this.initializing) {
            return;
        }
        this.initializing = true;
        try {
            this.controller.connect();
        }
        finally {
            this.initializing = false;
        }
        this.initialized = true;
    }

    @Override
    public void stop() {
        this.initialized = false;
        super.stop();
    }

    public AbstractAggreGateDeviceController getController() {
        return this.controller;
    }

    protected void sendAddListener(String context, String event, ContextEventListener listener) {
        ProtocolVersion protocolVersion = this.getController().getProtocolVersion();
        if (protocolVersion == null || protocolVersion.ordinal() < ProtocolVersion.V3.ordinal()) {
            return;
        }
        try {
            String filterText = listener.getFilter() != null ? listener.getFilter().getText() : null;
            String fingerprint = listener.getFingerprint();
            this.getController().sendCommandAndCheckReplyCode(this.getController().getCommandBuilder().addEventListenerOperation(context, event, listener.getListenerCode(), filterText, fingerprint));
        }
        catch (Exception ex) {
            String msg = MessageFormat.format(Cres.get().getString("conErrAddingListener"), event, context);
            throw new IllegalStateException(msg + ": " + ex.getMessage(), ex);
        }
    }

    protected void sendRemoveListener(String context, String event, ContextEventListener listener) {
        ProtocolVersion protocolVersion = this.getController().getProtocolVersion();
        if (protocolVersion == null || protocolVersion.ordinal() < ProtocolVersion.V3.ordinal()) {
            return;
        }
        try {
            String filter = listener.getFilter() != null ? listener.getFilter().getText() : null;
            String fingerprint = listener.getFingerprint();
            this.getController().sendCommandAndCheckReplyCode(this.getController().getCommandBuilder().removeEventListenerOperation(context, event, listener.getListenerCode(), filter, fingerprint));
        }
        catch (Exception ex) {
            String msg = MessageFormat.format(Cres.get().getString("conErrRemovingListener"), event, context);
            throw new IllegalStateException(msg + ": " + ex.getMessage(), ex);
        }
    }

    @Override
    protected void addListenerToContext(ProxyContext con, String event, ContextEventListener listener, boolean mask, boolean weak) {
        con.addEventListener(event, listener, false, !mask);
    }

    @Override
    protected void removeListenerFromContext(ProxyContext con, String event, ContextEventListener listener, boolean mask) {
        con.removeEventListener(event, listener, !mask);
    }

    @Override
    public void addMaskEventListener(String mask, String event, ContextEventListener listener) {
        super.addMaskEventListener(mask, event, listener);
        this.sendAddListener(mask, event, listener);
    }

    @Override
    public void removeMaskEventListener(String mask, String event, ContextEventListener listener) {
        super.removeMaskEventListener(mask, event, listener);
        this.sendRemoveListener(mask, event, listener);
    }

    @Override
    public void contextRemoved(ProxyContext con) {
    }

    public ProxyContext createContexts(String path) {
        ProxyContext cur = (ProxyContext)this.getRoot();
        List<String> names = StringUtils.split(path, ".".charAt(0));
        for (String name : names) {
            ProxyContext child = (ProxyContext)cur.getChild(name);
            if (child == null) {
                child = cur.createChildContextProxy(name);
                cur.addChild(child);
            }
            cur = child;
        }
        return cur;
    }

    public void addDeferredTask(String path, Runnable task) {
        List<Runnable> tasks = this.deferredTasks.get(path);
        if (tasks == null) {
            tasks = new ArrayList<Runnable>();
        }
        tasks.add(task);
        this.deferredTasks.put(path, tasks);
    }

    public void executeDeferredTasks(String path) {
        if (this.deferredTasks.containsKey(path)) {
            for (Runnable task : this.deferredTasks.get(path)) {
                task.run();
            }
            this.deferredTasks.remove(path);
        }
    }
}

