/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.action.ActionDefinition;
import com.tibbo.aggregate.common.context.AbstractContext;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextRuntimeException;
import com.tibbo.aggregate.common.context.ContextStatus;
import com.tibbo.aggregate.common.context.ContextUtils;
import com.tibbo.aggregate.common.context.DefaultContextEventListener;
import com.tibbo.aggregate.common.context.DefaultContextVisitor;
import com.tibbo.aggregate.common.context.EventData;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.context.FunctionDefinition;
import com.tibbo.aggregate.common.context.RequestController;
import com.tibbo.aggregate.common.context.UncheckedCallerController;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.encoding.FormatCache;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.device.RemoteDeviceErrorException;
import com.tibbo.aggregate.common.event.ContextEventListener;
import com.tibbo.aggregate.common.event.EventHandlingException;
import com.tibbo.aggregate.common.event.FireEventRequestController;
import com.tibbo.aggregate.common.protocol.AbstractAggreGateDeviceController;
import com.tibbo.aggregate.common.protocol.CachedVariableValue;
import com.tibbo.aggregate.common.protocol.IncomingAggreGateCommand;
import com.tibbo.aggregate.common.protocol.OutgoingAggreGateCommand;
import com.tibbo.aggregate.common.protocol.ProtocolVersion;
import com.tibbo.aggregate.common.protocol.RemoteContextManager;
import com.tibbo.aggregate.common.security.Permissions;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import com.tibbo.aggregate.common.util.Util;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

public class ProxyContext<C extends Context>
extends AbstractContext<C> {
    private static final long METADATA_READ_TIMEOUT = 120000L;
    private static final long LISTENER_OPERATIONS_TIMEOUT = 120000L;
    public static final long DURABLE_OPERATIONS_TIMEOUT = 600000L;
    public static final String F_LOCAL_REINITIALIZE = "localReinitialize";
    private final AbstractAggreGateDeviceController controller;
    private boolean notManageRemoteListeners;
    private boolean localInitComplete = false;
    private boolean initializingInfo = false;
    private boolean initializedInfo = false;
    private final Object initializingInfoLock = new Object();
    private boolean initializingChildren = false;
    private boolean initializedChildren = false;
    private final Object initializingChildrenLock = new Object();
    private boolean initializingVariables = false;
    private boolean initializedVariables = false;
    private final Object initializingVariablesLock = new Object();
    private boolean initializingFunctions = false;
    private boolean initializedFunctions = false;
    private final Object initializingFunctionsLock = new Object();
    private boolean initializingEvents = false;
    private boolean initializedEvents = false;
    private final Object initializingEventsLock = new Object();
    private boolean initializingActions = false;
    private boolean initializedActions = false;
    private final Object initializingActionsLock = new Object();
    private boolean initializingStatus = false;
    private boolean initializedStatus = false;
    private final Object initializingStatusLock = new Object();
    private boolean initializingVisibleChildren = false;
    private final Object initializingVisibleChildrenLock = new Object();
    private Collection<String> visibleChildren;
    private String localRoot;
    private String peerRoot;
    private String peerPrimaryRoot;
    private String remoteRoot;
    private String remotePath;
    private boolean mapped;
    private boolean container;
    private final Map<String, SoftReference<CachedVariableValue>> variableCache = new HashMap<String, SoftReference<CachedVariableValue>>();
    private final ReentrantReadWriteLock variableCacheLock = new ReentrantReadWriteLock();
    private static final List<String> AUTO_LISTENED_EVENTS = new LinkedList<String>();
    private final ContextEventListener visibleChildAddedListener = new DefaultContextEventListener(new UncheckedCallerController()){

        @Override
        public void handle(Event event) throws EventHandlingException {
            String path = event.getData().rec().getString("path");
            if (ProxyContext.this.visibleChildren != null) {
                ProxyContext.this.addVisibleChild(path);
            }
        }
    };
    private final ContextEventListener visibleChildRemovedListener = new DefaultContextEventListener(new UncheckedCallerController()){

        @Override
        public void handle(Event event) throws EventHandlingException {
            String path = event.getData().rec().getString("path");
            if (ProxyContext.this.visibleChildren != null) {
                ProxyContext.this.removeVisibleChild(path);
            }
        }
    };
    private final ContextEventListener contextStatusChangedListener = new DefaultContextEventListener(new UncheckedCallerController()){

        @Override
        public void handle(Event event) throws EventHandlingException {
            DataRecord statusRec = event.getData().rec();
            ProxyContext.this.setStatus(statusRec.getInt("status"), statusRec.getString("comment"));
        }
    };

    public ProxyContext(String name, AbstractAggreGateDeviceController controller) {
        super(name);
        this.controller = controller;
        this.clear();
    }

    @Override
    public void setupMyself() throws ContextException {
        super.setupMyself();
        this.setFireUpdateEvents(false);
        this.setPermissionCheckingEnabled(false);
        this.setChildrenSortingEnabled(false);
        this.addLocalFunctionDefinitions();
        this.localInitComplete = true;
    }

    private void addListenersOnInfo() {
        this.addEventListener("infoChanged", new DefaultContextEventListener(){

            @Override
            public void handle(Event ev) {
                ProxyContext.this.initInfoImpl(ev.getData());
            }
        });
    }

    private void addListenersOnActions() {
        this.addEventListener("actionAdded", new DefaultContextEventListener(){

            @Override
            public void handle(Event ev) {
                ActionDefinition def = ProxyContext.this.actDefFromDataRecord(ev.getData().rec());
                if (ProxyContext.this.getActionDefinition(def.getName()) == null || !ProxyContext.this.getActionDefinition(def.getName()).equals(def)) {
                    ProxyContext.this.addActionDefinition(def);
                }
            }
        });
        this.addEventListener("actionRemoved", new DefaultContextEventListener(){

            @Override
            public void handle(Event ev) {
                ProxyContext.this.removeActionDefinition(ev.getData().rec().getString("name"));
            }
        });
        this.addEventListener("actionStateChanged", new DefaultContextEventListener(){

            @Override
            public void handle(Event ev) {
                ActionDefinition def = ProxyContext.this.actDefFromDataRecord(ev.getData().rec());
                ProxyContext.this.removeActionDefinition(def.getName());
                ProxyContext.this.addActionDefinition(def);
            }
        });
    }

    private void addListenersOnEvents() {
        this.addEventListener("eventAdded", new DefaultContextEventListener(){

            @Override
            public void handle(Event ev) {
                EventDefinition def = ProxyContext.this.evtDefFromDataRecord(ev.getData().rec());
                if (ProxyContext.this.getEventDefinition(def.getName()) == null || !ProxyContext.this.getEventDefinition(def.getName()).equals(def)) {
                    ProxyContext.this.addEventDefinition(def);
                }
            }
        });
        this.addEventListener("eventRemoved", new DefaultContextEventListener(){

            @Override
            public void handle(Event ev) {
                ProxyContext.this.removeEventDefinition(ev.getData().rec().getString("name"));
            }
        });
    }

    private void addListenersOnFunctions() {
        this.addEventListener("functionAdded", new DefaultContextEventListener(){

            @Override
            public void handle(Event ev) {
                FunctionDefinition def = ProxyContext.this.funcDefFromDataRecord(ev.getData().rec());
                if (ProxyContext.this.getFunctionDefinition(def.getName()) == null || !ProxyContext.this.getFunctionDefinition(def.getName()).equals(def)) {
                    ProxyContext.this.addFunctionDefinition(def);
                }
            }
        });
        this.addEventListener("functionRemoved", new DefaultContextEventListener(){

            @Override
            public void handle(Event ev) {
                ProxyContext.this.removeFunctionDefinition(ev.getData().rec().getString("name"));
            }
        });
    }

    private void addListenersOnVariables() {
        this.addEventListener("variableAdded", new DefaultContextEventListener(){

            @Override
            public void handle(Event ev) {
                VariableDefinition def = ProxyContext.this.varDefFromDataRecord(ev.getData().rec());
                if (ProxyContext.this.getVariableDefinition(def.getName()) == null || !ProxyContext.this.getVariableDefinition(def.getName()).equals(def)) {
                    ProxyContext.this.addVariableDefinition(def);
                }
            }
        });
        this.addEventListener("variableRemoved", new DefaultContextEventListener(){

            @Override
            public void handle(Event ev) {
                ProxyContext.this.removeVariableDefinition(ev.getData().rec().getString("name"));
            }
        });
    }

    private void addListenersOnChildren() {
        this.addEventListener("childAdded", new DefaultContextEventListener(){

            @Override
            public void handle(Event event) throws EventHandlingException {
                String child = event.getData().rec().getString("child");
                if (ProxyContext.this.getChild(child) == null) {
                    ProxyContext childProxy = ProxyContext.this.createChildContextProxy(child);
                    ProxyContext.this.addChild(childProxy);
                    if (ProxyContext.this.getContextManager() instanceof RemoteContextManager) {
                        ((RemoteContextManager)ProxyContext.this.getContextManager()).executeDeferredTasks(childProxy.getPath());
                    }
                }
            }
        });
        this.addEventListener("childRemoved", new DefaultContextEventListener(){

            @Override
            public void handle(Event event) throws EventHandlingException {
                String child = event.getData().rec().getString("child");
                if (child != null) {
                    ProxyContext.this.removeChild(child);
                }
            }
        });
    }

    protected void addLocalFunctionDefinitions() {
        this.addFunctionDefinition(new FunctionDefinition(F_LOCAL_REINITIALIZE, TableFormat.EMPTY_FORMAT, TableFormat.EMPTY_FORMAT));
    }

    @Override
    protected TableFormat decodeFormat(String source, CallerController caller) {
        char c;
        int i;
        if (source == null) {
            return null;
        }
        StringBuilder idSourceBuilder = new StringBuilder();
        for (i = 0; i < source.length() && Character.isDigit(c = source.charAt(i)); ++i) {
            idSourceBuilder.append(c);
        }
        source = source.substring(i);
        String idSource = idSourceBuilder.toString();
        Integer formatId = idSource.length() > 0 ? Integer.valueOf(idSource) : null;
        TableFormat format = source.length() > 0 ? new TableFormat(source, new ClassicEncodingSettings(false)) : null;
        return this.getFormat(format, formatId);
    }

    private TableFormat getFormat(TableFormat format, Integer formatId) {
        if (formatId == null) {
            return format;
        }
        if (format == null) {
            TableFormat cached = this.controller.getFormatCache().get(formatId);
            if (cached == null) {
                throw new IllegalArgumentException("Unknown format ID: " + formatId);
            }
            return cached;
        }
        if (!format.isImmutable()) {
            format.makeImmutable(null);
        }
        this.controller.getFormatCache().put(formatId, format);
        return format;
    }

    public void clear() {
        try {
            this.accept(new DefaultContextVisitor(){

                @Override
                public void visit(Context context) {
                    ProxyContext proxyContext = (ProxyContext)context;
                    proxyContext.initializedInfo = false;
                    proxyContext.initializingInfo = false;
                    proxyContext.initializedChildren = false;
                    proxyContext.initializingChildren = false;
                    proxyContext.initializedVariables = false;
                    proxyContext.initializingVariables = false;
                    proxyContext.initializedFunctions = false;
                    proxyContext.initializingFunctions = false;
                    proxyContext.initializedEvents = false;
                    proxyContext.initializingEvents = false;
                    proxyContext.initializedActions = false;
                    proxyContext.initializingActions = false;
                    proxyContext.initializedStatus = false;
                    proxyContext.initializingStatus = false;
                    proxyContext.initializingVisibleChildren = false;
                    proxyContext.visibleChildren = null;
                }
            });
        }
        catch (ContextException ex) {
            throw new ContextRuntimeException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initInfo() throws ContextException {
        try {
            if (this.initializedInfo) {
                return;
            }
            if (this.controller.getContextManager() != null) {
                ((RemoteContextManager)this.controller.getContextManager()).initialize();
            }
            Object object = this.initializingInfoLock;
            synchronized (object) {
                if (!this.localInitComplete || this.initializingInfo) {
                    return;
                }
                try {
                    this.initializingInfo = true;
                    this.initInfoImpl(this.getRemoteVariable(INFO_DEFINITION_FORMAT, "info", 120000L));
                    this.initializedInfo = true;
                    this.addListenersOnInfo();
                }
                finally {
                    this.initializingInfo = false;
                }
            }
        }
        catch (ContextException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ContextException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initChildren() throws ContextException {
        try {
            Object object = this.initializingChildrenLock;
            synchronized (object) {
                if (this.initializedChildren) {
                    return;
                }
                if (this.controller.getContextManager() != null) {
                    ((RemoteContextManager)this.controller.getContextManager()).initialize();
                }
                if (!this.localInitComplete || this.initializingChildren) {
                    return;
                }
                try {
                    this.initializingChildren = true;
                    this.initChildrenImpl(this.getRemoteVariable(VFT_CHILDREN, "children", 120000L));
                    this.initializedChildren = true;
                    this.addListenersOnChildren();
                }
                finally {
                    this.initializingChildren = false;
                }
            }
        }
        catch (ContextException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ContextException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initVariables() throws ContextException {
        try {
            if (this.initializedVariables) {
                return;
            }
            if (this.controller.getContextManager() != null) {
                ((RemoteContextManager)this.controller.getContextManager()).initialize();
            }
            Object object = this.initializingVariablesLock;
            synchronized (object) {
                if (!this.localInitComplete || this.initializingVariables) {
                    return;
                }
                try {
                    this.initializingVariables = true;
                    this.initVariablesImpl(this.getRemoteVariable(VARIABLE_DEFINITION_FORMAT, "variables", 120000L));
                    this.initializedVariables = true;
                    this.addListenersOnVariables();
                }
                finally {
                    this.initializingVariables = false;
                }
            }
        }
        catch (ContextException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ContextException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFunctions() throws ContextException {
        try {
            if (this.initializedFunctions) {
                return;
            }
            if (this.controller.getContextManager() != null) {
                ((RemoteContextManager)this.controller.getContextManager()).initialize();
            }
            Object object = this.initializingFunctionsLock;
            synchronized (object) {
                if (!this.localInitComplete || this.initializingFunctions) {
                    return;
                }
                try {
                    this.initializingFunctions = true;
                    this.initFunctionsImpl(this.getRemoteVariable(FUNCTION_DEFINITION_FORMAT, "functions", 120000L));
                    this.initializedFunctions = true;
                    this.addListenersOnFunctions();
                }
                finally {
                    this.initializingFunctions = false;
                }
            }
        }
        catch (ContextException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ContextException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initEvents() throws ContextException {
        try {
            if (this.initializedEvents) {
                return;
            }
            if (this.controller.getContextManager() != null) {
                ((RemoteContextManager)this.controller.getContextManager()).initialize();
            }
            Object object = this.initializingEventsLock;
            synchronized (object) {
                if (!this.localInitComplete || this.initializingEvents) {
                    return;
                }
                try {
                    this.initializingEvents = true;
                    this.initEventsImpl(this.getRemoteVariable(EVENT_DEFINITION_FORMAT, "events", 120000L));
                    this.initializedEvents = true;
                    this.addListenersOnEvents();
                }
                finally {
                    this.initializingEvents = false;
                }
            }
        }
        catch (ContextException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ContextException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initActions() throws ContextException {
        try {
            if (this.initializedActions) {
                return;
            }
            if (this.controller.getContextManager() != null) {
                ((RemoteContextManager)this.controller.getContextManager()).initialize();
            }
            Object object = this.initializingActionsLock;
            synchronized (object) {
                if (!this.localInitComplete || this.initializingActions) {
                    return;
                }
                try {
                    this.initializingActions = true;
                    this.initActionsImpl(this.getRemoteVariable(ACTION_DEF_FORMAT, "actions", 120000L));
                    this.initializedActions = true;
                    this.addListenersOnActions();
                }
                finally {
                    this.initializingActions = false;
                }
            }
        }
        catch (ContextException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ContextException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initVisibleChildren() throws ContextException {
        try {
            if (this.visibleChildren != null) {
                return;
            }
            if (this.controller.getContextManager() != null) {
                ((RemoteContextManager)this.controller.getContextManager()).initialize();
            }
            Object object = this.initializingVisibleChildrenLock;
            synchronized (object) {
                if (!this.localInitComplete || this.initializingVisibleChildren) {
                    return;
                }
                try {
                    this.initializingVisibleChildren = true;
                    this.initVisibleChildrenImpl();
                }
                finally {
                    this.initializingVisibleChildren = false;
                }
            }
        }
        catch (ContextException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ContextException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStatus() throws ContextException {
        try {
            if (this.initializedStatus) {
                return;
            }
            if (this.controller.getContextManager() != null) {
                ((RemoteContextManager)this.controller.getContextManager()).initialize();
            }
            Object object = this.initializingStatusLock;
            synchronized (object) {
                if (!this.localInitComplete || this.initializingStatus) {
                    return;
                }
                try {
                    this.initializingStatus = true;
                    this.initStatusImpl();
                    this.initializedStatus = true;
                }
                finally {
                    this.initializingStatus = false;
                }
            }
        }
        catch (ContextException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ContextException(ex);
        }
    }

    private void initInfoImpl(DataTable info) {
        this.setDescription(this.convertRemoteDescription(info.rec().getString("description")));
        this.setType(info.rec().getString("type"));
        if (info.getFormat().hasField("group")) {
            this.setGroup(info.rec().getString("group"));
        }
        if (info.getFormat().hasField("icon")) {
            this.setIconId(info.rec().getString("icon"));
        }
        if (info.getFormat().hasField("localRoot")) {
            this.localRoot = info.rec().getString("localRoot");
        }
        if (info.getFormat().hasField("peerRoot")) {
            this.peerRoot = info.rec().getString("peerRoot");
        }
        if (info.getFormat().hasField("peerPrimaryRoot")) {
            this.peerPrimaryRoot = info.rec().getString("peerPrimaryRoot");
        }
        if (info.getFormat().hasField("remoteRoot")) {
            this.remoteRoot = info.rec().getString("remoteRoot");
        }
        if (info.getFormat().hasField("remotePath")) {
            this.remotePath = info.rec().getString("remotePath");
        }
        if (info.getFormat().hasField("mapped") && info.rec().getBoolean("mapped") != null) {
            this.mapped = info.rec().getBoolean("mapped");
        }
    }

    protected String convertRemoteDescription(String remoteDescription) {
        return remoteDescription;
    }

    protected void initChildrenImpl(DataTable children) {
        this.removeExistingChildren(children);
        for (DataRecord rec : children) {
            String cn = rec.getString("name");
            if (this.getChild(cn) != null) continue;
            this.addChild(this.createChildContextProxy(cn));
        }
    }

    protected void removeExistingChildren(DataTable children) {
        for (Context child : this.getChildren(this.getContextManager().getCallerController())) {
            if (children.select("name", child.getName()) != null) continue;
            this.removeChild(child);
        }
    }

    private void initVisibleChildrenImpl() throws ContextException {
        this.initVariables();
        this.visibleChildren = new LinkedHashSet<String>();
        this.addEventListener("visibleChildAdded", this.visibleChildAddedListener);
        this.addEventListener("visibleChildRemoved", this.visibleChildRemovedListener);
        DataTable visibleChildrenData = this.getRemoteVariable(this.getVariableDefinition("visibleChildren"));
        for (DataRecord rec : visibleChildrenData) {
            String localVisiblePath = this.getLocalVisiblePath(rec.getString("path"));
            if (localVisiblePath == null) continue;
            this.visibleChildren.add(localVisiblePath);
        }
    }

    protected ProxyContext createChildContextProxy(String name) {
        ProxyContext<C> proxy = new ProxyContext<C>(name, this.controller);
        proxy.setNotManageRemoteListeners(this.isNotManageRemoteListeners());
        return proxy;
    }

    private void initVariablesImpl(DataTable variables) {
        for (VariableDefinition def : this.getVariableDefinitions()) {
            if (variables.select("name", def.getName()) != null) continue;
            this.removeVariableDefinition(def.getName());
        }
        for (DataRecord rec : variables) {
            VariableDefinition def = this.varDefFromDataRecord(rec);
            VariableDefinition existing = this.getVariableDefinition(def.getName());
            if (existing != null && existing.equals(def)) continue;
            if (existing != null) {
                this.removeVariableDefinition(existing.getName());
            }
            this.addVariableDefinition(def);
        }
    }

    @Override
    protected Optional<FormatCache> obtainFormatCache() {
        return Optional.ofNullable(this.controller.getFormatCache());
    }

    private void initFunctionsImpl(DataTable functions) {
        for (FunctionDefinition def : this.getFunctionDefinitions()) {
            if (functions.select("name", def.getName()) != null) continue;
            this.removeFunctionDefinition(def.getName());
        }
        this.addLocalFunctionDefinitions();
        for (DataRecord rec : functions) {
            FunctionDefinition def = this.funcDefFromDataRecord(rec);
            def.setConcurrent(true);
            FunctionDefinition existing = this.getFunctionDefinition(def.getName());
            if (existing != null && existing.equals(def)) continue;
            if (existing != null) {
                this.removeFunctionDefinition(existing.getName());
            }
            this.addFunctionDefinition(def);
        }
    }

    private void initEventsImpl(DataTable events) {
        for (EventDefinition def : this.getEventDefinitions()) {
            if (events.select("name", def.getName()) != null) continue;
            this.removeEventDefinition(def.getName());
        }
        for (DataRecord rec : events) {
            EventDefinition def = this.evtDefFromDataRecord(rec);
            EventDefinition existing = this.getEventDefinition(def.getName());
            if (existing != null && existing.equals(def)) continue;
            if (existing != null) {
                this.removeEventDefinition(existing.getName());
            }
            this.addEventDefinition(def);
        }
    }

    private void initActionsImpl(DataTable actions) {
        for (ActionDefinition ad : this.getActionDefinitions()) {
            if (actions.select("name", ad.getName()) != null) continue;
            this.removeActionDefinition(ad.getName());
        }
        for (DataRecord rec : actions) {
            ActionDefinition def = this.actDefFromDataRecord(rec);
            ActionDefinition existing = this.getActionDefinition(def.getName());
            if (existing != null && existing.equals(def)) continue;
            if (existing != null) {
                this.removeActionDefinition(existing.getName());
            }
            this.addActionDefinition(def);
        }
    }

    private void initStatusImpl() throws ContextException {
        this.initVariables();
        VariableDefinition statusVariable = this.getVariableDefinition("contextStatus");
        if (statusVariable == null) {
            return;
        }
        this.enableStatus();
        this.addEventListener("contextStatusChanged", this.contextStatusChangedListener);
        DataTable contextStatus = this.getRemoteVariable(statusVariable);
        this.setStatus(contextStatus.rec().getInt("status"), contextStatus.rec().getString("comment"));
    }

    @Override
    public String getDescription() {
        try {
            this.initInfo();
        }
        catch (ContextException ex) {
            boolean disconnected = ExceptionUtils.indexOfType((Throwable)ex, DisconnectionException.class) != -1;
            Log.CONTEXT_VARIABLES.log((Priority)(disconnected ? Level.DEBUG : Level.WARN), (Object)"Error getting description of remote context", (Throwable)ex);
        }
        return super.getDescription();
    }

    @Override
    public String getType() {
        try {
            this.initInfo();
        }
        catch (ContextException ex) {
            throw new ContextRuntimeException("Error getting type of remote context: " + ex.getMessage(), ex);
        }
        return super.getType();
    }

    @Override
    public String getLocalRoot(boolean withParent) {
        try {
            this.initInfo();
        }
        catch (ContextException ex) {
            throw new ContextRuntimeException(ex);
        }
        return this.localRoot;
    }

    @Override
    public String getRemoteRoot() {
        try {
            this.initInfo();
        }
        catch (ContextException ex) {
            throw new ContextRuntimeException(ex);
        }
        return this.remoteRoot;
    }

    @Override
    public String getPeerRoot() {
        try {
            this.initInfo();
        }
        catch (ContextException ex) {
            throw new ContextRuntimeException(ex);
        }
        return this.peerRoot;
    }

    @Override
    public boolean isMapped() {
        try {
            this.initInfo();
        }
        catch (ContextException ex) {
            throw new ContextRuntimeException(ex);
        }
        return this.mapped;
    }

    @Override
    public C get(String contextPath, CallerController caller) {
        if (contextPath == null) {
            return null;
        }
        if (ContextUtils.isRelative(contextPath)) {
            return super.get(contextPath, caller);
        }
        String localPath = this.getLocalPath(contextPath, false);
        if (localPath == null) {
            return null;
        }
        return super.get(localPath, caller);
    }

    @Override
    public String getIconId() {
        try {
            this.initInfo();
        }
        catch (ContextException ex) {
            boolean disconnected = ExceptionUtils.indexOfType((Throwable)ex, DisconnectionException.class) != -1;
            Log.CONTEXT_VARIABLES.log((Priority)(disconnected ? Level.DEBUG : Level.WARN), (Object)"Error getting icon of remote context", (Throwable)ex);
        }
        return super.getIconId();
    }

    @Override
    public C getChild(String name, CallerController callerController) {
        if (super.getChild(name, callerController) == null) {
            try {
                this.initChildren();
            }
            catch (ContextException ex) {
                boolean disconnected = ExceptionUtils.indexOfType((Throwable)ex, DisconnectionException.class) != -1;
                Log.CONTEXT_CHILDREN.log((Priority)(disconnected ? Level.DEBUG : Level.WARN), (Object)"Error initializing children of remote context", (Throwable)ex);
            }
        }
        return super.getChild(name, callerController);
    }

    @Override
    public VariableDefinition getVariableDefinition(String name) {
        VariableDefinition sup = super.getVariableDefinition(name);
        if (sup == null && this.isSetupComplete()) {
            this.initVariablesLoggingErrors();
            return super.getVariableDefinition(name);
        }
        return sup;
    }

    @Override
    public FunctionDefinition getFunctionDefinition(String name) {
        FunctionDefinition sup = super.getFunctionDefinition(name);
        if (sup == null && this.isSetupComplete()) {
            this.initFunctionsLoggingErrors();
            return super.getFunctionDefinition(name);
        }
        return sup;
    }

    @Override
    public EventData getEventData(String name) {
        EventData sup = super.getEventData(name);
        if (sup == null && this.isSetupComplete()) {
            this.initEventsLoggingErrors();
            return super.getEventData(name);
        }
        return sup;
    }

    @Override
    public ActionDefinition getActionDefinition(String name) {
        this.initActionsLoggingErrors();
        return super.getActionDefinition(name);
    }

    @Override
    public List<VariableDefinition> getVariableDefinitions(CallerController caller, boolean hidden) {
        this.initVariablesLoggingErrors();
        return super.getVariableDefinitions(caller, hidden);
    }

    @Override
    public List<FunctionDefinition> getFunctionDefinitions(CallerController caller, boolean hidden) {
        this.initFunctionsLoggingErrors();
        return super.getFunctionDefinitions(caller, hidden);
    }

    @Override
    public List<EventDefinition> getEventDefinitions(CallerController caller, boolean hidden) {
        this.initEventsLoggingErrors();
        return super.getEventDefinitions(caller, hidden);
    }

    @Override
    public List<ActionDefinition> getActionDefinitions(CallerController caller, boolean hidden) {
        this.initActionsLoggingErrors();
        return super.getActionDefinitions(caller, hidden);
    }

    @Override
    public ContextStatus getStatus() {
        this.initStatusLoggingErrors();
        return super.getStatus();
    }

    private void initVariablesLoggingErrors() {
        try {
            this.initVariables();
        }
        catch (ContextException ex) {
            boolean disconnected = ExceptionUtils.indexOfType((Throwable)ex, DisconnectionException.class) != -1;
            String message = "Error initializing variables of remote context '" + this.getPathDescription() + "': " + ex.getMessage();
            Log.CONTEXT_VARIABLES.log((Priority)(disconnected ? Level.DEBUG : Level.WARN), (Object)message, (Throwable)ex);
            throw new ContextRuntimeException(message, ex);
        }
    }

    private void initFunctionsLoggingErrors() {
        try {
            this.initFunctions();
        }
        catch (ContextException ex) {
            boolean disconnected = ExceptionUtils.indexOfType((Throwable)ex, DisconnectionException.class) != -1;
            String message = "Error initializing functions of remote context '" + this.getPathDescription() + "': " + ex.getMessage();
            Log.CONTEXT_FUNCTIONS.log((Priority)(disconnected ? Level.DEBUG : Level.WARN), (Object)message, (Throwable)ex);
            throw new ContextRuntimeException(message, ex);
        }
    }

    private void initEventsLoggingErrors() {
        try {
            this.initEvents();
        }
        catch (ContextException ex) {
            boolean disconnected = ExceptionUtils.indexOfType((Throwable)ex, DisconnectionException.class) != -1;
            String message = "Error initializing events of remote context '" + this.getPathDescription() + "': " + ex.getMessage();
            Log.CONTEXT_EVENTS.log((Priority)(disconnected ? Level.DEBUG : Level.WARN), (Object)message, (Throwable)ex);
            throw new ContextRuntimeException(message, ex);
        }
    }

    private void initActionsLoggingErrors() {
        try {
            this.initActions();
        }
        catch (ContextException ex) {
            boolean disconnected = ExceptionUtils.indexOfType((Throwable)ex, DisconnectionException.class) != -1;
            Log.CONTEXT_ACTIONS.log((Priority)(disconnected ? Level.DEBUG : Level.WARN), (Object)("Error initializing actions of remote context '" + this.getPathDescription() + "': " + ex.getMessage()), (Throwable)ex);
        }
    }

    private void initStatusLoggingErrors() {
        try {
            this.initStatus();
        }
        catch (ContextException ex) {
            boolean disconnected = ExceptionUtils.indexOfType((Throwable)ex, DisconnectionException.class) != -1;
            Log.CONTEXT.log((Priority)(disconnected ? Level.DEBUG : Level.WARN), (Object)("Error initializing status of remote context '" + this.getPathDescription() + "': " + ex.getMessage()), (Throwable)ex);
        }
    }

    private IncomingAggreGateCommand sendGetVariable(String name, Long timeout) throws DisconnectionException, IOException, ContextException, InterruptedException, RemoteDeviceErrorException {
        OutgoingAggreGateCommand cmd = this.controller.getCommandBuilder().getVariableOperation(this.getPeerPath(), name);
        cmd.setTimeout(timeout);
        return this.controller.sendCommandAndCheckReplyCode(cmd);
    }

    DataTable getRemoteVariable(TableFormat format, String name, Long timeout) throws DisconnectionException, IOException, ContextException, InterruptedException, RemoteDeviceErrorException, SyntaxErrorException {
        String encodedReply = this.sendGetVariable(name, timeout).getEncodedDataTableFromReply();
        try {
            return this.controller.decodeRemoteDataTable(format, encodedReply);
        }
        catch (Exception ex) {
            throw new ContextException("Error parsing encoded data table '" + encodedReply + "': " + ex.getMessage(), ex);
        }
    }

    public AbstractAggreGateDeviceController getController() {
        return this.controller;
    }

    @Override
    protected void setupVariables() throws ContextException {
        this.initVariables();
        super.setupVariables();
    }

    @Override
    protected DataTable getVariableImpl(VariableDefinition def, CallerController caller, RequestController request) throws ContextException {
        return this.getRemoteVariable(def);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DataTable getRemoteVariable(VariableDefinition def) throws ContextException {
        try {
            boolean cleanup;
            block12: {
                cleanup = false;
                if (def.getRemoteCacheTime() == null) return this.getRemoteVariableImpl(def);
                this.variableCacheLock.readLock().lock();
                try {
                    SoftReference<CachedVariableValue> ref = this.variableCache.get(def.getName());
                    if (ref == null) break block12;
                    CachedVariableValue cachedValue = ref.get();
                    if (cachedValue != null) {
                        if (System.currentTimeMillis() - cachedValue.getTimestamp().getTime() < def.getRemoteCacheTime()) {
                            DataTable dataTable = cachedValue.getValue();
                            return dataTable;
                        }
                        cleanup = true;
                    } else {
                        cleanup = true;
                    }
                }
                finally {
                    this.variableCacheLock.readLock().unlock();
                }
            }
            if (!cleanup) return this.getRemoteVariableImpl(def);
            this.variableCacheLock.writeLock().lock();
            try {
                this.variableCache.remove(def.getName());
                return this.getRemoteVariableImpl(def);
            }
            finally {
                this.variableCacheLock.writeLock().unlock();
            }
        }
        catch (Exception ex) {
            Log.CONTEXT_VARIABLES.debug((Object)("Error getting variable '" + def.getName() + "' from context '" + this.getPathDescription() + "'"), (Throwable)ex);
            throw new ContextException(ex.getMessage(), ex);
        }
    }

    protected DataTable getRemoteVariableImpl(VariableDefinition def) throws ContextException, RemoteDeviceErrorException, InterruptedException, DisconnectionException, IOException, SyntaxErrorException {
        IncomingAggreGateCommand ans = this.sendGetVariable(def.getName(), null);
        DataTable value = this.controller.decodeRemoteDataTable(def.getFormat(), ans.getEncodedDataTableFromReply());
        if (def.getRemoteCacheTime() != null) {
            this.cacheVariableValue(def.getName(), value);
        }
        return value;
    }

    @Override
    protected boolean setVariableImpl(VariableDefinition def, CallerController caller, RequestController request, DataTable value) throws ContextException {
        try {
            String encoded = value.encode(this.controller.createClassicEncodingSettings(true));
            OutgoingAggreGateCommand operation = this.controller.getCommandBuilder().setVariableOperation(this.getPeerPath(), def.getName(), encoded, request != null ? request.getQueue() : null);
            this.controller.sendCommandAndCheckReplyCode(operation);
            return true;
        }
        catch (Exception ex) {
            Log.CONTEXT_VARIABLES.debug((Object)("Error setting variable '" + def.getName() + "' of context '" + this.getPathDescription() + "'"), (Throwable)ex);
            throw new ContextException(ex.getMessage(), ex);
        }
    }

    @Override
    protected void setupFunctions() throws ContextException {
        this.initFunctions();
        super.setupFunctions();
    }

    @Override
    protected DataTable callFunctionImpl(FunctionDefinition def, CallerController caller, RequestController request, DataTable parameters) throws ContextException {
        if (def.getName().equals(F_LOCAL_REINITIALIZE)) {
            this.reinitialize();
            return new SimpleDataTable(def.getOutputFormat(), true);
        }
        return this.callRemoteFunction(def.getName(), def.getOutputFormat(), parameters, request != null ? request.getQueue() : null, request == null || request.isReplyRequired());
    }

    protected DataTable callRemoteFunction(String name, TableFormat outputFormat, DataTable parameters, String queueName, boolean isReplyRequired) throws ContextException {
        try {
            return this.controller.callRemoteFunction(this.getPeerPath(), name, outputFormat, parameters, queueName, isReplyRequired);
        }
        catch (Exception ex) {
            Log.CONTEXT_FUNCTIONS.debug((Object)("Error calling function '" + name + "' of context '" + this.getPathDescription() + "'"), (Throwable)ex);
            throw new ContextException(ex.getMessage(), ex);
        }
    }

    @Override
    public boolean addEventListener(String name, ContextEventListener contextEventListener, boolean weak) {
        return this.addEventListener(name, contextEventListener, weak, true);
    }

    public boolean addEventListener(String name, ContextEventListener contextEventListener, boolean weak, boolean sendRemoteCommand) {
        try {
            this.initEvents();
            EventData ed = this.getEventData(name);
            if (ed == null) {
                throw new ContextException(Cres.get().getString("conEvtNotAvail") + name);
            }
            if (sendRemoteCommand) {
                this.addRemoteListener(ed.getDefinition().getName(), contextEventListener);
            }
            return super.addEventListener(name, contextEventListener, weak);
        }
        catch (Exception ex) {
            String msg = MessageFormat.format(Cres.get().getString("conErrAddingListener"), name, this.getPathDescription());
            throw new IllegalStateException(msg + ": " + ex.getMessage(), ex);
        }
    }

    @Override
    public boolean removeEventListener(String name, ContextEventListener contextEventListener) {
        return this.removeEventListener(name, contextEventListener, true);
    }

    public boolean removeEventListener(String name, ContextEventListener listener, boolean sendRemoteCommand) {
        try {
            if (!this.isInitializedEvents()) {
                return false;
            }
            Log.CONTEXT_EVENTS.debug((Object)("Removing listener for event '" + name + "' from context '" + this.getPathDescription() + "'"));
            boolean res = super.removeEventListener(name, listener);
            EventData ed = this.getEventData(name);
            if (sendRemoteCommand && this.getController().isConnected() && ed != null && !ed.hasListeners()) {
                ProtocolVersion protocolVersion = this.getController().getProtocolVersion();
                if (!this.notManageRemoteListeners && protocolVersion != null && protocolVersion.ordinal() >= ProtocolVersion.V3.ordinal()) {
                    Integer hashCode = listener.getListenerCode();
                    String filter = listener.getFilter() != null ? listener.getFilter().getText() : null;
                    String fingerprint = listener.getFingerprint();
                    OutgoingAggreGateCommand cmd = this.controller.getCommandBuilder().removeEventListenerOperation(this.getPeerPath(), name, hashCode, filter, fingerprint);
                    cmd.setTimeout(120000L);
                    this.controller.sendCommandAndCheckReplyCode(cmd);
                }
            }
            return res;
        }
        catch (DisconnectionException ex) {
            Log.CONTEXT_EVENTS.debug((Object)("Disconnection detected when removing listener for event '" + name + "' from context '" + this.getPathDescription() + "'"));
            return false;
        }
        catch (Exception ex) {
            String msg = MessageFormat.format(Cres.get().getString("conErrRemovingListener"), name, this.getPathDescription());
            throw new IllegalStateException(msg + ": " + ex.getMessage(), ex);
        }
    }

    private void addRemoteListener(String ename, ContextEventListener contextEventListener) throws RemoteDeviceErrorException, InterruptedException, SyntaxErrorException, DisconnectionException, IOException, ContextException {
        Integer hashCode = contextEventListener.getListenerCode();
        if (hashCode == null && AUTO_LISTENED_EVENTS.contains(ename)) {
            return;
        }
        ProtocolVersion protocolVersion = this.getController().getProtocolVersion();
        if (!this.notManageRemoteListeners && protocolVersion != null && protocolVersion.ordinal() >= ProtocolVersion.V3.ordinal()) {
            String filterText = contextEventListener.getFilter() != null ? contextEventListener.getFilter().getText() : null;
            String fingerprint = contextEventListener.getFingerprint();
            OutgoingAggreGateCommand cmd = this.controller.getCommandBuilder().addEventListenerOperation(this.getPeerPath(), ename, hashCode, filterText, fingerprint);
            cmd.setTimeout(120000L);
            this.controller.sendCommandAndCheckReplyCode(cmd);
        }
    }

    @Override
    public List<C> getChildren(CallerController caller) {
        try {
            this.initChildren();
        }
        catch (ContextException ex) {
            boolean disconnected = ExceptionUtils.indexOfType((Throwable)ex, DisconnectionException.class) != -1;
            Log.CONTEXT_CHILDREN.log((Priority)(disconnected ? Level.DEBUG : Level.WARN), (Object)"Error initializing children of remote context", (Throwable)ex);
        }
        return super.getChildren(caller);
    }

    @Override
    public List<C> getVisibleChildren(CallerController caller) {
        try {
            this.initVisibleChildren();
        }
        catch (ContextException ex) {
            boolean disconnected = ExceptionUtils.indexOfType((Throwable)ex, DisconnectionException.class) != -1;
            Log.CONTEXT_CHILDREN.log((Priority)(disconnected ? Level.DEBUG : Level.WARN), (Object)"Error initializing visible children of remote context", (Throwable)ex);
            return new LinkedList();
        }
        LinkedList res = new LinkedList();
        for (String path : this.visibleChildren) {
            Object con = this.getRoot().get(path, caller);
            if (con == null) continue;
            res.add(con);
        }
        return res;
    }

    public void addVisibleChild(String localVisiblePath) {
        this.visibleChildren.add(localVisiblePath);
    }

    public void removeVisibleChild(String localVisiblePath) {
        this.visibleChildren.remove(localVisiblePath);
    }

    public boolean hasVisibleChild(String path) {
        return this.visibleChildren != null && this.visibleChildren.contains(path);
    }

    private void restoreEventListeners() throws ContextException {
        for (EventDefinition ed : super.getEventDefinitions((CallerController)null)) {
            EventData edata = this.getEventData(ed.getName());
            edata.doWithListeners(listener -> {
                try {
                    this.addRemoteListener(ed.getName(), listener.getListener());
                }
                catch (Exception ex) {
                    Log.CONTEXT_EVENTS.warn((Object)("Error restoring listener for event '" + ed.getName() + "'"), (Throwable)ex);
                }
            });
        }
    }

    public void reinitialize() throws ContextException {
        this.clear();
        this.restoreEventListeners();
    }

    @Override
    protected Event fireEvent(EventDefinition ed, DataTable data, int level, Long id, Date creationtime, Integer listener, CallerController caller, FireEventRequestController request, Permissions permissions) {
        Event event = super.fireEvent(ed, data, level, id, creationtime, listener, caller, request, permissions);
        if (ed.getName().equals("updated") && this.isInitializedVariables()) {
            String variable = event.getData().rec().getString("variable");
            DataTable value = event.getData().rec().getDataTable("value");
            VariableDefinition vd = this.getVariableDefinition(variable);
            if (vd != null && vd.getRemoteCacheTime() != null) {
                this.cacheVariableValue(variable, value);
            }
        }
        return event;
    }

    private void cacheVariableValue(String variable, DataTable value) {
        this.variableCacheLock.writeLock().lock();
        try {
            this.variableCache.put(variable, new SoftReference<CachedVariableValue>(new CachedVariableValue(new Date(), value)));
        }
        finally {
            this.variableCacheLock.writeLock().unlock();
        }
    }

    protected String getPathDescription() {
        return this.getPath();
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    @Override
    public boolean isDistributed() {
        return this.getPeerRoot() != null;
    }

    @Override
    public String getRemotePath() {
        try {
            this.initInfo();
        }
        catch (ContextException ex) {
            throw new ContextRuntimeException("Error getting type of remote context: " + ex.getMessage(), ex);
        }
        return this.remotePath;
    }

    @Override
    public String getLocalPrimaryRoot() {
        return this.peerPrimaryRoot;
    }

    @Override
    public String getPeerPath() {
        return this.getPath();
    }

    public String getLocalPath(String remoteFullPath, boolean visible) {
        String remoteConverted;
        String remoteRoot;
        String string = remoteRoot = visible ? this.getPeerRoot() : this.getRemoteRoot();
        if (remoteRoot == null) {
            return remoteFullPath;
        }
        if (remoteRoot.equals("")) {
            remoteConverted = remoteFullPath;
        } else if (remoteFullPath.equals(remoteRoot)) {
            remoteConverted = "";
        } else {
            return this.getLocalPrimaryPath(remoteFullPath);
        }
        String localRoot = this.getLocalRoot(!visible);
        String converted = remoteConverted.length() > 0 ? (localRoot.length() > 0 ? ContextUtils.createName(localRoot, remoteConverted) : remoteConverted) : localRoot;
        return converted;
    }

    private String getLocalPrimaryPath(String remoteFullPath) {
        String primaryMount = this.getLocalPrimaryRoot();
        if (primaryMount == null) {
            return null;
        }
        if (Util.equals("", remoteFullPath)) {
            return primaryMount;
        }
        return ContextUtils.createName(primaryMount, remoteFullPath);
    }

    protected String getLocalVisiblePath(String peerVisiblePath) {
        return peerVisiblePath;
    }

    @Override
    public String toString() {
        if (this.isInitializedInfo()) {
            return super.toString();
        }
        return this.getPath();
    }

    @Override
    public boolean isInitializedStatus() {
        return this.initializedStatus;
    }

    @Override
    public boolean isInitializedInfo() {
        return this.initializedInfo;
    }

    @Override
    public boolean isInitializedChildren() {
        return this.initializedChildren;
    }

    @Override
    public boolean isInitializedVariables() {
        return this.initializedVariables;
    }

    @Override
    public boolean isInitializedFunctions() {
        return this.initializedFunctions;
    }

    @Override
    public boolean isInitializedEvents() {
        return this.initializedEvents;
    }

    public boolean isNotManageRemoteListeners() {
        return this.notManageRemoteListeners;
    }

    @Override
    public boolean isContainer() {
        return this.container;
    }

    public void setContainer(boolean container) {
        this.container = container;
    }

    public void setNotManageRemoteListeners(boolean notManageRemoteListeners) {
        this.notManageRemoteListeners = notManageRemoteListeners;
    }

    static {
        AUTO_LISTENED_EVENTS.add("childAdded");
        AUTO_LISTENED_EVENTS.add("childRemoved");
        AUTO_LISTENED_EVENTS.add("variableAdded");
        AUTO_LISTENED_EVENTS.add("variableRemoved");
        AUTO_LISTENED_EVENTS.add("functionAdded");
        AUTO_LISTENED_EVENTS.add("functionRemoved");
        AUTO_LISTENED_EVENTS.add("eventAdded");
        AUTO_LISTENED_EVENTS.add("eventRemoved");
        AUTO_LISTENED_EVENTS.add("infoChanged");
        AUTO_LISTENED_EVENTS.add("destroyed");
        AUTO_LISTENED_EVENTS.add("actionAdded");
        AUTO_LISTENED_EVENTS.add("actionRemoved");
        AUTO_LISTENED_EVENTS.add("actionStateChanged");
        AUTO_LISTENED_EVENTS.add("visibleInfoChanged");
        AUTO_LISTENED_EVENTS.add("visibleChildAdded");
        AUTO_LISTENED_EVENTS.add("visibleChildRemoved");
    }
}

