/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import com.tibbo.aggregate.common.datatable.encoding.TransferEncodingHelper;
import com.tibbo.aggregate.common.protocol.AggreGateCommand;
import com.tibbo.aggregate.common.protocol.OutgoingAggreGateCommand;
import com.tibbo.aggregate.common.protocol.OutgoingJsonCommand;
import com.tibbo.aggregate.common.protocol.ProtocolVersion;

public class ProtocolCommandBuilder {
    private final boolean json;
    public static final String CLIENT_COMMAND_SEPARATOR = String.valueOf('\u0017');

    public ProtocolCommandBuilder(boolean json) {
        this.json = json;
    }

    public OutgoingAggreGateCommand createCommand() {
        return ProtocolCommandBuilder.createCommand(this.json);
    }

    public static OutgoingAggreGateCommand createCommand(boolean json) {
        if (json) {
            return new OutgoingJsonCommand();
        }
        return new OutgoingAggreGateCommand();
    }

    public OutgoingAggreGateCommand startMessage() {
        return this.startMessage(ProtocolVersion.V4.notation());
    }

    public OutgoingAggreGateCommand startMessage(String version) {
        OutgoingAggreGateCommand cmd = ProtocolCommandBuilder.createCommand(this.json);
        cmd.addParam(String.valueOf('M'));
        cmd.addParam(AggreGateCommand.generateId());
        cmd.addParam(String.valueOf('S'));
        cmd.addParam(version);
        return cmd;
    }

    public OutgoingAggreGateCommand operationMessage() {
        OutgoingAggreGateCommand cmd = ProtocolCommandBuilder.createCommand(this.json);
        cmd.addParam(String.valueOf('M'));
        cmd.addParam(AggreGateCommand.generateId());
        cmd.addParam(String.valueOf('O'));
        return cmd;
    }

    public OutgoingAggreGateCommand getVariableOperation(String context, String name) {
        OutgoingAggreGateCommand cmd = this.operationMessage();
        cmd.addParam(String.valueOf('G'));
        cmd.addParam(context);
        cmd.addParam(name);
        return cmd;
    }

    public OutgoingAggreGateCommand setVariableOperation(String context, String name, String encodedValue, String queueName) {
        OutgoingAggreGateCommand cmd = this.operationMessage();
        cmd.addParam(String.valueOf('S'));
        cmd.addParam(context);
        cmd.addParam(name);
        cmd.addParam(encodedValue);
        if (queueName != null) {
            cmd.addParam(TransferEncodingHelper.encode(queueName));
        }
        return cmd;
    }

    public OutgoingAggreGateCommand callFunctionOperation(String context, String name, String encodedInput, String queueName, String flags) {
        OutgoingAggreGateCommand cmd = this.operationMessage();
        cmd.addParam(String.valueOf('C'));
        cmd.addParam(context);
        cmd.addParam(name);
        cmd.addParam(encodedInput);
        if (queueName != null || flags != null) {
            if (queueName == null) {
                queueName = "";
            }
            cmd.addParam(TransferEncodingHelper.encode(queueName));
        }
        if (flags != null) {
            cmd.addParam(TransferEncodingHelper.encode(flags));
        }
        return cmd;
    }

    public OutgoingAggreGateCommand addEventListenerOperation(String context, String name, Integer listenerHashCode, String filter, String fingerprint) {
        return this.eventListenerOperation('L', context, name, listenerHashCode, filter, fingerprint);
    }

    public OutgoingAggreGateCommand removeEventListenerOperation(String context, String name, Integer listenerHashCode, String filter, String fingerprint) {
        return this.eventListenerOperation('R', context, name, listenerHashCode, filter, fingerprint);
    }

    private OutgoingAggreGateCommand eventListenerOperation(char commandName, String context, String name, Integer listenerHashCode, String filter, String fingerprint) {
        OutgoingAggreGateCommand cmd = this.operationMessage();
        cmd.addParam(String.valueOf(commandName));
        cmd.addParam(context);
        cmd.addParam(name);
        cmd.addParam(listenerHashCode != null ? listenerHashCode.toString() : "");
        if (filter != null) {
            cmd.addParam(TransferEncodingHelper.encode(filter));
        } else if (fingerprint != null) {
            cmd.addParam("");
        }
        if (fingerprint != null) {
            cmd.addParam(TransferEncodingHelper.encode(fingerprint));
        }
        return cmd;
    }
}

