/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.datatable.encoding.TransferEncodingHelper;
import com.tibbo.aggregate.common.protocol.AggreGateCommand;
import com.tibbo.aggregate.common.util.StringUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;

public class OutgoingAggreGateCommand
extends AggreGateCommand {
    private static final byte[] CLIENT_COMMAND_SEPARATOR = AggreGateCommand.CLIENT_COMMAND_SEPARATOR.getBytes();
    protected int paramCount = 0;
    protected String id;
    protected boolean async;

    @Override
    public String header() {
        return Character.toString('\u0002');
    }

    @Override
    public String footer() {
        return Character.toString('\r');
    }

    public OutgoingAggreGateCommand addParam(String param) {
        if (this.paramCount != 0) {
            this.write(CLIENT_COMMAND_SEPARATOR, 0, CLIENT_COMMAND_SEPARATOR.length);
        }
        if (this.paramCount == 1) {
            this.id = param;
        }
        try {
            if (param.length() > 0x3200000) {
                this.writeLargeData(param);
            } else {
                byte[] paramBytes = param.getBytes(StringUtils.UTF8_CHARSET);
                if (this.size() + paramBytes.length > this.buf.length) {
                    this.buf = Arrays.copyOf(this.buf, this.buf.length + paramBytes.length);
                }
                this.write(paramBytes);
            }
        }
        catch (Exception ex) {
            Log.COMMANDS.warn((Object)ex.getMessage(), (Throwable)ex);
        }
        ++this.paramCount;
        return this;
    }

    private void writeLargeData(String param) throws IOException {
        Integer estimatedSize = this.estimateSize(param);
        this.buf = Arrays.copyOf(this.buf, this.buf.length + estimatedSize);
        for (int i = 0; i < param.length(); i += 0x100000) {
            int end = i + 0x100000;
            if (end > param.length()) {
                end = param.length();
            }
            String subString = param.substring(i, end);
            this.write(subString.getBytes(StringUtils.UTF8_CHARSET));
        }
    }

    private Integer estimateSize(String param) {
        Integer bufferLength = 0;
        for (int i = 0; i < param.length(); i += 0x100000) {
            int end = i + 0x100000;
            if (end > param.length()) {
                end = param.length();
            }
            String subString = param.substring(i, end);
            bufferLength = bufferLength + subString.getBytes(StringUtils.UTF8_CHARSET).length;
        }
        return bufferLength;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    @Override
    public boolean isAsync() {
        return this.async;
    }

    public void constructReply(String id, String code) {
        if (this.paramCount > 0) {
            throw new IllegalStateException("Can't construct reply - parameters already added to command");
        }
        this.addParam(String.valueOf('R'));
        this.addParam(id);
        this.addParam(code);
    }

    public void constructReply(String id, String code, String message) {
        this.constructReply(id, code);
        this.addParam(TransferEncodingHelper.encode(message));
    }

    public void constructReply(String id, String code, String message, String details) {
        this.constructReply(id, code, message);
        this.addParam(TransferEncodingHelper.encode(details));
    }

    public void constructEvent(String context, String name, int level, String encodedDataTable, Long eventId, Date creationtime, Integer listener) {
        this.id = new String();
        this.setAsync(true);
        this.addParam(String.valueOf('M'));
        this.addParam(this.id);
        this.addParam(String.valueOf('E'));
        this.addParam(context);
        this.addParam(name);
        this.addParam(String.valueOf(level));
        this.addParam(eventId != null ? eventId.toString() : "");
        this.addParam(listener != null ? listener.toString() : "");
        this.addParam(encodedDataTable);
        this.addParam(creationtime != null ? String.valueOf(creationtime.getTime()) : "");
    }
}

