/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.datatable.encoding.TransferEncodingHelper;
import com.tibbo.aggregate.common.protocol.AggreGateCommand;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.StringWrapper;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class IncomingAggreGateCommand
extends AggreGateCommand {
    private static final String EMPTY_ID = "";
    protected List<StringWrapper> parameters = null;
    private boolean jsonBody = false;

    public IncomingAggreGateCommand(byte[] data) throws SyntaxErrorException {
        this.write(data, 0, data.length);
        this.parse();
    }

    public IncomingAggreGateCommand(String str) throws SyntaxErrorException {
        this.write(str.getBytes(), 0, str.getBytes().length);
        this.parse();
    }

    public IncomingAggreGateCommand(ByteArrayOutputStream s) throws SyntaxErrorException {
        this.write(s.toByteArray(), 0, s.size());
        this.parse();
    }

    protected void parse() throws SyntaxErrorException {
        if (this.isContentEmpty()) {
            throw new SyntaxErrorException("Zero length command received");
        }
        if (this.buf.length > 0 && this.buf[0] == 91) {
            this.jsonBody = true;
            this.parseJsonCommand();
        } else if (this.buf.length < 0x3200000) {
            this.parameters = StringWrapper.split(this.getContent(), AggreGateCommand.CLIENT_COMMAND_SEPARATOR.charAt(0));
        } else {
            this.parseBigCommand();
        }
    }

    private void parseJsonCommand() throws SyntaxErrorException {
        block4: {
            this.parameters = new LinkedList<StringWrapper>();
            JSONParser json = new JSONParser();
            try {
                Object result = json.parse(this.getContent());
                if (result instanceof JSONArray) {
                    for (Object o : (JSONArray)result) {
                        this.parameters.add(StringWrapper.valueOf(o.toString()));
                    }
                    break block4;
                }
                throw new SyntaxErrorException("Unknown JSON object received");
            }
            catch (ParseException ex) {
                Log.COMMANDS.error((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    private void parseBigCommand() {
        ByteBuffer b = ByteBuffer.wrap(this.buf);
        this.parameters = new ArrayList<StringWrapper>();
        int position = 0;
        Integer end = null;
        while (b.hasRemaining()) {
            char currentChar = (char)b.get();
            if (currentChar == AggreGateCommand.CLIENT_COMMAND_SEPARATOR.charAt(0)) {
                this.parameters.add(StringWrapper.valueOf(new String(this.buf, position, b.position() - position - 1, StringUtils.UTF8_CHARSET)));
                position = b.position();
            } else {
                if (currentChar == '\u0000' && end == null) {
                    end = b.position() - 1;
                }
                if (currentChar != '\u0000' && end != null) {
                    end = null;
                }
            }
            if (b.hasRemaining()) continue;
            if (end == null) {
                end = this.buf.length;
            }
            this.parseDataUpdated(position);
        }
    }

    private void parseDataUpdated(Integer position) {
        try {
            String parameter = new String(this.buf, (int)position, this.buf.length - position, StandardCharsets.UTF_8);
            this.parameters.add(StringWrapper.valueOf(parameter));
        }
        catch (Exception | OutOfMemoryError ex) {
            Log.COMMANDS.warn((Object)ex.getMessage(), ex);
        }
    }

    public int getNumberOfParameters() {
        return this.parameters != null ? this.parameters.size() : 0;
    }

    public boolean hasParameter(int number) {
        return number < this.getNumberOfParameters();
    }

    public StringWrapper getParameter(int number) {
        if (number > this.getNumberOfParameters()) {
            throw new IllegalArgumentException("Trying to access parameter #" + number + " of command that has only " + this.getNumberOfParameters() + " parameters");
        }
        return this.parameters.get(number);
    }

    public boolean isReply() {
        StringWrapper param = this.getParameter(0);
        if (param.length() > 1) {
            throw new IllegalStateException("Invalid command type: " + param);
        }
        return param.charAt(0) == 'R';
    }

    public boolean isMessage() {
        StringWrapper param = this.getParameter(0);
        if (param.length() > 1) {
            throw new IllegalStateException("Invalid command type: " + param);
        }
        return param.charAt(0) == 'M';
    }

    public String getReplyCode() {
        if (!this.isReply()) {
            throw new UnsupportedOperationException("Command is not a reply");
        }
        return this.getParameter(2).getString();
    }

    public StringWrapper getMessageCode() {
        if (!this.isMessage()) {
            throw new UnsupportedOperationException("Command is not a message");
        }
        return this.getParameter(2);
    }

    public String getEncodedDataTable(int index) throws ContextException, SyntaxErrorException {
        return this.getParameter(index).getString();
    }

    public String getEncodedDataTableFromReply() throws ContextException, SyntaxErrorException {
        if (!this.isReply()) {
            throw new UnsupportedOperationException("Command is not a reply");
        }
        return this.getEncodedDataTable(3);
    }

    public String getEncodedDataTableFromOperationMessage() throws ContextException, SyntaxErrorException {
        if (!this.isMessage()) {
            throw new UnsupportedOperationException("Command is not a message");
        }
        return this.getEncodedDataTable(6);
    }

    public String getEncodedDataTableFromEventMessage() throws ContextException, SyntaxErrorException {
        if (!this.isMessage()) {
            throw new UnsupportedOperationException("Command is not a message");
        }
        return this.getEncodedDataTable(8);
    }

    public String getQueueName() {
        if (!this.isMessage() || this.getMessageCode().charAt(0) != 'O') {
            return null;
        }
        char opcode = this.getParameter(3).charAt(0);
        if (opcode != 'S' && opcode != 'C') {
            return null;
        }
        if (this.hasParameter(7)) {
            return TransferEncodingHelper.decode(this.getParameter(7));
        }
        return null;
    }

    public String getFlags() {
        if (!this.isMessage() || this.getMessageCode().charAt(0) != 'O') {
            return null;
        }
        char opcode = this.getParameter(3).charAt(0);
        if (opcode != 'C') {
            return null;
        }
        if (this.hasParameter(8)) {
            return TransferEncodingHelper.decode(this.getParameter(8));
        }
        return null;
    }

    @Override
    public String getId() {
        return this.getNumberOfParameters() > 1 ? this.getParameter(1).getString() : EMPTY_ID;
    }

    @Override
    public boolean isAsync() {
        return this.isMessage();
    }

    public boolean isJsonBody() {
        return this.jsonBody;
    }
}

