/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import com.tibbo.aggregate.common.AggreGateException;
import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.SoftwareVersion;
import com.tibbo.aggregate.common.communication.CommandParserListener;
import com.tibbo.aggregate.common.communication.CommandWriter;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.CallerData;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.context.DefaultContextEventListener;
import com.tibbo.aggregate.common.context.FunctionDefinition;
import com.tibbo.aggregate.common.context.VariableDefinition;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableRegistry;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.encoding.FormatCache;
import com.tibbo.aggregate.common.datatable.encoding.KnownFormatCollector;
import com.tibbo.aggregate.common.datatable.encoding.TransferEncodingHelper;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.event.ContextEventListener;
import com.tibbo.aggregate.common.event.EventHandlingException;
import com.tibbo.aggregate.common.expression.Expression;
import com.tibbo.aggregate.common.protocol.AbstractClientController;
import com.tibbo.aggregate.common.protocol.AggreGateCommand;
import com.tibbo.aggregate.common.protocol.AggreGateCommandParser;
import com.tibbo.aggregate.common.protocol.CommandQueueManager;
import com.tibbo.aggregate.common.protocol.CommandTask;
import com.tibbo.aggregate.common.protocol.CompressedCommandWriter;
import com.tibbo.aggregate.common.protocol.IncomingAggreGateCommand;
import com.tibbo.aggregate.common.protocol.OutgoingAggreGateCommand;
import com.tibbo.aggregate.common.protocol.ProtocolCommandBuilder;
import com.tibbo.aggregate.common.protocol.ProtocolVersion;
import com.tibbo.aggregate.common.util.BlockingChannel;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.StringWrapper;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.SocketException;
import java.text.MessageFormat;
import java.util.Date;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;

public abstract class DefaultClientController<T extends CallerData>
extends AbstractClientController<T>
implements CommandParserListener {
    public static final int KEEP_ALIVE_PERIOD = 10000;
    private static final int KEEP_ALIVE_MULTIPLIER = 10;
    protected final boolean json;
    private final BlockingChannel dataChannel;
    private final AggreGateCommandParser commandParser;
    private final CommandWriter<OutgoingAggreGateCommand> commandWriter;
    private final ContextEventListener defaultEventListener;
    private final ExecutorService commandExecutionService;
    private final CommandQueueManager queueManager;
    private final boolean useCompression;
    private final BlockingQueue<OutgoingAggreGateCommand> pendingEventCommandsQueue;
    private final DataTableRegistry globalDataTableRegistry;
    protected long discardedEventsCount;
    protected KnownFormatCollector knownFormatCollector;
    private FormatCache formatCache;
    private volatile boolean shutDown = false;
    private Future pendingEventProcessingTask;
    private long startMessageCount;
    private Long lastDataTimestamp;
    private ProtocolVersion protocolVersion;
    private boolean keepAliveDisabled;

    public DefaultClientController(BlockingChannel dataChannel, ContextManager contextManager, ExecutorService commandExecutionService, FormatCache formatCache, DataTableRegistry globalDataTableRegistry, int pendingEventsQueueCapacity) {
        this(dataChannel, contextManager, commandExecutionService, formatCache, globalDataTableRegistry, pendingEventsQueueCapacity, false, false);
    }

    public DefaultClientController(BlockingChannel dataChannel, ContextManager contextManager, ExecutorService commandExecutionService, FormatCache formatCache, DataTableRegistry globalDataTableRegistry, int pendingEventsQueueCapacity, boolean json, boolean keepAliveDisabled) {
        super(contextManager);
        this.defaultEventListener = new ForwardingEventListener(contextManager, null, null, null);
        this.dataChannel = dataChannel;
        this.commandExecutionService = commandExecutionService;
        this.formatCache = formatCache;
        this.globalDataTableRegistry = globalDataTableRegistry;
        this.useCompression = dataChannel.isUsesCompression();
        this.json = json;
        this.keepAliveDisabled = keepAliveDisabled;
        if (this.useCompression) {
            dataChannel.setUsesCompression(false);
        }
        this.commandParser = new AggreGateCommandParser(dataChannel);
        this.commandWriter = new CompressedCommandWriter<OutgoingAggreGateCommand>();
        this.commandParser.setListener(this);
        this.queueManager = new CommandQueueManager(commandExecutionService);
        this.pendingEventCommandsQueue = new LinkedBlockingQueue<OutgoingAggreGateCommand>(pendingEventsQueueCapacity);
        this.knownFormatCollector = new KnownFormatCollector();
    }

    public static String searchForCode(Throwable ex) {
        return DefaultClientController.searchForCode(ex, "E");
    }

    public static String searchForCode(Throwable ex, String fallbackCode) {
        AggreGateException aex;
        if (ex instanceof AggreGateException && (aex = (AggreGateException)ex).getCode() != null) {
            return aex.getCode();
        }
        return ex.getCause() != null ? DefaultClientController.searchForCode(ex.getCause()) : fallbackCode;
    }

    public void setKnownFormatCollector(KnownFormatCollector knownFormatCollector) {
        this.knownFormatCollector = knownFormatCollector;
    }

    public void processOperationGetVar(String id, Context con, String name, OutgoingAggreGateCommand ans) throws ContextException {
        VariableDefinition vd;
        if (Log.CLIENTS.isDebugEnabled()) {
            Log.CLIENTS.debug((Object)("Getting variable '" + name + "' from context '" + con.getPath() + "'"));
        }
        if ((vd = this.getVariableDefinition(con, name)) == null) {
            ans.constructReply(id, "D", Cres.get().getString("conVarNotAvail") + name);
            return;
        }
        DataTable result = this.getVariable(con, name);
        if (!result.isSimple()) {
            long tableId = result.getId() != null ? result.getId().longValue() : this.globalDataTableRegistry.add(result);
            DataTable previousValue = this.getCallerController().getCallerData().addToLocalRegistry(tableId, result);
            if (previousValue != null) {
                Log.CLIENTS.warn((Object)("Data table '" + previousValue + "' with id " + tableId + " was replaced with data table '" + result + "' in the local registry of caller controller: " + this.getCallerController()));
            }
        }
        ans.constructReply(id, "A");
        ans.addParam(result.encode(this.createClassicEncodingSettings(vd.getFormat() != null)));
    }

    protected DataTable getVariable(Context con, String name) throws ContextException {
        return con.getVariable(name, this.getCallerController());
    }

    public void processOperationSetVar(String id, Context con, String name, String encodedValue, OutgoingAggreGateCommand ans) throws ContextException {
        VariableDefinition vd;
        if (Log.CLIENTS.isDebugEnabled()) {
            Log.CLIENTS.debug((Object)("Setting variable '" + name + "' of context '" + con.getPath() + "'"));
        }
        if ((vd = this.getVariableDefinition(con, name)) == null) {
            ans.constructReply(id, "D", Cres.get().getString("conVarNotAvail") + name);
            return;
        }
        ClassicEncodingSettings settings = new ClassicEncodingSettings(false, vd.getFormat());
        settings.setProtocolVersion(this.protocolVersion);
        SimpleDataTable value = new SimpleDataTable(encodedValue, settings, true);
        this.setVariable(con, name, value);
        ans.constructReply(id, "A");
    }

    protected VariableDefinition getVariableDefinition(Context con, String name) {
        return con.getVariableDefinition(name);
    }

    protected void setVariable(Context con, String name, DataTable value) throws ContextException {
        con.setVariable(name, this.getCallerController(), value);
    }

    public OutgoingAggreGateCommand processOperationCallFunction(String id, Context con, String name, String encodedParameters, String flags, OutgoingAggreGateCommand ans) throws ContextException {
        try {
            FunctionDefinition fd;
            if (Log.CLIENTS.isDebugEnabled()) {
                Log.CLIENTS.debug((Object)("Calling function '" + name + "' of context '" + con.getPath() + "'"));
            }
            if ((fd = this.getFunctionDefinition(con, name)) == null) {
                ans.constructReply(id, "D", Cres.get().getString("conFuncNotAvail") + name);
                return ans;
            }
            ClassicEncodingSettings settings = new ClassicEncodingSettings(false, fd.getInputFormat());
            settings.setProtocolVersion(this.protocolVersion);
            SimpleDataTable parameters = new SimpleDataTable(encodedParameters, settings, true);
            DataTable result = this.callFunction(con, name, parameters);
            if ("N".equals(flags)) {
                return null;
            }
            ans.constructReply(id, "A");
            return ans.addParam(result.encode(this.createClassicEncodingSettings(fd.getOutputFormat() != null)));
        }
        catch (OutOfMemoryError ex) {
            Log.COMMANDS.warn((Object)ex.getMessage(), (Throwable)ex);
            if ("N".equals(flags)) {
                return null;
            }
            return ans;
        }
    }

    protected FunctionDefinition getFunctionDefinition(Context con, String name) {
        return con.getFunctionDefinition(name);
    }

    protected DataTable callFunction(Context con, String name, DataTable parameters) throws ContextException {
        return con.callFunction(name, this.getCallerController(), parameters);
    }

    protected boolean addNormalListener(String context, String name, ContextEventListener cel) {
        Context con = this.getContext(context);
        if (con != null) {
            return con.addEventListener(name, cel, true);
        }
        return false;
    }

    public void processOperationAddEventListener(String id, String context, String name, Integer listener, String filter, String fingerprint, OutgoingAggreGateCommand ans) {
        if (Log.CLIENTS.isDebugEnabled()) {
            Log.CLIENTS.debug((Object)("Adding listener for event '" + name + "' of context '" + context + "'"));
        }
        ContextEventListener cel = this.createListener(listener, filter != null ? new Expression(filter) : null, fingerprint);
        this.addMaskListener(context, name, cel, true);
        ans.constructReply(id, "A");
    }

    public void processOperationRemoveEventListener(String id, String context, String name, Integer listenerHashCode, String filter, String fingerprint, OutgoingAggreGateCommand ans) {
        if (Log.CLIENTS.isDebugEnabled()) {
            Log.CLIENTS.debug((Object)("Removing listener for event '" + name + "' of context '" + context + "'"));
        }
        ContextEventListener cel = this.createListener(listenerHashCode, filter != null ? new Expression(filter) : null, fingerprint);
        this.removeMaskListener(context, name, cel);
        ans.constructReply(id, "A");
    }

    public OutgoingAggreGateCommand processMessageStart(IncomingAggreGateCommand cmd, OutgoingAggreGateCommand ans) {
        String receivedVersion = cmd.getParameter(3).getString();
        this.protocolVersion = StringUtils.isEmpty(receivedVersion) ? ProtocolVersion.V2 : ProtocolVersion.byNotation(receivedVersion);
        Log.CLIENTS.debug((Object)("Processing start command, client protocol version: " + (Object)((Object)this.protocolVersion) + "', compression '" + Boolean.toString(this.useCompression) + "'"));
        if (this.protocolVersion == null) {
            ans.constructReply(cmd.getId(), "D");
            Log.CLIENTS.debug((Object)("Rejecting client connection with unsupported version '" + (Object)((Object)this.protocolVersion) + "'"));
            return ans;
        }
        ans.constructReply(cmd.getId(), "A");
        ans.addParam(this.protocolVersion.notation());
        if (this.useCompression) {
            ans.addParam(String.valueOf('C'));
        }
        this.commandParser.setVersion(this.protocolVersion);
        this.commandWriter.setVersionAfterNextWrite(this.protocolVersion);
        ++this.startMessageCount;
        return ans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected OutgoingAggreGateCommand processMessageOperation(IncomingAggreGateCommand cmd, OutgoingAggreGateCommand ans) throws SyntaxErrorException, ContextException {
        String operation = cmd.getParameter(3).getString();
        String context = cmd.getParameter(4).getString();
        String target = cmd.getParameter(5).getString();
        String originalThreadName = Thread.currentThread().getName();
        Thread.currentThread().setName(originalThreadName + ": " + operation + "/" + context + "/" + target);
        try {
            if (operation.length() > 1) {
                throw new SyntaxErrorException(Cres.get().getString("clInvalidOpcode") + operation);
            }
            if (Log.CLIENTS.isDebugEnabled()) {
                Log.CLIENTS.debug((Object)("Processing message, context '" + context + "', target '" + target + "', operation '" + operation + "'"));
            }
            switch (operation.charAt(0)) {
                case 'L': {
                    String listenerStr = cmd.getParameter(6).getString();
                    Integer listener = listenerStr.length() > 0 ? new Integer(listenerStr) : null;
                    String filter = cmd.hasParameter(7) ? TransferEncodingHelper.decode(cmd.getParameter(7)) : null;
                    String fingerprint = cmd.hasParameter(8) ? TransferEncodingHelper.decode(cmd.getParameter(8)) : null;
                    this.processOperationAddEventListener(cmd.getId(), context, target, listener, filter, fingerprint, ans);
                    OutgoingAggreGateCommand outgoingAggreGateCommand = ans;
                    return outgoingAggreGateCommand;
                }
                case 'R': {
                    String listenerStr = cmd.getParameter(6).getString();
                    Integer listener = listenerStr.length() > 0 ? new Integer(listenerStr) : null;
                    String filter = cmd.hasParameter(7) ? TransferEncodingHelper.decode(cmd.getParameter(7)) : null;
                    String fingerprint = cmd.hasParameter(8) ? TransferEncodingHelper.decode(cmd.getParameter(8)) : null;
                    this.processOperationRemoveEventListener(cmd.getId(), context, target, listener, filter, fingerprint, ans);
                    OutgoingAggreGateCommand outgoingAggreGateCommand = ans;
                    return outgoingAggreGateCommand;
                }
            }
            Context con = this.getContext(context);
            if (con == null) {
                throw new ContextException(Cres.get().getString("conNotAvail") + context);
            }
            if (this.addNormalListener(con.getPath(), "destroyed", this.defaultEventListener)) {
                this.addNormalListener(con.getPath(), "childAdded", this.defaultEventListener);
                this.addNormalListener(con.getPath(), "childRemoved", this.defaultEventListener);
                this.addNormalListener(con.getPath(), "variableAdded", this.defaultEventListener);
                this.addNormalListener(con.getPath(), "variableRemoved", this.defaultEventListener);
                this.addNormalListener(con.getPath(), "functionAdded", this.defaultEventListener);
                this.addNormalListener(con.getPath(), "functionRemoved", this.defaultEventListener);
                this.addNormalListener(con.getPath(), "eventAdded", this.defaultEventListener);
                this.addNormalListener(con.getPath(), "eventRemoved", this.defaultEventListener);
                this.addNormalListener(con.getPath(), "infoChanged", this.defaultEventListener);
                this.addNormalListener(con.getPath(), "actionAdded", this.defaultEventListener);
                this.addNormalListener(con.getPath(), "actionRemoved", this.defaultEventListener);
                this.addNormalListener(con.getPath(), "actionStateChanged", this.defaultEventListener);
                this.addCustomListeners(con);
            }
            switch (operation.charAt(0)) {
                case 'G': {
                    this.processOperationGetVar(cmd.getId(), con, target, ans);
                    return ans;
                }
                case 'S': {
                    this.processOperationSetVar(cmd.getId(), con, target, cmd.getEncodedDataTableFromOperationMessage(), ans);
                    return ans;
                }
                case 'C': {
                    ans = this.processOperationCallFunction(cmd.getId(), con, target, cmd.getEncodedDataTableFromOperationMessage(), cmd.getFlags(), ans);
                    return ans;
                }
                default: {
                    throw new SyntaxErrorException(Cres.get().getString("clInvalidOpcode") + operation.charAt(0));
                }
            }
        }
        finally {
            Thread.currentThread().setName(originalThreadName);
        }
    }

    protected void addCustomListeners(Context con) {
    }

    protected OutgoingAggreGateCommand processMessage(IncomingAggreGateCommand cmd, OutgoingAggreGateCommand ans) throws SyntaxErrorException, ContextException {
        StringWrapper messageCode = cmd.getMessageCode();
        if (messageCode.length() > 1) {
            throw new SyntaxErrorException(Cres.get().getString("clInvalidMsgCode") + messageCode);
        }
        char code = messageCode.charAt(0);
        if (code != 'S' && this.startMessageCount == 0L) {
            Log.CLIENTS.debug((Object)"Can't process message: start message was not received yet");
            ans.constructReply(cmd.getId(), "D");
            return ans;
        }
        switch (code) {
            case 'S': {
                ans = this.processMessageStart(cmd, ans);
                break;
            }
            case 'O': {
                ans = this.processMessageOperation(cmd, ans);
                break;
            }
            default: {
                throw new SyntaxErrorException(Cres.get().getString("clInvalidMsgCode") + messageCode.charAt(0));
            }
        }
        return ans;
    }

    public OutgoingAggreGateCommand processCommand(IncomingAggreGateCommand cmd) {
        OutgoingAggreGateCommand ans;
        try {
            StringWrapper commandCode = cmd.getParameter(0);
            if (commandCode.length() > 1) {
                throw new AggreGateException(Cres.get().getString("clInvalidCmdCode") + commandCode);
            }
            switch (commandCode.charAt(0)) {
                case 'M': {
                    ans = this.processMessage(cmd, ProtocolCommandBuilder.createCommand(this.json));
                    break;
                }
                default: {
                    throw new AggreGateException(Cres.get().getString("clInvalidCmdCode") + commandCode.charAt(0));
                }
            }
        }
        catch (Throwable ex) {
            OutgoingAggreGateCommand err = ProtocolCommandBuilder.createCommand(this.json);
            if (Log.CLIENTS.isDebugEnabled()) {
                Log.CLIENTS.debug((Object)("Error processing command '" + AggreGateCommand.checkCommandString(cmd.toString()) + "': "), ex);
            }
            String code = DefaultClientController.searchForCode(ex);
            err.constructReply(cmd.getId(), code, ex.getMessage() != null ? ex.getMessage() : ex.toString(), this.getErrorDetails(ex));
            return err;
        }
        return ans;
    }

    @Override
    public void shutdown() {
        try {
            Log.CLIENTS.debug((Object)"Shutting down client controller");
            Future task = this.pendingEventProcessingTask;
            if (task != null) {
                task.cancel(true);
            }
            this.shutDown = true;
            if (this.dataChannel != null) {
                this.dataChannel.close();
            }
            this.logoutUser();
            super.shutdown();
        }
        catch (Exception ex) {
            Log.CLIENTS.warn((Object)"Error shutting down client controller: ", (Throwable)ex);
        }
    }

    protected void logoutUser() throws ContextException {
        if (this.getContextManager().getRoot().getFunctionDefinition("logout") != null) {
            this.getContextManager().getRoot().callFunction("logout", this.getCallerController());
        }
    }

    @Override
    public boolean run() {
        try {
            this.runImpl();
            if (!this.keepAliveDisabled && this.startMessageCount > 1L && this.lastDataTimestamp != null && System.currentTimeMillis() - this.lastDataTimestamp > 100000L) {
                throw new DisconnectionException("No data or keepalive messages");
            }
            this.dataChannel.flush();
            return true;
        }
        catch (IOException ex) {
            String msg = "I/O error while communicating with client";
            Log.CLIENTS.debug((Object)msg, (Throwable)ex);
            Log.CLIENTS.info((Object)(msg + ": " + ex));
            return false;
        }
        catch (DisconnectionException ex) {
            Log.CLIENTS.info((Object)("Client disconnected: " + ex.getMessage()));
            CallerController currentCallerController = this.getCallerController();
            if (currentCallerController != null) {
                currentCallerController.unlockAllContexts();
            }
            return false;
        }
        catch (Exception ex) {
            Log.CLIENTS.warn((Object)"Error in client controller", (Throwable)ex);
            return false;
        }
    }

    public void runImpl() throws IOException, DisconnectionException, SyntaxErrorException {
        IncomingAggreGateCommand command = (IncomingAggreGateCommand)this.commandParser.readCommand();
        if (command != null) {
            if (Log.COMMANDS_CLIENT.isDebugEnabled()) {
                Log.COMMANDS_CLIENT.debug((Object)("Received: " + command));
            }
            try {
                String queue = command.getQueueName();
                if (queue != null && !queue.isEmpty()) {
                    ProcessCommandTask task = new ProcessCommandTask(command);
                    this.queueManager.addCommand(queue, task);
                } else {
                    this.commandExecutionService.submit(new ProcessCommandTask(command));
                }
            }
            catch (RejectedExecutionException ex) {
                OutgoingAggreGateCommand reply = ProtocolCommandBuilder.createCommand(this.json);
                reply.constructReply(command.getId(), "E", Cres.get().getString("devServerOverloaded"));
                this.sendCommand(reply);
            }
        }
    }

    protected String getErrorDetails(Throwable error) {
        StringBuilder buf = new StringBuilder();
        buf.append(Cres.get().getString("version")).append(": ").append(SoftwareVersion.getCurrentVersion()).append("\n");
        buf.append(Cres.get().getString("clServerTime")).append(": ").append(new Date()).append("\n");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        error.printStackTrace(new PrintStream(baos));
        buf.append(baos.toString());
        return buf.toString();
    }

    public void sendCommand(OutgoingAggreGateCommand cmd) throws DisconnectionException, IOException {
        this.commandWriter.write(cmd, this.dataChannel, true);
        if (Log.COMMANDS_CLIENT.isDebugEnabled()) {
            Log.COMMANDS_CLIENT.debug((Object)("Sent: " + cmd));
        }
    }

    public ContextEventListener createListener(Integer listenerHashCode, Expression filter, String fingerprint) {
        if (listenerHashCode == null) {
            return this.defaultEventListener;
        }
        return new ForwardingEventListener(this.getContextManager(), listenerHashCode, filter, fingerprint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPendingEvents() {
        while (!Thread.currentThread().isInterrupted()) {
            OutgoingAggreGateCommand current;
            BlockingQueue<OutgoingAggreGateCommand> blockingQueue = this.pendingEventCommandsQueue;
            synchronized (blockingQueue) {
                current = (OutgoingAggreGateCommand)this.pendingEventCommandsQueue.poll();
                if (current == null) {
                    return;
                }
                if (this.shutDown) {
                    return;
                }
            }
            try {
                this.sendCommand(current);
            }
            catch (DisconnectionException ex) {
                Log.CLIENTS.debug((Object)("Disconnection detected while forwarding event to client: " + ex.getMessage()), (Throwable)ex);
                return;
            }
            catch (Throwable ex) {
                String msg = "Exception while forwarding event to client: ";
                Log.CLIENTS.info((Object)(msg + ex.toString()));
                Log.CLIENTS.debug((Object)(msg + ex.getMessage()), ex);
            }
        }
    }

    protected Context getContext(String path) {
        return this.getContextManager().get(path, this.getCallerController());
    }

    public abstract boolean controllerShouldHandle(Event var1, ContextEventListener var2) throws EventHandlingException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPendingEventsCount() {
        BlockingQueue<OutgoingAggreGateCommand> blockingQueue = this.pendingEventCommandsQueue;
        synchronized (blockingQueue) {
            return this.pendingEventCommandsQueue.size();
        }
    }

    public long getDiscardedEventsCount() {
        return this.discardedEventsCount;
    }

    protected void discardEvent() {
        ++this.discardedEventsCount;
        if (Log.CLIENTS.isDebugEnabled()) {
            Log.CLIENTS.debug((Object)("Event queue overflow for client controller: " + this.toString()));
        }
    }

    public ContextEventListener getDefaultEventListener() {
        return this.defaultEventListener;
    }

    protected ClassicEncodingSettings createClassicEncodingSettings(boolean useFormatCache) {
        ClassicEncodingSettings settings = new ClassicEncodingSettings(false);
        settings.setProtocolVersion(this.protocolVersion);
        if (useFormatCache) {
            settings.setFormatCache(this.formatCache);
            settings.setKnownFormatCollector(this.knownFormatCollector);
        }
        return settings;
    }

    public OutgoingAggreGateCommand constructEventCommand(Event event, Integer listenerCode) {
        OutgoingAggreGateCommand cmd = ProtocolCommandBuilder.createCommand(this.json);
        String data = event.getData().encode(this.createClassicEncodingSettings(true));
        cmd.constructEvent(event.getContext(), event.getName(), event.getLevel(), data, event.getId(), event.getCreationtime(), listenerCode);
        return cmd;
    }

    public void setFormatCache(FormatCache formatCache) {
        this.formatCache = formatCache;
    }

    public boolean isConnected() {
        return this.dataChannel.isOpen();
    }

    public String getAddress() {
        return this.dataChannel != null ? this.dataChannel.getChannelAddress() : null;
    }

    @Override
    public void newDataReceived() {
        this.lastDataTimestamp = System.currentTimeMillis();
    }

    public long getStartMessageCount() {
        return this.startMessageCount;
    }

    public Long getLastDataTimestamp() {
        return this.lastDataTimestamp;
    }

    public boolean isJson() {
        return this.json;
    }

    private void processCallerData() {
        if (this.getCallerController() != null) {
            this.getCallerController().getCallerData().cleanExpiredResources();
        }
    }

    private class PendingEventProcessingTask
    implements Runnable {
        private PendingEventProcessingTask() {
        }

        @Override
        public void run() {
            DefaultClientController.this.processPendingEvents();
        }
    }

    private class ProcessCommandTask
    implements CommandTask {
        private final IncomingAggreGateCommand cmd;

        public ProcessCommandTask(IncomingAggreGateCommand cmd) {
            this.cmd = cmd;
        }

        @Override
        public Object call() throws Exception {
            try {
                if (!DefaultClientController.this.shutDown) {
                    OutgoingAggreGateCommand reply = DefaultClientController.this.processCommand(this.cmd);
                    DefaultClientController.this.processPendingEvents();
                    DefaultClientController.this.processCallerData();
                    if (reply != null) {
                        DefaultClientController.this.sendCommand(reply);
                    }
                    if (this.cmd.getMessageCode().charAt(0) == 'S' && DefaultClientController.this.useCompression != DefaultClientController.this.dataChannel.isUsesCompression()) {
                        DefaultClientController.this.dataChannel.setUsesCompression(DefaultClientController.this.useCompression);
                    }
                }
            }
            catch (DisconnectionException ex) {
                Log.CLIENTS.debug((Object)("Disconnection exception while processing command: " + ex.getMessage()), (Throwable)ex);
            }
            catch (SocketException ex) {
                Log.CLIENTS.info((Object)("Socket exception while processing command: " + ex.getMessage()));
                Log.CLIENTS.debug((Object)("Socket exception while processing command: " + ex.getMessage()), (Throwable)ex);
            }
            catch (Exception ex) {
                Log.CLIENTS.warn((Object)("Error processing command: " + ex.getMessage()), (Throwable)ex);
            }
            return null;
        }
    }

    public class ForwardingEventListener
    extends DefaultContextEventListener {
        public ForwardingEventListener(ContextManager contextManager, Integer listenerCode, Expression filter, String fingerprint) {
            super(null, contextManager, listenerCode, filter, fingerprint);
            this.setAcceptEventsWithoutListenerCode(true);
        }

        @Override
        public boolean shouldHandle(Event event) throws EventHandlingException {
            try {
                Context con;
                if (!super.shouldHandle(event)) {
                    return false;
                }
                if (!DefaultClientController.this.controllerShouldHandle(event, this)) {
                    return false;
                }
                return !event.getName().equals("childAdded") || (con = DefaultClientController.this.getContext(event.getContext())) != null && con.getChild(event.getData().rec().getString("child"), this.getCallerController()) != null;
            }
            catch (Exception ex) {
                throw new EventHandlingException(ex.getMessage(), ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(Event event) throws EventHandlingException {
            if (Log.CLIENTS.isDebugEnabled()) {
                Log.CLIENTS.debug((Object)("Handling event '" + event.getName() + "' from context '" + event.getContext() + "' for listener '" + this.getListenerCode() + "' (" + this.toString() + ")"));
            }
            try {
                Context con;
                if (event.getName().equals("infoChanged") && (con = DefaultClientController.this.getContext(event.getContext())) != null) {
                    event.getData().rec().setValue("localRoot", (Object)con.getLocalRoot(true));
                    event.getData().rec().setValue("peerRoot", (Object)con.getPeerRoot());
                    event.getData().rec().setValue("remoteRoot", (Object)con.getRemoteRoot());
                    event.getData().rec().setValue("remotePath", (Object)con.getPeerPath());
                    event.getData().rec().setValue("peerPrimaryRoot", (Object)con.getLocalPrimaryRoot());
                }
                OutgoingAggreGateCommand cmd = DefaultClientController.this.constructEventCommand(event, this.getListenerCode());
                BlockingQueue blockingQueue = DefaultClientController.this.pendingEventCommandsQueue;
                synchronized (blockingQueue) {
                    boolean added = DefaultClientController.this.pendingEventCommandsQueue.offer(cmd);
                    if (!added) {
                        DefaultClientController.this.discardEvent();
                    }
                    if (DefaultClientController.this.pendingEventProcessingTask == null || DefaultClientController.this.pendingEventProcessingTask.isDone()) {
                        try {
                            DefaultClientController.this.pendingEventProcessingTask = DefaultClientController.this.commandExecutionService.submit(new PendingEventProcessingTask());
                        }
                        catch (RejectedExecutionException ex) {
                            Log.CLIENTS.warn((Object)"Cannot schedule new event delivery since command processing pool is overloaded");
                        }
                    }
                }
            }
            catch (Exception ex) {
                throw new EventHandlingException(MessageFormat.format(Cres.get().getString("clErrorHandlingEvent"), event.getName()) + ex.getMessage(), ex);
            }
        }

        public String toString() {
            return "ForwardingEventListener: " + this.getListenerCode();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOwningController().hashCode();
            result = 31 * result + (this.getListenerCode() == null ? 0 : this.getListenerCode().hashCode());
            result = 31 * result + (this.getFilter() == null ? 0 : this.getFilter().hashCode());
            result = 31 * result + (this.getFingerprint() == null ? 0 : this.getFingerprint().hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ForwardingEventListener other = (ForwardingEventListener)obj;
            if (this.getOwningController() != other.getOwningController()) {
                return false;
            }
            if (this.getListenerCode() == null ? other.getListenerCode() != null : other.getListenerCode() == null) {
                return false;
            }
            if (this.getListenerCode().intValue() != other.getListenerCode().intValue()) {
                return false;
            }
            if (this.getFilter() == null ? other.getFilter() != null : !this.getFilter().equals(other.getFilter())) {
                return false;
            }
            return !(this.getFingerprint() == null ? other.getFingerprint() != null : !this.getFingerprint().equals(other.getFingerprint()));
        }

        private DefaultClientController getOwningController() {
            return DefaultClientController.this;
        }

        @Override
        public CallerController getCallerController() {
            return DefaultClientController.this.getCallerController();
        }
    }
}

