/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.communication.Command;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.protocol.DefaultCommandWriter;
import com.tibbo.aggregate.common.protocol.OutgoingAggreGateCommand;
import com.tibbo.aggregate.common.protocol.ProtocolVersion;
import com.tibbo.aggregate.common.util.BlockingChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.Deflater;

public class CompressedCommandWriter<C extends OutgoingAggreGateCommand>
extends DefaultCommandWriter<C> {
    public static final byte TYPE_RAW = 0;
    public static final byte TYPE_COMPRESSED = 1;
    public static final int MINIMAL_COMMAND_SIZE_TO_COMPRESS = 128;
    private final ThreadLocal<Deflater> compressor = ThreadLocal.withInitial(Deflater::new);
    private volatile ProtocolVersion version;
    private volatile ProtocolVersion versionAfterNextWrite = this.version = ProtocolVersion.V2;

    @Override
    public void write(C command, BlockingChannel channel, boolean needsFlushing) throws IOException, DisconnectionException {
        switch (this.version) {
            case V2: {
                super.write(command, channel, needsFlushing);
                break;
            }
            default: {
                ((Command)command).complete();
                ByteBuffer byteBuffer = this.composeByteBuffer(command, channel, cmd -> this.extractCommandBody((OutgoingAggreGateCommand)cmd, channel));
                this.writeBufferToChannel(byteBuffer, command, channel, needsFlushing);
                this.log(command, this.version);
            }
        }
        this.version = this.versionAfterNextWrite;
    }

    protected byte[] extractCommandBody(OutgoingAggreGateCommand command, BlockingChannel channel) {
        boolean commandRequiresCompression = command.size() > 128;
        boolean channelUsesCompression = channel.isUsesCompression();
        boolean compress = channelUsesCompression && commandRequiresCompression;
        byte type = compress ? (byte)1 : 0;
        byte[] contents = this.getContents(command, compress);
        int lengthInBytes = 4;
        int typeInBytes = 1;
        int bodyLength = typeInBytes + contents.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(lengthInBytes + bodyLength);
        byteBuffer.putInt(bodyLength);
        byteBuffer.put(type);
        byteBuffer.put(contents);
        return byteBuffer.array();
    }

    private byte[] getContents(OutgoingAggreGateCommand command, boolean compress) {
        byte[] commandBytes = command.toByteArray();
        if (compress) {
            int commandLength = commandBytes.length;
            ByteArrayOutputStream stream = new ByteArrayOutputStream(commandLength);
            Deflater localCompressor = this.compressor.get();
            localCompressor.reset();
            localCompressor.setInput(commandBytes, 0, command.size());
            localCompressor.finish();
            while (!localCompressor.finished()) {
                byte[] localBuffer = new byte[2048];
                int bytesWritten = localCompressor.deflate(localBuffer);
                stream.write(localBuffer, 0, bytesWritten);
            }
            byte[] compressedCommandBytes = stream.toByteArray();
            if (Log.COMMANDS.isTraceEnabled()) {
                int compressedLength = compressedCommandBytes.length;
                float compressionRatio = (float)commandLength / (float)compressedLength;
                Log.COMMANDS.trace((Object)("Raw size: " + commandLength + ". \tCompressed size: " + compressedLength + ". \tCompression ratio: " + compressionRatio + "."));
            }
            return compressedCommandBytes;
        }
        return commandBytes;
    }

    @Override
    public void setVersion(ProtocolVersion version) {
        this.version = version;
        this.versionAfterNextWrite = version;
    }

    @Override
    public void setVersionAfterNextWrite(ProtocolVersion version) {
        this.versionAfterNextWrite = version;
    }
}

