/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import com.tibbo.aggregate.common.protocol.CommandQueue;
import com.tibbo.aggregate.common.protocol.CommandTask;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;

public class CommandQueueManager {
    private ExecutorService executor;
    private Map<String, CommandQueue> queues = new HashMap<String, CommandQueue>();

    public CommandQueueManager(ExecutorService executor) {
        this.executor = executor;
    }

    public synchronized void addCommand(String queueName, CommandTask command) {
        CommandQueue queue = this.createOrGetQueue(queueName);
        if (queue.getActivityLock().availablePermits() == 0) {
            queue.add(command);
        } else {
            this.submitCommand(queue, command);
        }
    }

    private CommandQueue createOrGetQueue(String name) {
        CommandQueue q = this.queues.get(name);
        if (q == null) {
            q = new CommandQueue();
            this.queues.put(name, q);
        }
        return q;
    }

    private void submitCommand(final CommandQueue queue, final CommandTask command) {
        try {
            queue.getActivityLock().acquire();
        }
        catch (InterruptedException ex) {
            throw new IllegalStateException(ex.getMessage(), ex);
        }
        this.executor.submit(new CommandTask(){

            @Override
            public Object call() throws Exception {
                try {
                    CommandTask cur;
                    Object res = command.call();
                    while ((cur = queue.poll()) != null) {
                        cur.call();
                    }
                    Object var2_2 = null;
                    return var2_2;
                }
                finally {
                    queue.getActivityLock().release();
                }
            }
        });
    }
}

