/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import java.nio.ByteBuffer;

public class CommandData {
    private byte startChar;
    private Header header = new Header();
    private Body body = new Body();

    public CommandData(byte startChar) {
        this.startChar = startChar;
    }

    public void addNextByte(byte nextByte) {
        if (!this.header.isCompleted()) {
            this.header.append(nextByte);
            if (this.header.isCompleted()) {
                this.body.resetFor(this.header.getLength());
            }
        } else if (!this.body.isCompleted()) {
            this.body.append(nextByte);
        }
    }

    public boolean isCompleted() {
        return this.header.isCompleted() && this.body.isCompleted();
    }

    public void reset() {
        this.header.reset();
        this.body.reset();
    }

    public Body getBody() {
        return this.body;
    }

    public class Body
    extends Header {
        protected Byte type;
        protected ByteBuffer contents;

        public Body() {
            this.type = null;
        }

        @Override
        public void append(byte nextByte) {
            if (this.type == null) {
                this.type = nextByte;
            } else {
                this.contents.put(nextByte);
            }
        }

        @Override
        public boolean isCompleted() {
            return this.contents != null && !this.contents.hasRemaining();
        }

        public void resetFor(int length) {
            int typeByte = 1;
            this.contents = ByteBuffer.allocate(length - typeByte);
            this.type = null;
        }

        public Byte getType() {
            return this.type;
        }

        public byte[] getContents() {
            return this.contents.array();
        }
    }

    public class Header {
        private static final byte WAITING_FOR_START = 0;
        private static final byte READING_LENGTH = 1;
        public static final int LENGTH_SIZE = 4;
        ByteBuffer lengthBuffer = ByteBuffer.allocate(4);
        private byte stage = 0;
        private Integer length = null;

        public boolean isCompleted() {
            return this.length != null;
        }

        public void append(byte nextByte) {
            switch (this.stage) {
                case 0: {
                    if (nextByte != CommandData.this.startChar) break;
                    this.stage = 1;
                    break;
                }
                case 1: {
                    this.lengthBuffer.put(nextByte);
                    if (this.lengthBuffer.hasRemaining()) break;
                    this.length = this.lengthBuffer.getInt(0);
                }
            }
        }

        public void reset() {
            this.length = null;
            this.stage = 0;
            this.lengthBuffer.rewind();
        }

        public int getLength() {
            return this.length;
        }
    }
}

