/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import com.tibbo.aggregate.common.communication.SimpleCommandParser;
import com.tibbo.aggregate.common.protocol.CommandData;
import com.tibbo.aggregate.common.protocol.IncomingAggreGateCommand;
import com.tibbo.aggregate.common.protocol.ProtocolVersion;
import com.tibbo.aggregate.common.util.SyntaxErrorException;
import com.tibbo.aggregate.common.util.Util;
import java.io.ByteArrayOutputStream;
import java.nio.channels.ReadableByteChannel;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class AggreGateCommandParser
extends SimpleCommandParser<IncomingAggreGateCommand> {
    private static final byte TYPE_COMPRESSED = 1;
    public final byte[] decompressor_buffer = new byte[1024];
    private Inflater decompressor = new Inflater();
    protected CommandData commandData;
    private ProtocolVersion version = ProtocolVersion.V2;

    public AggreGateCommandParser(ReadableByteChannel channel) {
        this(channel, 2, 13);
    }

    public AggreGateCommandParser(ReadableByteChannel channel, byte startChar, byte endChar) {
        super(channel, startChar, endChar);
        this.commandData = new CommandData(startChar);
    }

    @Override
    protected IncomingAggreGateCommand buildCommand() throws SyntaxErrorException {
        if (ProtocolVersion.V2.equals((Object)this.version)) {
            return (IncomingAggreGateCommand)super.buildCommand();
        }
        IncomingAggreGateCommand commandFrom = this.buildCommandFrom(this.commandData);
        this.reset();
        return commandFrom;
    }

    @Override
    protected boolean commandEnded(byte cur) {
        if (ProtocolVersion.V2.equals((Object)this.version)) {
            return super.commandEnded(cur);
        }
        this.commandData.addNextByte(cur);
        return this.commandData.isCompleted();
    }

    @Override
    public void reset() {
        super.reset();
        if (this.commandData != null) {
            this.commandData.reset();
        }
    }

    @Override
    protected IncomingAggreGateCommand createCommandFromBufferContent() throws SyntaxErrorException {
        return new IncomingAggreGateCommand(this.clearData());
    }

    public void setVersion(ProtocolVersion version) {
        this.version = version;
    }

    protected IncomingAggreGateCommand buildCommandFrom(CommandData commandData) throws SyntaxErrorException {
        if (!commandData.isCompleted()) {
            return null;
        }
        CommandData.Body body = commandData.getBody();
        byte[] data = body.getContents();
        boolean usesCompression = Util.equals(body.getType(), (byte)1);
        if (usesCompression) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            this.decompressor.setInput(data);
            try {
                while (this.decompressor.getRemaining() != 0) {
                    int bytesWritten = this.decompressor.inflate(this.decompressor_buffer);
                    stream.write(this.decompressor_buffer, 0, bytesWritten);
                }
            }
            catch (DataFormatException e) {
                throw new SyntaxErrorException("Error decompressing command.");
            }
            this.decompressor.reset();
            data = stream.toByteArray();
        }
        return new IncomingAggreGateCommand(data);
    }
}

