/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import com.tibbo.aggregate.common.communication.Command;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.DataTableUtils;
import com.tibbo.aggregate.common.datatable.FieldFormat;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.util.StringUtils;

public abstract class AggreGateCommand
extends Command {
    public static final byte START_CHAR = 2;
    public static final byte END_CHAR = 13;
    public static final char COMMAND_CODE_MESSAGE = 'M';
    public static final char COMMAND_CODE_REPLY = 'R';
    public static final char MESSAGE_CODE_START = 'S';
    public static final char MESSAGE_CODE_OPERATION = 'O';
    public static final char MESSAGE_CODE_EVENT = 'E';
    public static final char MESSAGE_CODE_COMPRESSION = 'C';
    public static final char COMMAND_OPERATION_GET_VAR = 'G';
    public static final char COMMAND_OPERATION_SET_VAR = 'S';
    public static final char COMMAND_OPERATION_CALL_FUNCTION = 'C';
    public static final char COMMAND_OPERATION_ADD_EVENT_LISTENER = 'L';
    public static final char COMMAND_OPERATION_REMOVE_EVENT_LISTENER = 'R';
    public static final int INDEX_COMMAND_CODE = 0;
    public static final int INDEX_ID = 1;
    public static final int INDEX_MESSAGE_CODE = 2;
    public static final int INDEX_START_PROTOCOL_VERSION = 3;
    public static final int INDEX_START_COMPRESSION = 4;
    public static final int INDEX_PROTOCOL_VERSION = 3;
    public static final int INDEX_OPERATION_CODE = 3;
    public static final int INDEX_OPERATION_CONTEXT = 4;
    public static final int INDEX_OPERATION_TARGET = 5;
    public static final int INDEX_OPERATION_MESSAGE_DATA_TABLE = 6;
    public static final int INDEX_OPERATION_MESSAGE_QUEUE_NAME = 7;
    public static final int INDEX_OPERATION_MESSAGE_FLAGS = 8;
    public static final int INDEX_OPERATION_LISTENER_CODE = 6;
    public static final int INDEX_OPERATION_FILTER = 7;
    public static final int INDEX_OPERATION_FINGERPRINT = 8;
    public static final int INDEX_EVENT_CONTEXT = 3;
    public static final int INDEX_EVENT_NAME = 4;
    public static final int INDEX_EVENT_LEVEL = 5;
    public static final int INDEX_EVENT_ID = 6;
    public static final int INDEX_EVENT_LISTENER = 7;
    public static final int INDEX_EVENT_DATA_TABLE = 8;
    public static final int INDEX_EVENT_TIMESTAMP = 9;
    public static final int INDEX_EVENT_SERVER_ID = 10;
    public static final int INDEX_REPLY_CODE = 2;
    public static final int INDEX_REPLY_MESSAGE = 3;
    public static final int INDEX_REPLY_DETAILS = 4;
    public static final int INDEX_DATA_TABLE_IN_REPLY = 3;
    public static final String CLIENT_COMMAND_SEPARATOR = String.valueOf('\u0017');
    public static final String CLIENT_COMMAND_VISIBLE_SEPARATOR = "/";
    public static final byte JSON_START_ARRAY_SEPARATOR = 91;
    private static int GENERATED_ID;
    private static final int MAX_PRINTED_LENGTH = 10000;

    @Override
    public String toString() {
        String s = super.toString();
        int len = s.length();
        if ((s = s.substring(0, Math.min(10000, s.length()))).length() >= 10000) {
            s = s + "... (" + len + ")";
        }
        s = s.replaceAll(String.valueOf(CLIENT_COMMAND_SEPARATOR), CLIENT_COMMAND_VISIBLE_SEPARATOR);
        s = s.replaceAll(String.valueOf('\u001c'), String.valueOf('<'));
        s = s.replaceAll(String.valueOf('\u001d'), String.valueOf('>'));
        s = s.replaceAll(String.valueOf('\u001e'), String.valueOf('='));
        s = s.replaceAll(String.valueOf(DataTableUtils.DATA_TABLE_NULL), "<NULL>");
        return s;
    }

    protected static synchronized String generateId() {
        return String.valueOf(++GENERATED_ID);
    }

    public static String checkCommandString(String commandString) {
        StringBuilder checkedCommandSB = new StringBuilder(commandString.length());
        for (String commandPart : commandString.split(CLIENT_COMMAND_VISIBLE_SEPARATOR)) {
            try {
                commandPart = AggreGateCommand.checkCommandPart(commandPart);
            }
            catch (DataTableException dataTableException) {
                // empty catch block
            }
            if (checkedCommandSB.length() > 0) {
                checkedCommandSB.append(CLIENT_COMMAND_VISIBLE_SEPARATOR);
            }
            checkedCommandSB.append(commandPart);
        }
        return checkedCommandSB.toString();
    }

    private static String checkCommandPart(String commandPart) throws DataTableException {
        SimpleDataTable command = new SimpleDataTable(commandPart, new ClassicEncodingSettings(true), true);
        if (command.getFormat().getFieldCount() == 0) {
            return commandPart;
        }
        for (FieldFormat ff : command.getFormat()) {
            if (!"password".equals(ff.getEditor())) continue;
            for (DataRecord rec : command) {
                String passwordString = rec.getString(ff.getName());
                if (StringUtils.isEmpty(passwordString)) continue;
                rec.setValue(ff.getName(), (Object)StringUtils.createMaskedPasswordString(passwordString.length()));
            }
        }
        return command.encode(true);
    }
}

