/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.CallerData;
import com.tibbo.aggregate.common.context.ContextManager;
import com.tibbo.aggregate.common.event.ContextEventListener;
import com.tibbo.aggregate.common.event.ContextEventListenerSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;

public abstract class AbstractClientController<T extends CallerData> {
    private ContextManager contextManager;
    private CallerController callerController;
    private final Map<String, Map<String, ContextEventListenerSet>> listeners = Collections.synchronizedMap(new Hashtable());

    public AbstractClientController(ContextManager contextManager) {
        this.contextManager = contextManager;
    }

    public CallerController getCallerController() {
        return this.callerController;
    }

    public void setCallerController(CallerController callerController) {
        this.callerController = callerController;
    }

    public void addMaskListener(String context, String name, ContextEventListener cel, boolean weak) {
        this.contextManager.addMaskEventListener(context, name, cel, weak);
        if (weak) {
            ContextEventListenerSet eventListeners;
            Map<String, ContextEventListenerSet> contextListeners = this.listeners.get(context);
            if (contextListeners == null) {
                contextListeners = new HashMap<String, ContextEventListenerSet>();
                this.listeners.put(context, contextListeners);
            }
            if ((eventListeners = contextListeners.get(name)) == null) {
                eventListeners = new ContextEventListenerSet(this.contextManager);
                contextListeners.put(name, eventListeners);
            }
            eventListeners.addListener(cel, false);
        }
    }

    public void removeMaskListener(String context, String name, ContextEventListener cel) {
        this.contextManager.removeMaskEventListener(context, name, cel);
        ContextEventListenerSet eventListeners = this.getEventListeners(context, name);
        if (eventListeners != null) {
            eventListeners.removeListener(cel);
        }
    }

    public ContextManager getContextManager() {
        return this.contextManager;
    }

    public void setContextManager(ContextManager contextManager) {
        this.contextManager = contextManager;
    }

    public void shutdown() {
        if (this.callerController != null) {
            this.callerController.logout();
        }
        this.listeners.clear();
    }

    public ContextEventListenerSet getEventListeners(String context, String name) {
        Map<String, ContextEventListenerSet> contextListeners = this.listeners.get(context);
        if (contextListeners == null) {
            return null;
        }
        return contextListeners.get(name);
    }

    public abstract boolean run();
}

