/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.protocol;

import com.tibbo.aggregate.common.AggreGateException;
import com.tibbo.aggregate.common.Cres;
import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.communication.AbstractDeviceController;
import com.tibbo.aggregate.common.communication.CommandParser;
import com.tibbo.aggregate.common.context.CallerController;
import com.tibbo.aggregate.common.context.Context;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.context.ContextSecurityException;
import com.tibbo.aggregate.common.context.DefaultContextManager;
import com.tibbo.aggregate.common.context.EventDefinition;
import com.tibbo.aggregate.common.data.Event;
import com.tibbo.aggregate.common.datatable.DataRecord;
import com.tibbo.aggregate.common.datatable.DataTable;
import com.tibbo.aggregate.common.datatable.DataTableException;
import com.tibbo.aggregate.common.datatable.ProxyDataTable;
import com.tibbo.aggregate.common.datatable.SimpleDataTable;
import com.tibbo.aggregate.common.datatable.TableFormat;
import com.tibbo.aggregate.common.datatable.encoding.ClassicEncodingSettings;
import com.tibbo.aggregate.common.datatable.encoding.FormatCache;
import com.tibbo.aggregate.common.datatable.encoding.RemoteFormatCache;
import com.tibbo.aggregate.common.datatable.encoding.TransferEncodingHelper;
import com.tibbo.aggregate.common.device.DisconnectionException;
import com.tibbo.aggregate.common.device.RemoteDeviceErrorException;
import com.tibbo.aggregate.common.event.FireEventRequestController;
import com.tibbo.aggregate.common.protocol.AbstractAggreGateDeviceControllerDisconnectListener;
import com.tibbo.aggregate.common.protocol.AggreGateCommandParser;
import com.tibbo.aggregate.common.protocol.AggreGateDevice;
import com.tibbo.aggregate.common.protocol.AggreGateDeviceController;
import com.tibbo.aggregate.common.protocol.CompressedCommandWriter;
import com.tibbo.aggregate.common.protocol.IncomingAggreGateCommand;
import com.tibbo.aggregate.common.protocol.OutgoingAggreGateCommand;
import com.tibbo.aggregate.common.protocol.ProtocolCommandBuilder;
import com.tibbo.aggregate.common.protocol.ProtocolVersion;
import com.tibbo.aggregate.common.protocol.ProxyContext;
import com.tibbo.aggregate.common.protocol.RemoteContextManager;
import com.tibbo.aggregate.common.util.Element;
import com.tibbo.aggregate.common.util.ElementList;
import com.tibbo.aggregate.common.util.StringUtils;
import com.tibbo.aggregate.common.util.UserSettings;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.log4j.Logger;

public abstract class AbstractAggreGateDeviceController<D extends AggreGateDevice, C extends RemoteContextManager>
extends AbstractDeviceController<IncomingAggreGateCommand, OutgoingAggreGateCommand>
implements AggreGateDeviceController<IncomingAggreGateCommand, OutgoingAggreGateCommand> {
    public static final String FLAG_NO_REPLY = "N";
    private D device;
    private C contextManager;
    private CallerController callerController;
    private final UserSettings userSettings = new UserSettings();
    private boolean avoidSendingFormats;
    private FormatCache formatCache;
    private ThreadPoolExecutor eventPreprocessor;
    private final int maxEventQueueLength;
    private boolean usesCompression;
    protected final CompressedCommandWriter<OutgoingAggreGateCommand> commandWriter = new CompressedCommandWriter();
    private ProtocolVersion protocolVersion;
    private int rejectedEvents = 0;
    private final ProtocolCommandBuilder commandBuilder;
    private final List<AbstractAggreGateDeviceControllerDisconnectListener> disconnectListeners = new LinkedList<AbstractAggreGateDeviceControllerDisconnectListener>();

    public AbstractAggreGateDeviceController(D device, Logger logger, int maxEventQueueLength) {
        this(device, logger, maxEventQueueLength, false);
    }

    public AbstractAggreGateDeviceController(D device, Logger logger, int maxEventQueueLength, boolean json) {
        super(((AggreGateDevice)device).getCommandTimeout(), logger);
        this.formatCache = new RemoteFormatCache(this, ((AggreGateDevice)device).toString());
        this.commandBuilder = new ProtocolCommandBuilder(json);
        this.device = device;
        this.maxEventQueueLength = maxEventQueueLength;
    }

    public C getContextManager() {
        return this.contextManager;
    }

    public void setContextManager(C contextManager) {
        this.contextManager = contextManager;
    }

    public void setDevice(D device) {
        this.device = device;
    }

    public D getDevice() {
        return this.device;
    }

    @Override
    public CallerController getCallerController() {
        return this.callerController;
    }

    protected void setCallerController(CallerController callerController) {
        this.callerController = callerController;
    }

    public FormatCache getFormatCache() {
        return this.formatCache;
    }

    public void setFormatCache(FormatCache cache) {
        this.formatCache = cache;
    }

    @Override
    public UserSettings getSettings() {
        return this.userSettings;
    }

    public ClassicEncodingSettings createClassicEncodingSettings(boolean forSending) {
        ClassicEncodingSettings es = new ClassicEncodingSettings(false);
        es.setProtocolVersion(this.protocolVersion);
        if (!forSending) {
            es.setFormatCache(this.formatCache);
        }
        es.setEncodeFormat(!this.avoidSendingFormats);
        return es;
    }

    protected void setAvoidSendingFormats(boolean avoidSendingFormats) {
        this.avoidSendingFormats = avoidSendingFormats;
    }

    public boolean isAvoidSendingFormats() {
        return this.avoidSendingFormats;
    }

    @Override
    protected boolean connectImpl() throws DisconnectionException, IOException, InterruptedException, RemoteDeviceErrorException, ContextException {
        ProtocolVersion version;
        this.commandWriter.setVersion(ProtocolVersion.V2);
        AggreGateCommandParser aggreGateCommandParser = (AggreGateCommandParser)this.getCommandParser();
        aggreGateCommandParser.setVersion(ProtocolVersion.V2);
        boolean lastReplyIsOk = false;
        ProtocolVersion[] versions = ProtocolVersion.values();
        IncomingAggreGateCommand ans = null;
        for (int i = versions.length - 1; i >= 0 && !(lastReplyIsOk = (ans = (IncomingAggreGateCommand)this.sendCommand(this.commandBuilder.startMessage((version = versions[i]).notation()))).getReplyCode().equals("A")); --i) {
        }
        if (!lastReplyIsOk) {
            throw new RemoteDeviceErrorException(Cres.get().getString("devUncompatibleVersion"));
        }
        if (ans.hasParameter(3)) {
            String replyVersion = ans.getParameter(3).getString();
            this.protocolVersion = ProtocolVersion.byNotation(replyVersion);
            this.commandWriter.setVersion(this.protocolVersion);
            aggreGateCommandParser.setVersion(this.protocolVersion);
            if (ans.hasParameter(4) && ans.getParameter(4).charAt(0) == 'C') {
                this.setUsesCompression(true);
            }
        }
        this.formatCache.clear();
        return true;
    }

    @Override
    public abstract void start() throws IOException, InterruptedException, ContextException, RemoteDeviceErrorException;

    public void destroy() {
    }

    public void addDisconnectListener(AbstractAggreGateDeviceControllerDisconnectListener disconnectListener) {
        if (disconnectListener != null) {
            this.disconnectListeners.add(disconnectListener);
        }
    }

    @Override
    protected void disconnectImpl() {
        if (this.contextManager != null) {
            ((RemoteContextManager)this.contextManager).stop();
        }
        if (this.eventPreprocessor != null) {
            this.eventPreprocessor.shutdown();
        }
        this.formatCache.clear();
        this.disconnectListeners.forEach(AbstractAggreGateDeviceControllerDisconnectListener::disconnected);
        this.disconnectListeners.clear();
    }

    protected List<ProxyContext> getProxyContexts(String path) {
        ProxyContext con = (ProxyContext)((DefaultContextManager)this.getContextManager()).get(path);
        return con != null ? Collections.singletonList(con) : Collections.emptyList();
    }

    protected ExecutorService getEventPreprocessor() {
        return this.eventPreprocessor;
    }

    public IncomingAggreGateCommand sendCommandAndCheckReplyCode(OutgoingAggreGateCommand cmd) throws DisconnectionException, ContextException, IOException, InterruptedException, RemoteDeviceErrorException {
        IncomingAggreGateCommand ans = (IncomingAggreGateCommand)this.sendCommand(cmd);
        if (ans == null) {
            return null;
        }
        if (ans.getReplyCode().equals("D")) {
            String message = ans.getNumberOfParameters() > 3 ? ": " + TransferEncodingHelper.decode(ans.getParameter(3)) : "";
            throw new ContextSecurityException(Cres.get().getString("devAccessDeniedReply") + message);
        }
        if (ans.getReplyCode().equals("AG-10001")) {
            String message = ans.getNumberOfParameters() > 3 ? ": " + TransferEncodingHelper.decode(ans.getParameter(3)) : "";
            String details = ans.getNumberOfParameters() > 4 ? TransferEncodingHelper.decode(ans.getParameter(4)) : null;
            RemoteDeviceErrorException rdex = new RemoteDeviceErrorException(Cres.get().getString("devServerReturnedError") + message, details);
            rdex.setCode("AG-10001");
            throw rdex;
        }
        if (!ans.getReplyCode().equals("A")) {
            String message = ans.getNumberOfParameters() > 3 ? ": " + TransferEncodingHelper.decode(ans.getParameter(3)) : "";
            String details = ans.getNumberOfParameters() > 4 ? TransferEncodingHelper.decode(ans.getParameter(4)) : null;
            RemoteDeviceErrorException ex = new RemoteDeviceErrorException(Cres.get().getString("devServerReturnedError") + message + " (error code: '" + ans.getReplyCode() + "')", details);
            ex.setCode(ans.getReplyCode());
            throw ex;
        }
        return ans;
    }

    @Override
    protected void processAsyncCommand(IncomingAggreGateCommand cmd) {
        if (Log.COMMANDS.isDebugEnabled()) {
            Log.COMMANDS.debug((Object)("Async command received from server: " + cmd));
        }
        if (cmd.getMessageCode().charAt(0) == 'E') {
            this.processEvent(cmd);
        }
    }

    private void processEvent(final IncomingAggreGateCommand cmd) {
        if (this.eventPreprocessor == null || this.eventPreprocessor.isShutdown()) {
            return;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                block9: {
                    if (!AbstractAggreGateDeviceController.this.isConnected()) {
                        return;
                    }
                    try {
                        String contextPath = cmd.getParameter(3).getString();
                        String eventName = cmd.getParameter(4).getString();
                        int level = Integer.valueOf(cmd.getParameter(5).getString());
                        String idstr = cmd.getParameter(6).getString();
                        Long id = idstr.length() > 0 ? Long.valueOf(idstr) : null;
                        String listenerstr = cmd.getParameter(7).getString();
                        Integer listener = listenerstr.length() > 0 ? Integer.valueOf(listenerstr) : null;
                        List<ProxyContext> contexts = AbstractAggreGateDeviceController.this.getProxyContexts(contextPath);
                        if (contexts.size() == 0) {
                            Log.CONTEXT_EVENTS.info((Object)("Error firing event '" + eventName + "': context '" + contextPath + "' not found"));
                            return;
                        }
                        for (ProxyContext con : contexts) {
                            EventDefinition ed = con.getEventDefinition(eventName);
                            if (ed == null) {
                                Log.CONTEXT_EVENTS.warn((Object)("Error firing event: event '" + eventName + "' not available in context '" + contextPath + "'"));
                                continue;
                            }
                            DataTable data = AbstractAggreGateDeviceController.this.decodeRemoteDataTable(ed.getFormat(), cmd.getEncodedDataTableFromEventMessage());
                            Date timestamp = null;
                            if (cmd.hasParameter(9)) {
                                String timestampstr = cmd.getParameter(9).getString();
                                timestamp = timestampstr.length() > 0 ? new Date(Long.valueOf(timestampstr)) : null;
                            }
                            FireEventRequestController requestController = new FireEventRequestController(false);
                            if (cmd.hasParameter(10)) {
                                requestController.setServerId(cmd.getParameter(10).getString());
                            }
                            Event event = con.fireEvent(ed.getName(), data, level, id, timestamp, listener, null, requestController);
                            AbstractAggreGateDeviceController.this.confirmEvent(con, ed, event);
                        }
                    }
                    catch (Exception ex) {
                        if (AbstractAggreGateDeviceController.this.getLogger() == null) break block9;
                        String msg = "Error processing async command '" + cmd + "'";
                        if (ExceptionUtils.getRootCause((Throwable)ex) instanceof DisconnectionException) {
                            AbstractAggreGateDeviceController.this.getLogger().debug((Object)msg, (Throwable)ex);
                        }
                        AbstractAggreGateDeviceController.this.getLogger().error((Object)msg, (Throwable)ex);
                    }
                }
            }
        };
        try {
            this.eventPreprocessor.execute(task);
        }
        catch (RejectedExecutionException ex) {
            ++this.rejectedEvents;
            this.getLogger().warn((Object)("Error processing asynchronous incoming command since the queue is full. Corresponding event rejected. Total rejected events: " + this.rejectedEvents + ". Command: " + cmd));
        }
    }

    protected void confirmEvent(Context con, EventDefinition def, Event event) throws ContextException {
    }

    @Override
    protected void setCommandParser(CommandParser commandBuffer) {
        super.setCommandParser(commandBuffer);
        this.eventPreprocessor = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Runtime.getRuntime().availableProcessors(), 1000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.maxEventQueueLength), new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "EventPreprocessor/" + AbstractAggreGateDeviceController.this.getDevice());
            }
        }, new ThreadPoolExecutor.AbortPolicy());
        this.eventPreprocessor.allowCoreThreadTimeOut(true);
    }

    public String toString() {
        return ((AggreGateDevice)this.getDevice()).toString();
    }

    public DataTable callRemoteFunction(String context, String name, TableFormat outputFormat, DataTable parameters, String queueName) throws ContextException {
        return this.callRemoteFunction(context, name, outputFormat, parameters, queueName, true);
    }

    public DataTable callRemoteFunction(String context, String name, TableFormat outputFormat, DataTable parameters, String queueName, boolean isReplyRequired) throws ContextException {
        try {
            IncomingAggreGateCommand ans;
            StringBuilder encodedParameters = parameters.encode(new StringBuilder(), this.createClassicEncodingSettings(true), false, 0);
            Boolean isShallowDataReleased = this.releaseShallowData(parameters);
            String flags = !isReplyRequired ? FLAG_NO_REPLY : null;
            OutgoingAggreGateCommand cmd = this.commandBuilder.callFunctionOperation(context, name, encodedParameters.toString(), queueName, flags);
            cmd.setAsync(!isReplyRequired);
            if (isShallowDataReleased.booleanValue()) {
                cmd.setTimeout(600000L);
            }
            return (ans = this.sendCommandAndCheckReplyCode(cmd)) != null ? this.decodeRemoteDataTable(outputFormat, ans.getEncodedDataTableFromReply()) : new SimpleDataTable(outputFormat);
        }
        catch (ContextException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ContextException ce = new ContextException(ex.getMessage(), ex);
            if (ex instanceof AggreGateException) {
                ce.setCode(((AggreGateException)ex).getCode());
            }
            throw ce;
        }
    }

    private Boolean releaseShallowData(DataTable parameters) {
        try {
            if (parameters.getRecordCount() == 0) {
                return false;
            }
            if (!parameters.rec().hasField("actionResponse")) {
                return false;
            }
            DataTable actionResponse = parameters.rec().getDataTable("actionResponse");
            if (actionResponse == null || actionResponse.getRecordCount() < 1) {
                return false;
            }
            DataTable actionParameters = actionResponse.rec().getDataTable("parameters");
            if (actionParameters == null || actionParameters.getRecordCount() < 1) {
                return false;
            }
            DataRecord params = actionParameters.rec();
            Boolean hasShallow = false;
            for (int i = 0; i < params.getFieldCount(); ++i) {
                if (!params.getFormat().getField(i).isShallow() || params.getFormat().getField(i).getType() != 'A') continue;
                params.getData(i).releaseData();
                hasShallow = true;
            }
            return hasShallow;
        }
        catch (Exception ex) {
            Log.COMMANDS.debug((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    protected DataTable decodeRemoteDataTable(TableFormat format, String encodedReply) throws DataTableException {
        if (this.isAvoidSendingFormats()) {
            ClassicEncodingSettings settings = new ClassicEncodingSettings(false, format);
            settings.setProtocolVersion(this.protocolVersion);
            settings.setFormatCache(this.formatCache);
            return this.choseAppropriateDataTable(encodedReply, settings, true);
        }
        try {
            return this.choseAppropriateDataTable(encodedReply, this.createClassicEncodingSettings(false), false);
        }
        catch (Exception ex) {
            throw new DataTableException("Error parsing encoded data table '" + encodedReply + "': " + ex.getMessage(), ex);
        }
    }

    private DataTable choseAppropriateDataTable(String encodedReply, ClassicEncodingSettings settings, boolean validate) throws DataTableException {
        ElementList elements = StringUtils.elements(encodedReply, settings.isUseVisibleSeparators());
        boolean containsID = elements.stream().map(Element::getName).anyMatch("C"::equals);
        return containsID ? new ProxyDataTable(elements, settings, validate, this) : new SimpleDataTable(elements, settings, validate);
    }

    public boolean isUsesCompression() {
        return this.usesCompression;
    }

    public void setUsesCompression(boolean usesCompression) {
        this.usesCompression = usesCompression;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public int getEventQueueLength() {
        return this.eventPreprocessor != null ? this.eventPreprocessor.getQueue().size() : 0;
    }

    public int getRejectedEvents() {
        return this.rejectedEvents;
    }

    public ProtocolCommandBuilder getCommandBuilder() {
        return this.commandBuilder;
    }

    public boolean isPropagateUnifiedSearchRequests() {
        return false;
    }
}

