/*
 * Decompiled with CFR 0.152.
 */
package com.tibbo.aggregate.common.plugin.auth;

import com.tibbo.aggregate.common.Log;
import com.tibbo.aggregate.common.context.ContextException;
import com.tibbo.aggregate.common.plugin.PluginException;
import com.tibbo.aggregate.common.plugin.auth.AuthenticationParams;
import com.tibbo.aggregate.common.plugin.auth.AuthenticationPlugin;
import com.tibbo.aggregate.common.plugin.auth.AuthenticationPluginDecorator;
import com.tibbo.aggregate.common.plugin.auth.AuthenticationResult;
import com.tibbo.aggregate.common.plugin.auth.Authenticator;
import com.tibbo.aggregate.common.protocol.DefaultClientController;
import java.util.Map;

public class ExternalAuthenticator
implements Authenticator {
    private final AuthenticationPlugin authenticationPlugin;

    public ExternalAuthenticator(AuthenticationPlugin authenticationPlugin) {
        this.authenticationPlugin = new AuthenticationPluginDecorator(authenticationPlugin);
    }

    @Override
    public AuthenticationResult authenticate(Map<AuthenticationParams, Object> params) throws ContextException {
        try {
            return this.authenticationPlugin.authenticate(params);
        }
        catch (PluginException ex) {
            Log.SECURITY.warn((Object)ex.getMessage(), (Throwable)ex);
            ContextException cex = new ContextException(ex.getMessage(), ex);
            cex.setCode(DefaultClientController.searchForCode(ex, "D"));
            if (ex.getCode() != null) {
                cex.setCode(ex.getCode());
            }
            throw cex;
        }
    }
}

